/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.openl.CompiledOpenClass;
import org.openl.ICompileContext;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.classloader.OpenLClassLoader;
import org.openl.dependency.IDependencyManager;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.context.IRulesRuntimeContextProvider;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.OpenLRulesMethodHandler;
import org.openl.rules.vm.SimpleRulesVM;
import org.openl.runtime.AEngineFactory;
import org.openl.runtime.ASMProxyFactory;
import org.openl.runtime.ASMProxyHandler;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.IOpenLMethodHandler;
import org.openl.runtime.IRuntimeEnvBuilder;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.validation.ValidatedCompiledOpenClass;
import org.openl.validation.ValidationManager;
import org.openl.vm.IRuntimeEnv;
import org.openl.xls.RulesCompileContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesEngineFactory<T>
extends AEngineFactory {
    private final Logger log = LoggerFactory.getLogger(RulesEngineFactory.class);
    private final IOpenSourceCodeModule sourceCode;
    private InterfaceClassGenerator interfaceClassGenerator = new InterfaceClassGenerator();
    private Class<T> interfaceClass;
    private CompiledOpenClass compiledOpenClass;
    private boolean executionMode;
    private IDependencyManager dependencyManager;
    private IRuntimeEnvBuilder runtimeEnvBuilder = null;

    public void setInterfaceClassGenerator(InterfaceClassGenerator interfaceClassGenerator) {
        this.interfaceClassGenerator = Objects.requireNonNull(interfaceClassGenerator, "interfaceClassGenerator cannot be null");
    }

    public RulesEngineFactory(String sourceFile) {
        super("org.openl.xls");
        this.sourceCode = new URLSourceCodeModule(sourceFile);
    }

    public RulesEngineFactory(String sourceFile, Class<T> interfaceClass) {
        super("org.openl.xls");
        this.sourceCode = new URLSourceCodeModule(sourceFile);
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String sourceFile, String userHome) {
        super("org.openl.xls", userHome);
        this.sourceCode = new URLSourceCodeModule(sourceFile);
    }

    public RulesEngineFactory(String sourceFile, String userHome, Class<T> interfaceClass) {
        super("org.openl.xls", userHome);
        this.setInterfaceClass(interfaceClass);
        this.sourceCode = new URLSourceCodeModule(sourceFile);
    }

    public RulesEngineFactory(IOpenSourceCodeModule sourceCodeModule) {
        super("org.openl.xls");
        this.sourceCode = sourceCodeModule;
    }

    public RulesEngineFactory(IOpenSourceCodeModule sourceCodeModule, Class<T> interfaceClass) {
        super("org.openl.xls");
        this.sourceCode = sourceCodeModule;
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome) {
        super("org.openl.xls", userHome);
        this.sourceCode = source;
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome, Class<T> interfaceClass) {
        super("org.openl.xls", userHome);
        this.sourceCode = source;
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(URL source) {
        super("org.openl.xls");
        this.sourceCode = new URLSourceCodeModule(source);
    }

    public RulesEngineFactory(URL source, Class<T> interfaceClass) {
        super("org.openl.xls");
        this.sourceCode = new URLSourceCodeModule(source);
        Objects.requireNonNull(interfaceClass, "interfaceClass cannot be null");
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, Class<T> interfaceClass) {
        super(openlName);
        this.sourceCode = sourceCode;
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, IOpenSourceCodeModule sourceCode) {
        super(openlName);
        this.sourceCode = sourceCode;
    }

    public RulesEngineFactory(String openlName, String userHome, IOpenSourceCodeModule sourceCode, Class<T> interfaceClass) {
        super(openlName, userHome);
        this.sourceCode = sourceCode;
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, String userHome, IOpenSourceCodeModule sourceCode) {
        super(openlName, userHome);
        this.sourceCode = sourceCode;
    }

    public RulesEngineFactory(String openlName, String userHome, String sourceFile, Class<T> interfaceClass) {
        super(openlName, userHome);
        this.sourceCode = new URLSourceCodeModule(sourceFile);
        this.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, String userHome, String sourceFile) {
        super(openlName, userHome);
        this.sourceCode = new URLSourceCodeModule(sourceFile);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome, String openlName) {
        super(openlName, userHome);
        this.sourceCode = source;
    }

    public void reset(boolean resetInterface) {
        this.reset();
        if (resetInterface) {
            this.setInterfaceClass(null);
        }
    }

    public Class<T> getInterfaceClass() {
        if (this.interfaceClass == null) {
            IOpenClass openClass = this.getCompiledOpenClass().getOpenClassWithErrors();
            String className = openClass.getName();
            ClassLoader classLoader = this.getCompiledOpenClass().getClassLoader();
            try {
                try {
                    Class<?> interfaceClass = classLoader.loadClass(className);
                    this.log.warn("Previously generated interface '{}' has been used as a service class.", (Object)className);
                    this.setInterfaceClass(interfaceClass);
                    return interfaceClass;
                }
                catch (ClassNotFoundException e) {
                    Class<?> interfaceClass = this.interfaceClassGenerator.generateInterface(className, openClass, classLoader);
                    this.setInterfaceClass(interfaceClass);
                    return interfaceClass;
                }
            }
            catch (Exception e) {
                throw new OpenlNotCheckedException("Failed to generate the interface '" + className + "'", (Throwable)e);
            }
        }
        return this.interfaceClass;
    }

    protected IRuntimeEnvBuilder getRuntimeEnvBuilder() {
        if (this.runtimeEnvBuilder == null) {
            this.runtimeEnvBuilder = () -> new SimpleRulesVM().getRuntimeEnv();
        }
        return this.runtimeEnvBuilder;
    }

    protected IOpenLMethodHandler prepareMethodHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        OpenLRulesMethodHandler openLRulesMethodHandler = new OpenLRulesMethodHandler(openClassInstance, methodMap, this.getRuntimeEnvBuilder());
        if (runtimeEnv != null) {
            openLRulesMethodHandler.setRuntimeEnv(runtimeEnv);
        }
        return openLRulesMethodHandler;
    }

    public void setInterfaceClass(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompiledOpenClass initializeOpenClass() {
        CompiledOpenClass compiledOpenClass;
        boolean oldValidationState = ValidationManager.isValidationEnabled();
        try {
            CompiledOpenClass result;
            ValidationManager.turnOffValidation();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (!(oldClassLoader instanceof OpenLClassLoader)) {
                    OpenLClassLoader newClassLoader = new OpenLClassLoader(oldClassLoader);
                    Thread.currentThread().setContextClassLoader((ClassLoader)newClassLoader);
                }
                result = OpenLManager.compileModuleWithErrors((OpenL)this.getOpenL(), (IOpenSourceCodeModule)this.getSourceCode(), (boolean)this.executionMode, (IDependencyManager)this.dependencyManager);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            compiledOpenClass = result;
        }
        finally {
            if (oldValidationState) {
                ValidationManager.turnOnValidation();
            }
        }
        try {
            if (oldValidationState) {
                IBindingContext bindingContext = this.getOpenL().getBinder().makeBindingContext();
                bindingContext.setExecutionMode(this.isExecutionMode());
                ValidationManager.validate((ICompileContext)new RulesCompileContext(), (IOpenClass)compiledOpenClass.getOpenClassWithErrors(), (IBindingContext)bindingContext);
                ValidatedCompiledOpenClass validatedCompiledOpenClass = ValidatedCompiledOpenClass.instanceOf((CompiledOpenClass)compiledOpenClass);
                if (bindingContext.getMessages() != null) {
                    bindingContext.getMessages().forEach(arg_0 -> ((ValidatedCompiledOpenClass)validatedCompiledOpenClass).addMessage(arg_0));
                }
                ValidatedCompiledOpenClass validatedCompiledOpenClass2 = validatedCompiledOpenClass;
                return validatedCompiledOpenClass2;
            }
            CompiledOpenClass compiledOpenClass2 = compiledOpenClass;
            return compiledOpenClass2;
        }
        finally {
            if (this.isExecutionMode()) {
                ((XlsModuleOpenClass)compiledOpenClass.getOpenClassWithErrors()).clearForExecutionMode();
            }
        }
    }

    public T newEngineInstance() {
        return this.newEngineInstance(false);
    }

    public T newEngineInstance(IRuntimeEnv runtimeEnv) {
        return this.newEngineInstance(runtimeEnv, false);
    }

    public T newEngineInstance(IRuntimeEnv runtimeEnv, boolean ignoreCompilationErrors) {
        return (T)this.newInstance(runtimeEnv, ignoreCompilationErrors);
    }

    public T newEngineInstance(boolean ignoreCompilationErrors) {
        return (T)this.newInstance(ignoreCompilationErrors);
    }

    public void reset() {
        this.compiledOpenClass = null;
    }

    public Object prepareInstance(IRuntimeEnv runtimeEnv, boolean ignoreCompilationErrors) {
        try {
            this.compiledOpenClass = this.getCompiledOpenClass();
            IOpenClass openClass = ignoreCompilationErrors ? this.compiledOpenClass.getOpenClassWithErrors() : this.compiledOpenClass.getOpenClass();
            Class<T> interfaceClass = this.getInterfaceClass();
            Map methodMap = this.prepareMethodMap(interfaceClass, openClass);
            Object openClassInstance = openClass.newInstance(runtimeEnv == null ? this.getRuntimeEnvBuilder().buildRuntimeEnv() : runtimeEnv);
            ClassLoader classLoader = interfaceClass.getClassLoader();
            Class[] proxyInterfaces = new Class[]{interfaceClass, IEngineWrapper.class, IRulesRuntimeContextProvider.class};
            return ASMProxyFactory.newProxyInstance((ClassLoader)classLoader, (ASMProxyHandler)this.prepareMethodHandler(openClassInstance, methodMap, runtimeEnv), (Class[])proxyInterfaces);
        }
        catch (OpenlNotCheckedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OpenlNotCheckedException("Failed to instantiate engine instance.", (Throwable)ex);
        }
    }

    public CompiledOpenClass getCompiledOpenClass() {
        if (this.compiledOpenClass == null) {
            this.compiledOpenClass = this.initializeOpenClass();
        }
        return this.compiledOpenClass;
    }

    public boolean isExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(boolean executionMode) {
        this.executionMode = executionMode;
    }

    public IOpenSourceCodeModule getSourceCode() {
        return this.sourceCode;
    }

    public IDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public void setDependencyManager(IDependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
    }
}

