/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.GridTool;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableRemoveAction;

public class UndoableRemoveRowsAction
extends UndoableRemoveAction {
    final int nRows;
    final int startRow;
    private final MetaInfoWriter metaInfoWriter;

    public UndoableRemoveRowsAction(int nRows, int startRow, MetaInfoWriter metaInfoWriter) {
        this.nRows = nRows;
        this.startRow = startRow;
        this.metaInfoWriter = metaInfoWriter;
    }

    @Override
    protected boolean canPerformAction(IGridRegion gridRegion) {
        return this.startRow >= 0 && this.startRow < IGridRegion.Tool.height(gridRegion);
    }

    @Override
    protected GridRegionAction getGridRegionAction(IGridRegion gridRegion, int numberToRemove) {
        return new GridRegionAction(gridRegion, false, false, GridRegionAction.ActionType.EXPAND, numberToRemove);
    }

    @Override
    protected int getNumberToRemove(IGridTable table) {
        return this.nRows;
    }

    @Override
    protected IUndoableGridTableAction performAction(int numberToRemove, IGridRegion fullTableRegion, IGridTable table) {
        return GridTool.removeRows(numberToRemove, this.startRow, fullTableRegion, table.getGrid(), this.metaInfoWriter);
    }
}

