/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.BaseParameterExport;
import org.openl.rules.testmethod.export.Cursor;
import org.openl.rules.testmethod.export.ExportUtils;
import org.openl.rules.testmethod.export.FieldDescriptor;
import org.openl.rules.testmethod.export.Styles;
import org.openl.util.CollectionUtils;

public class FlattenParameterExport
extends BaseParameterExport {
    private static final Comparator<FieldDescriptor> FIELD_ORDER = Comparator.comparing(field -> field.getField().getName());

    FlattenParameterExport(Styles styles) {
        super(styles);
    }

    @Override
    int doWrite(SXSSFSheet sheet, Cursor start, TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields, Boolean skipEmptyParameters) {
        TestDescription[] descriptions = test.getTestSuite().getTests();
        sheet.trackAllColumnsForAutoSizing();
        int rowNum = this.createAndWriteRowIds((Sheet)sheet, start, descriptions);
        ParameterWithValueDeclaration[] params = test.getTestSuite().getTest(0).getExecutionParams();
        for (int pNum = 0; pNum < params.length; ++pNum) {
            int paramN = pNum;
            Function<Object, Optional<Object>> getFieldValueChain = description -> Optional.ofNullable(((TestDescription)description).getExecutionParams()).filter(execParams -> paramN < ((ParameterWithValueDeclaration[])execParams).length).map(execParams -> execParams[paramN].getValue());
            int maxArraySize = FlattenParameterExport.getMaxArraySize(descriptions, getFieldValueChain);
            List<FieldDescriptor> fields = nonEmptyFields.get(pNum);
            if (maxArraySize > 0) {
                for (int i = 0; i < maxArraySize; ++i) {
                    int idx = i;
                    rowNum = this.createAndWriteRowValues((Sheet)sheet, new Cursor(rowNum, start.getColNum()), params[paramN].getName() + "[" + i + "]", fields, descriptions, getFieldValueChain.andThen(opt -> opt.filter(arr -> idx < Array.getLength(arr)).map(arr -> Array.get(arr, idx))), skipEmptyParameters);
                }
                continue;
            }
            rowNum = this.createAndWriteRowValues((Sheet)sheet, new Cursor(rowNum, start.getColNum()), params[paramN].getName(), fields, descriptions, getFieldValueChain, skipEmptyParameters);
        }
        for (int col = 1; col < descriptions.length + 2; ++col) {
            sheet.autoSizeColumn(col);
        }
        return rowNum;
    }

    private int createAndWriteRowIds(Sheet sheet, Cursor start, TestDescription[] descriptions) {
        int colNum = start.getColNum();
        TreeSet<BaseParameterExport.WriteTask> tasks = new TreeSet<BaseParameterExport.WriteTask>();
        tasks.add(new BaseParameterExport.WriteTask(new Cursor(start.getRowNum(), colNum++), "ID", this.styles.header));
        for (TestDescription description : descriptions) {
            tasks.add(new BaseParameterExport.WriteTask(new Cursor(start.getRowNum(), colNum++), description.getId(), this.styles.parameterValue));
        }
        this.performWrite(sheet, start, tasks, colNum - 1);
        return start.getRowNum() + 1;
    }

    private int createAndWriteRowValues(Sheet sheet, Cursor start, String namePrefix, List<FieldDescriptor> fields, TestDescription[] descriptions, Function<Object, Optional<Object>> getFieldValueChain, Boolean skipEmptyParameters) {
        int rowNum = start.getRowNum();
        if (CollectionUtils.isEmpty(fields)) {
            TreeSet<BaseParameterExport.WriteTask> tasks = new TreeSet<BaseParameterExport.WriteTask>();
            int colNum = start.getColNum();
            tasks.add(new BaseParameterExport.WriteTask(new Cursor(start.getRowNum(), colNum++), namePrefix, this.styles.header));
            boolean emptyRow = true;
            for (TestDescription description : descriptions) {
                Object fieldValue = getFieldValueChain.apply(description).orElse(null);
                if (!(fieldValue == null || fieldValue.getClass().isArray() && Array.getLength(fieldValue) == 0)) {
                    emptyRow = false;
                }
                tasks.add(new BaseParameterExport.WriteTask(new Cursor(start.getRowNum(), colNum++), fieldValue, this.styles.parameterValue));
            }
            if (skipEmptyParameters.booleanValue() && emptyRow) {
                return rowNum;
            }
            this.performWrite(sheet, start, tasks, colNum - 1);
            return ++rowNum;
        }
        fields.sort(FIELD_ORDER);
        for (FieldDescriptor field : fields) {
            String fieldChainName = namePrefix + "." + field.getField().getName();
            Function<Object, Optional<Object>> nextValueChain = getFieldValueChain.andThen(opt -> opt.map(obj -> ExportUtils.fieldValue(obj, field.getField())));
            List<FieldDescriptor> children = field.getChildren();
            if (field.isArray()) {
                int maxSize = FlattenParameterExport.getMaxArraySize(descriptions, nextValueChain);
                for (int i = 0; i < maxSize; ++i) {
                    int idx = i;
                    rowNum = this.createAndWriteRowValues(sheet, new Cursor(rowNum, start.getColNum()), fieldChainName + "[" + i + "]", children, descriptions, nextValueChain.andThen(opt -> opt.filter(arr -> idx < Array.getLength(arr)).map(arr -> Array.get(arr, idx))), skipEmptyParameters);
                }
                continue;
            }
            rowNum = this.createAndWriteRowValues(sheet, new Cursor(rowNum, start.getColNum()), fieldChainName, children, descriptions, nextValueChain, skipEmptyParameters);
        }
        return rowNum;
    }

    private static int getMaxArraySize(TestDescription[] descriptions, Function<Object, Optional<Object>> getFieldValueChain) {
        return Stream.of(descriptions).map(desc -> ((Optional)getFieldValueChain.apply(desc)).orElse(null)).filter(Objects::nonNull).filter(o -> o.getClass().isArray()).map(Array::getLength).max(Comparator.naturalOrder()).orElse(0);
    }
}

