/*
 * Decompiled with CFR 0.152.
 */
package org.openl.j;

import java.util.Stack;

class BracketMatcher {
    private final Stack<BracketsStackObject> stack = new Stack();

    BracketMatcher() {
    }

    BracketsStackObject addToken(String image, Object id) {
        char c = image.charAt(0);
        Brackets b = Brackets.isBracket(c);
        if (b == null) {
            return null;
        }
        if (b.isOpen(c)) {
            this.stack.push(new BracketsStackObject(b, id));
            return null;
        }
        if (b.isClosed(c)) {
            if (this.stack.isEmpty()) {
                return new BracketsStackObject(b, id, ErrorType.UNEXPECTED);
            }
            BracketsStackObject bso = this.stack.pop();
            if (bso.bracket.isClosed(c)) {
                return null;
            }
            bso.errorCode = ErrorType.MISMATCHED;
            return bso;
        }
        throw new IllegalStateException("Wrong bracket - cannot happen.");
    }

    BracketsStackObject checkAtTheEnd() {
        if (this.stack.isEmpty()) {
            return null;
        }
        BracketsStackObject bso = this.stack.pop();
        bso.errorCode = ErrorType.UNMATCHED;
        return bso;
    }

    public static enum ErrorType {
        UNEXPECTED,
        MISMATCHED,
        UNMATCHED;

    }

    public static class BracketsStackObject {
        final Brackets bracket;
        final Object id;
        ErrorType errorCode;

        public Object getId() {
            return this.id;
        }

        ErrorType getErrorCode() {
            return this.errorCode;
        }

        BracketsStackObject(Brackets bracket, Object id, ErrorType errorCode) {
            this.bracket = bracket;
            this.id = id;
            this.errorCode = errorCode;
        }

        BracketsStackObject(Brackets bracket, Object id) {
            this.bracket = bracket;
            this.id = id;
        }
    }

    static enum Brackets {
        ROUND("()"),
        CURLY("{}"),
        SQUARE("[]");

        private final String brackets;

        private Brackets(String brackets) {
            this.brackets = brackets;
        }

        boolean isOpen(char c) {
            return c == this.brackets.charAt(0);
        }

        boolean isClosed(char c) {
            return c == this.brackets.charAt(1);
        }

        static Brackets isBracket(char c) {
            for (int i = 0; i < Brackets.values().length; ++i) {
                Brackets test = Brackets.values()[i];
                if (!test.isClosed(c) && !test.isOpen(c)) continue;
                return test;
            }
            return null;
        }
    }
}

