/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.binding.exception.AmbiguousFieldException;
import org.openl.binding.exception.DuplicatedFieldException;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.VOID;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.binding.impl.module.ModuleSpecificType;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.AnySpreadsheetResultOpenClass;
import org.openl.rules.calc.CastingCustomSpreadsheetResultField;
import org.openl.rules.calc.CombinedSpreadsheetResultOpenClass;
import org.openl.rules.calc.CustomSpreadsheetResultConstructor;
import org.openl.rules.calc.CustomSpreadsheetResultField;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultBeanByteCodeGenerator;
import org.openl.rules.calc.SpreadsheetResultBeanClass;
import org.openl.rules.calc.SpreadsheetResultBeanPropertyNamingStrategy;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayUtils;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSpreadsheetResultOpenClass
extends ADynamicClass
implements ModuleSpecificType {
    private final Logger log = LoggerFactory.getLogger(CustomSpreadsheetResultOpenClass.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Comparator<String> FIELD_COMPARATOR = (o1, o2) -> {
        char c2;
        char c1 = Character.toUpperCase(o1.charAt(0));
        if (c1 != (c2 = Character.toUpperCase(o2.charAt(0)))) {
            return c1 - c2;
        }
        int len1 = o1.length();
        int len2 = o2.length();
        int lim = Math.min(len1, len2);
        for (int k = 1; k < lim; ++k) {
            c1 = o1.charAt(k);
            if (c1 == (c2 = o2.charAt(k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    };
    private String[] rowNames;
    private String[] columnNames;
    private String[] rowNamesForResultModel;
    private String[] columnNamesForResultModel;
    private Map<String, Point> fieldsCoordinates;
    private final XlsModuleOpenClass module;
    private volatile Class<?> beanClass;
    private boolean simpleRefByRow;
    private boolean simpleRefByColumn;
    private boolean ignoreCompilation;
    private ILogicalTable logicalTable;
    private volatile byte[] beanClassByteCode;
    protected volatile String beanClassName;
    volatile Map<String, List<IOpenField>> beanFieldsMap;
    volatile Map<String, String> xmlNamesMap;
    private volatile boolean initializing;
    private final boolean spreadsheet;
    private final Collection<Consumer<CustomSpreadsheetResultOpenClass>> eventsOnUpdateWithType = new ArrayList<Consumer<CustomSpreadsheetResultOpenClass>>();
    private static final Comparator<Pair<Point, IOpenField>> COMP = Comparator.comparing(Pair::getLeft, Comparator.nullsLast(Comparator.comparingInt(Point::getRow).thenComparingInt(Point::getColumn)));

    public CustomSpreadsheetResultOpenClass(String name, String[] rowNames, String[] columnNames, String[] rowNamesForResultModel, String[] columnNamesForResultModel, XlsModuleOpenClass module, boolean spreadsheet) {
        super(name, SpreadsheetResult.class);
        this.rowNames = Objects.requireNonNull(rowNames);
        this.columnNames = Objects.requireNonNull(columnNames);
        this.rowNamesForResultModel = Objects.requireNonNull(rowNamesForResultModel);
        this.columnNamesForResultModel = Objects.requireNonNull(columnNamesForResultModel);
        long columnsForResultModelCount = Arrays.stream(columnNamesForResultModel).filter(Objects::nonNull).count();
        long rowsForResultModelCount = Arrays.stream(rowNamesForResultModel).filter(Objects::nonNull).count();
        this.simpleRefByRow = columnsForResultModelCount == 1L;
        this.simpleRefByColumn = rowsForResultModelCount == 1L;
        this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates2(this.columnNames, this.rowNames, this.columnNamesForResultModel, this.rowNamesForResultModel);
        this.module = module;
        this.spreadsheet = spreadsheet;
    }

    public CustomSpreadsheetResultOpenClass(String name, XlsModuleOpenClass module, ILogicalTable logicalTable, boolean spreadsheet) {
        this(name, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, module, spreadsheet);
        this.simpleRefByRow = true;
        this.simpleRefByColumn = true;
        this.logicalTable = logicalTable;
    }

    public boolean isSimpleRefByColumn() {
        return this.simpleRefByColumn;
    }

    public boolean isSimpleRefByRow() {
        return this.simpleRefByRow;
    }

    public boolean isSpreadsheet() {
        return this.spreadsheet;
    }

    public IOpenClass getClosestClass(ModuleSpecificType openClass) {
        return this.getParentClass(openClass);
    }

    public IOpenClass getParentClass(ModuleSpecificType openClass) {
        if (openClass instanceof CustomSpreadsheetResultOpenClass) {
            CustomSpreadsheetResultOpenClass csroc = (CustomSpreadsheetResultOpenClass)openClass;
            if (this.getModule().isDependencyModule(csroc.getModule(), new IdentityHashMap())) {
                return this.getModule().buildOrGetCombinedSpreadsheetResult(this, csroc);
            }
            return AnySpreadsheetResultOpenClass.INSTANCE;
        }
        return null;
    }

    public void addField(IOpenField field) throws DuplicatedFieldException {
        if (!(field instanceof CustomSpreadsheetResultField)) {
            throw new IllegalStateException(String.format("Expected type '%s', but found type '%s'.", CustomSpreadsheetResultField.class.getTypeName(), field.getClass().getTypeName()));
        }
        super.addField(field);
    }

    public boolean isAssignableFrom(IOpenClass ioc) {
        if (ioc instanceof CustomSpreadsheetResultOpenClass && !(ioc instanceof CombinedSpreadsheetResultOpenClass)) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)ioc;
            return this.getModule().isDependencyModule(customSpreadsheetResultOpenClass.getModule(), new IdentityHashMap()) && this.getName().equals(customSpreadsheetResultOpenClass.getName());
        }
        return false;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public byte[] getBeanClassByteCode() {
        return (byte[])this.beanClassByteCode.clone();
    }

    public Collection<IOpenClass> superClasses() {
        return Collections.singleton(this.getModule().getSpreadsheetResultOpenClassWithResolvedFieldTypes());
    }

    protected IOpenField searchFieldFromSuperClass(String fname, boolean strictMatch) throws AmbiguousFieldException {
        return null;
    }

    public XlsModuleOpenClass getModule() {
        return this.module;
    }

    private void extendSpreadsheetResult(String[] rowNames, String[] columnNames, String[] rowNamesForResultModel, String[] columnNamesForResultModel, Collection<IOpenField> fields, boolean simpleRefByRow, boolean simpleRefByColumn) {
        int k;
        int i;
        if (this.beanClass != null) {
            throw new IllegalStateException("Bean class for custom spreadsheet result is already generated. This spreadsheet result type cannot be extended.");
        }
        List<String> nRowNames = Arrays.stream(this.rowNames).collect(Collectors.toList());
        List<String> nRowNamesForResultModel = Arrays.stream(this.rowNamesForResultModel).collect(Collectors.toList());
        Set existedRowNamesSet = Arrays.stream(this.rowNames).collect(Collectors.toSet());
        List<String> nColumnNames = Arrays.stream(this.columnNames).collect(Collectors.toList());
        List<String> nColumnNamesForResultModel = Arrays.stream(this.columnNamesForResultModel).collect(Collectors.toList());
        Set existedColumnNamesSet = Arrays.stream(this.columnNames).collect(Collectors.toSet());
        boolean rowColumnsForResultModelNeedUpdate = false;
        for (i = 0; i < rowNames.length; ++i) {
            if (!existedRowNamesSet.contains(rowNames[i])) {
                nRowNames.add(rowNames[i]);
                nRowNamesForResultModel.add(rowNamesForResultModel[i]);
                rowColumnsForResultModelNeedUpdate = true;
                continue;
            }
            if (rowNamesForResultModel[i] == null) continue;
            k = nRowNames.indexOf(rowNames[i]);
            nRowNamesForResultModel.set(k, rowNamesForResultModel[i]);
            rowColumnsForResultModelNeedUpdate = true;
        }
        for (i = 0; i < columnNames.length; ++i) {
            if (!existedColumnNamesSet.contains(columnNames[i])) {
                nColumnNames.add(columnNames[i]);
                nColumnNamesForResultModel.add(columnNamesForResultModel[i]);
                rowColumnsForResultModelNeedUpdate = true;
                continue;
            }
            if (columnNamesForResultModel[i] == null) continue;
            k = nColumnNames.indexOf(columnNames[i]);
            nColumnNamesForResultModel.set(k, columnNamesForResultModel[i]);
            rowColumnsForResultModelNeedUpdate = true;
        }
        if (rowColumnsForResultModelNeedUpdate) {
            this.simpleRefByRow = simpleRefByRow && this.simpleRefByRow;
            this.simpleRefByColumn = simpleRefByColumn && this.simpleRefByColumn;
            this.rowNamesForResultModel = nRowNamesForResultModel.toArray(EMPTY_STRING_ARRAY);
            this.columnNamesForResultModel = nColumnNamesForResultModel.toArray(EMPTY_STRING_ARRAY);
            this.rowNames = nRowNames.toArray(EMPTY_STRING_ARRAY);
            this.columnNames = nColumnNames.toArray(EMPTY_STRING_ARRAY);
            this.fieldsCoordinates = Collections.unmodifiableMap(SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames, this.simpleRefByColumn, this.simpleRefByRow));
        }
        for (IOpenField field : fields) {
            IOpenField thisField = this.getField(field.getName());
            if (thisField == null) {
                this.addField((IOpenField)new CustomSpreadsheetResultField(this, field));
                continue;
            }
            this.fieldMap().put(field.getName(), new CastingCustomSpreadsheetResultField((IOpenClass)this, field.getName(), thisField, field));
        }
    }

    public String[] getRowNames() {
        return (String[])this.rowNames.clone();
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public Map<String, Point> getFieldsCoordinates() {
        return this.fieldsCoordinates;
    }

    public void updateWithType(IOpenClass openClass) {
        if (this.beanClassByteCode != null) {
            throw new IllegalStateException("Java bean class for custom spreadsheet result is loaded to classloader. Custom spreadsheet result cannot be extended.");
        }
        if (openClass instanceof SpreadsheetResultOpenClass) {
            this.updateWithType((IOpenClass)((SpreadsheetResultOpenClass)openClass).toCustomSpreadsheetResultOpenClass());
            return;
        }
        CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)openClass;
        if (customSpreadsheetResultOpenClass.getModule() != this.getModule()) {
            customSpreadsheetResultOpenClass = customSpreadsheetResultOpenClass.convertToModuleType(this.getModule(), false);
        }
        this.extendSpreadsheetResult(customSpreadsheetResultOpenClass.rowNames, customSpreadsheetResultOpenClass.columnNames, customSpreadsheetResultOpenClass.rowNamesForResultModel, customSpreadsheetResultOpenClass.columnNamesForResultModel, customSpreadsheetResultOpenClass.getFields(), customSpreadsheetResultOpenClass.simpleRefByRow, customSpreadsheetResultOpenClass.simpleRefByColumn);
        this.eventsOnUpdateWithType.forEach(e -> e.accept(this));
    }

    public void addEventOnUpdateWithType(Consumer<CustomSpreadsheetResultOpenClass> c) {
        this.eventsOnUpdateWithType.add(c);
    }

    public Collection<IOpenField> getFields() {
        return Collections.unmodifiableCollection(this.fieldMap().values());
    }

    private IOpenField fixModuleFieldType(IOpenField openField) {
        IOpenClass type = openField.getType();
        int dim = 0;
        while (type.isArray()) {
            type = type.getComponentClass();
            ++dim;
        }
        IOpenClass t = this.getModule().toModuleType(type);
        if (t != type) {
            if (dim > 0) {
                t = t.getArrayType(dim);
            }
            return new CustomSpreadsheetResultField((IOpenClass)this, openField.getName(), t);
        }
        return openField;
    }

    public CustomSpreadsheetResultOpenClass convertToModuleTypeAndRegister(ModuleOpenClass module) {
        return this.convertToModuleType(module, true);
    }

    protected CustomSpreadsheetResultOpenClass convertToModuleType(ModuleOpenClass module, boolean register) {
        if (this.getModule() != module) {
            if (register && module.findType(this.getName()) != null) {
                throw new IllegalStateException("Type has already exists in the module.");
            }
            CustomSpreadsheetResultOpenClass type = new CustomSpreadsheetResultOpenClass(this.getName(), this.rowNames, this.columnNames, this.rowNamesForResultModel, this.columnNamesForResultModel, (XlsModuleOpenClass)module, this.spreadsheet);
            type.simpleRefByRow = this.simpleRefByRow;
            type.simpleRefByColumn = this.simpleRefByColumn;
            if (register) {
                module.addType((IOpenClass)type);
            }
            for (IOpenField field : this.getFields()) {
                if (field instanceof CustomSpreadsheetResultField) {
                    type.addField(type.fixModuleFieldType(field));
                    continue;
                }
                type.addField(field);
            }
            type.setMetaInfo(this.getMetaInfo());
            type.logicalTable = this.logicalTable;
            return type;
        }
        return this;
    }

    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public Object newInstance(IRuntimeEnv env) {
        SpreadsheetResult spr = new SpreadsheetResult(new Object[this.rowNames.length][this.columnNames.length], this.rowNames, this.columnNames, this.rowNamesForResultModel, this.columnNamesForResultModel, this.fieldsCoordinates);
        spr.setCustomSpreadsheetResultOpenClass(this);
        spr.setLogicalTable(this.logicalTable);
        return spr;
    }

    public Object createBean(SpreadsheetResult spreadsheetResult) {
        return this.createBean(spreadsheetResult, null);
    }

    public Object createBean(SpreadsheetResult spreadsheetResult, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        Class<?> clazz = this.getBeanClass();
        return CustomSpreadsheetResultOpenClass.createBean(clazz, spreadsheetResult, spreadsheetResultBeanPropertyNamingStrategy);
    }

    public static Object createBean(Class<?> clazz, final SpreadsheetResult spreadsheetResult, final SpreadsheetResultBeanPropertyNamingStrategy namingStrategy) {
        try {
            Method method = clazz.getMethod("valueOf", SpreadsheetResult.class, BiFunction.class);
            return method.invoke(null, spreadsheetResult, new BiFunction<Object, Class<?>, Object>(){

                @Override
                public Object apply(Object v, Class<?> toClass) {
                    IOpenCast cast;
                    XlsModuleOpenClass module;
                    Object newCollection;
                    SpreadsheetResult sr;
                    CustomSpreadsheetResultOpenClass customClass;
                    if (v == null) {
                        return JavaOpenClass.getOpenClass(toClass).nullObject();
                    }
                    Class<?> fromClass = v.getClass();
                    if (toClass.equals(Object.class) && v instanceof SpreadsheetResult && (customClass = (sr = (SpreadsheetResult)v).getCustomSpreadsheetResultOpenClass()) != null) {
                        return customClass.createBean(sr, namingStrategy);
                    }
                    Class<?> toComponentType = toClass;
                    while (toComponentType.isArray()) {
                        toComponentType = toComponentType.getComponentType();
                    }
                    if (toComponentType.equals(Object.class) && fromClass.isArray()) {
                        Class<?> fromComponentType = fromClass;
                        while (fromComponentType.isArray()) {
                            fromComponentType = fromComponentType.getComponentType();
                        }
                        if (SpreadsheetResult.class.isAssignableFrom(fromComponentType)) {
                            return ArrayUtils.convert((Object)v, x -> this.apply(x, Object.class));
                        }
                    }
                    if (v instanceof SpreadsheetResult && toClass.isAnnotationPresent(SpreadsheetResultBeanClass.class)) {
                        return CustomSpreadsheetResultOpenClass.createBean(toClass, (SpreadsheetResult)v, namingStrategy);
                    }
                    if (v instanceof Collection) {
                        try {
                            newCollection = (Collection)v.getClass().newInstance();
                            for (Object o : (Collection)v) {
                                newCollection.add(this.apply(o, Object.class));
                            }
                            return newCollection;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            return v;
                        }
                    }
                    if (v instanceof Map) {
                        try {
                            newCollection = (Map)v.getClass().newInstance();
                            for (Map.Entry o : ((Map)v).entrySet()) {
                                newCollection.put(this.apply(o.getKey(), Object.class), this.apply(o.getValue(), Object.class));
                            }
                            return newCollection;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            return v;
                        }
                    }
                    if (ClassUtils.isAssignable(fromClass, toClass)) {
                        return v;
                    }
                    if (toClass.isArray()) {
                        Class<?> componentType = toClass.getComponentType();
                        if (v.getClass().isArray()) {
                            int len = Array.getLength(v);
                            Object array = Array.newInstance(componentType, len);
                            for (int i = 0; i < len; ++i) {
                                Array.set(array, i, this.apply(Array.get(v, i), componentType));
                            }
                            return array;
                        }
                        Object array = Array.newInstance(componentType, 1);
                        Array.set(array, 0, this.apply(v, componentType));
                        return array;
                    }
                    CustomSpreadsheetResultOpenClass openClass = spreadsheetResult.getCustomSpreadsheetResultOpenClass();
                    if (openClass != null && (module = openClass.getModule()) != null && (cast = module.getObjectToDataOpenCastConvertor().getConvertor(fromClass, toClass)) != null && cast.isImplicit()) {
                        return cast.convert(v);
                    }
                    return SpreadsheetResult.convertSpreadsheetResult(v, toClass, null, namingStrategy);
                }
            });
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isBeanClassInitialized() {
        return this.beanClass != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getBeanClass() {
        if (this.beanClass == null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = this;
            synchronized (customSpreadsheetResultOpenClass) {
                if (this.beanClass == null) {
                    try {
                        this.generateBeanClass();
                        this.beanClass = this.getModule().getClassGenerationClassLoader().loadClass(this.getBeanClassName());
                    }
                    catch (Exception | LinkageError e) {
                        throw new IllegalStateException(String.format("Failed to create bean class for '%s' spreadsheet result.", this.getName()), e);
                    }
                }
            }
        }
        return this.beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateBeanClass() {
        if (this.beanClassByteCode == null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = this;
            synchronized (customSpreadsheetResultOpenClass) {
                if (this.beanClassByteCode == null && !this.initializing) {
                    try {
                        this.initializing = true;
                        TreeMap<String, String> xmlNames = new TreeMap<String, String>(FIELD_COMPARATOR);
                        List[][] used = new List[this.rowNames.length][this.columnNames.length];
                        HashMap<String, List<IOpenField>> fieldsMap = new HashMap<String, List<IOpenField>>();
                        List<Pair<Point, IOpenField>> fields = this.getListOfFields();
                        IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache = new IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>>();
                        ArrayList<SpreadsheetResultBeanByteCodeGenerator.FieldDescription> beanFields = new ArrayList<SpreadsheetResultBeanByteCodeGenerator.FieldDescription>();
                        this.addFieldsToJavaClassBuilder(beanFields, fields, used, xmlNames, true, fieldsMap, cache);
                        this.addFieldsToJavaClassBuilder(beanFields, fields, used, xmlNames, false, fieldsMap, cache);
                        String beanClassName = this.getBeanClassName();
                        byte[] bc = SpreadsheetResultBeanByteCodeGenerator.byteCode(beanClassName, beanFields);
                        this.getModule().getClassGenerationClassLoader().addGeneratedClass(beanClassName, bc);
                        this.beanFieldsMap = Collections.unmodifiableMap(fieldsMap);
                        this.xmlNamesMap = Collections.unmodifiableMap(xmlNames);
                        this.beanClassByteCode = bc;
                    }
                    finally {
                        this.initializing = false;
                    }
                }
            }
        }
    }

    private List<Pair<Point, IOpenField>> getListOfFields() {
        return this.getFields().stream().map(e -> Pair.of((Object)this.fieldsCoordinates.get(e.getName()), (Object)e)).sorted(COMP).collect(Collectors.toList());
    }

    public Map<String, List<IOpenField>> getBeanFieldsMap() {
        if (this.beanFieldsMap == null) {
            this.generateBeanClass();
        }
        return this.beanFieldsMap;
    }

    public Map<String, String> getXmlNamesMap() {
        if (this.xmlNamesMap == null) {
            this.generateBeanClass();
        }
        return this.xmlNamesMap;
    }

    public boolean isExternalCustomSpreadsheetResultOpenClass(CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass, IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache) {
        return !this.getModule().isDependencyModule(customSpreadsheetResultOpenClass.getModule(), cache);
    }

    public boolean isExternalSpreadsheetResultOpenClass(SpreadsheetResultOpenClass spreadsheetResultOpenClass, IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache) {
        return !this.getModule().isDependencyModule(spreadsheetResultOpenClass.getModule(), cache);
    }

    private void addFieldsToJavaClassBuilder(List<SpreadsheetResultBeanByteCodeGenerator.FieldDescription> beanFields, List<Pair<Point, IOpenField>> fields, List<IOpenField>[][] used, Map<String, String> usedXmlNames, boolean addFieldNameWithCollisions, Map<String, List<IOpenField>> beanFieldsMap, IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache) {
        for (Pair<Point, IOpenField> pair : fields) {
            Point point = (Point)pair.getLeft();
            if (point == null) continue;
            int row = point.getRow();
            int column = point.getColumn();
            String rowName = this.rowNamesForResultModel[row];
            String columnName = this.columnNamesForResultModel[column];
            if (rowName == null || columnName == null) continue;
            if (used[row][column] == null) {
                Object typeName;
                IOpenField field;
                Object xmlName;
                Object fieldName;
                if (this.simpleRefByRow || StringUtils.isBlank((CharSequence)columnName)) {
                    fieldName = rowName;
                    xmlName = rowName;
                    field = this.getField(ASpreadsheetField.createFieldName(null, rowName));
                } else if (this.simpleRefByColumn || StringUtils.isBlank((CharSequence)rowName)) {
                    fieldName = columnName;
                    xmlName = columnName;
                    field = this.getField(ASpreadsheetField.createFieldName(columnName, null));
                } else {
                    fieldName = columnName + StringUtils.capitalize((String)rowName);
                    xmlName = columnName + "_" + rowName;
                    field = this.getField(ASpreadsheetField.createFieldName(columnName, rowName));
                }
                if (field == null) {
                    field = (IOpenField)pair.getRight();
                }
                if (StringUtils.isBlank((CharSequence)fieldName)) {
                    fieldName = "_";
                    xmlName = "_";
                }
                IOpenClass t = field.getType();
                int dim = 0;
                while (t.isArray()) {
                    ++dim;
                    t = t.getComponentClass();
                }
                if (t instanceof CustomSpreadsheetResultOpenClass || t instanceof SpreadsheetResultOpenClass || t instanceof AnySpreadsheetResultOpenClass) {
                    Object fieldClsName;
                    XlsModuleOpenClass additionalClassGenerationClassloaderModule = null;
                    if (t instanceof CustomSpreadsheetResultOpenClass) {
                        CustomSpreadsheetResultOpenClass csroc = (CustomSpreadsheetResultOpenClass)t;
                        boolean externalCustomSpreadsheetResultOpenClass = this.isExternalCustomSpreadsheetResultOpenClass(csroc, cache);
                        if (externalCustomSpreadsheetResultOpenClass) {
                            additionalClassGenerationClassloaderModule = csroc.getModule();
                        }
                        fieldClsName = csroc.getBeanClassName();
                        csroc.generateBeanClass();
                    } else if (t instanceof SpreadsheetResultOpenClass) {
                        XlsModuleOpenClass m;
                        SpreadsheetResultOpenClass spreadsheetResultOpenClass = (SpreadsheetResultOpenClass)t;
                        boolean externalSpreadsheetResultOpenClass = this.isExternalSpreadsheetResultOpenClass(spreadsheetResultOpenClass, cache);
                        XlsModuleOpenClass xlsModuleOpenClass = m = externalSpreadsheetResultOpenClass ? spreadsheetResultOpenClass.getModule() : this.getModule();
                        if (externalSpreadsheetResultOpenClass) {
                            additionalClassGenerationClassloaderModule = spreadsheetResultOpenClass.getModule();
                        }
                        fieldClsName = m.getGlobalTableProperties().getSpreadsheetResultPackage() + ".AnySpreadsheetResult";
                        m.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().generateBeanClass();
                    } else {
                        fieldClsName = Map.class.getCanonicalName();
                    }
                    if (additionalClassGenerationClassloaderModule != null) {
                        this.getModule().getClassGenerationClassLoader().addClassLoader((ClassLoader)additionalClassGenerationClassloaderModule.getClassGenerationClassLoader());
                    }
                    typeName = (String)fieldClsName + "[]".repeat(dim);
                } else {
                    if (JavaOpenClass.VOID.equals((Object)t) || JavaOpenClass.CLS_VOID.equals((Object)t) || NullOpenClass.the.equals(t) || JavaOpenClass.getOpenClass(VOID.class).equals((Object)t)) continue;
                    Class instanceClass = field.getType().getInstanceClass();
                    typeName = instanceClass.isPrimitive() ? ClassUtils.primitiveToWrapper((Class)instanceClass).getName() : instanceClass.getCanonicalName();
                }
                if ((usedXmlNames.containsKey(fieldName = ClassUtils.decapitalize((String)fieldName)) || usedXmlNames.containsValue(xmlName)) && !addFieldNameWithCollisions) continue;
                if (usedXmlNames.containsKey(fieldName) || usedXmlNames.containsValue(xmlName)) {
                    Object newFieldName = fieldName;
                    int i = 1;
                    while (usedXmlNames.containsKey(newFieldName)) {
                        newFieldName = (String)fieldName + i;
                        ++i;
                    }
                    Object newXmlName = xmlName;
                    i = 1;
                    while (usedXmlNames.containsValue(newXmlName)) {
                        newXmlName = (String)xmlName + i;
                        ++i;
                    }
                    fieldName = newFieldName;
                    xmlName = newXmlName;
                }
                SpreadsheetResultBeanByteCodeGenerator.FieldDescription fieldDescription = new SpreadsheetResultBeanByteCodeGenerator.FieldDescription((String)typeName, this.simpleRefByRow || !this.simpleRefByColumn ? this.rowNames[row] : null, !this.simpleRefByRow ? this.columnNames[column] : null);
                beanFields.add(fieldDescription);
                beanFieldsMap.put((String)fieldName, this.fillUsed(used, point, field));
                usedXmlNames.put((String)fieldName, (String)xmlName);
                continue;
            }
            boolean f = false;
            for (IOpenField openField : used[row][column]) {
                if (!openField.getName().equals(((IOpenField)pair.getRight()).getName())) continue;
                f = true;
                break;
            }
            if (f) continue;
            used[row][column].add((IOpenField)pair.getRight());
        }
    }

    private List<IOpenField> fillUsed(List<IOpenField>[][] used, Point point, IOpenField field) {
        ArrayList<IOpenField> fields = new ArrayList<IOpenField>();
        fields.add(field);
        if (this.simpleRefByRow) {
            Arrays.fill(used[point.getRow()], fields);
        } else if (this.simpleRefByColumn) {
            for (int w = 0; w < used.length; ++w) {
                used[w][point.getColumn()] = fields;
            }
        } else {
            used[point.getRow()][point.getColumn()] = fields;
        }
        return fields;
    }

    protected String spreadsheetResultNameToBeanName(String name) {
        if (name.startsWith("SpreadsheetResult")) {
            if (name.length() > "SpreadsheetResult".length()) {
                name = name.substring("SpreadsheetResult".length());
            }
            String firstLetterUppercaseName = StringUtils.capitalize((String)name);
            if (this.getModule().findType("SpreadsheetResult" + firstLetterUppercaseName) == null) {
                name = firstLetterUppercaseName;
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBeanClassName() {
        if (this.beanClassName == null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = this;
            synchronized (customSpreadsheetResultOpenClass) {
                if (this.beanClassName == null) {
                    String name = this.spreadsheetResultNameToBeanName(this.getName());
                    this.beanClassName = this.getModule().getGlobalTableProperties().getSpreadsheetResultPackage() + "." + name;
                }
            }
        }
        return this.beanClassName;
    }

    public SpreadsheetResult createSpreadsheetResult(Object bean, Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSpr) {
        SpreadsheetResult spreadsheetResult = (SpreadsheetResult)this.newInstance(null);
        for (Map.Entry<String, List<IOpenField>> cell : this.beanFieldsMap.entrySet()) {
            Object v;
            String fieldName = cell.getKey();
            try {
                v = ClassUtils.get((Object)bean, (String)fieldName);
            }
            catch (Exception e) {
                this.log.debug("Ignored error: ", (Throwable)e);
                continue;
            }
            Object cv = SpreadsheetResult.convertBeansToSpreadsheetResults(v, mapClassToSpr);
            IOpenField openField = cell.getValue().get(0);
            openField.set((Object)spreadsheetResult, cv, null);
        }
        return spreadsheetResult;
    }

    public boolean isIgnoreCompilation() {
        return this.ignoreCompilation;
    }

    public void setIgnoreCompilation(boolean ignoreCompilation) {
        this.ignoreCompilation = ignoreCompilation;
    }

    protected Map<MethodKey, IOpenMethod> initConstructorMap() {
        Map constructorMap = super.initConstructorMap();
        HashMap<MethodKey, IOpenMethod> spreadsheetResultConstructorMap = new HashMap<MethodKey, IOpenMethod>();
        for (Map.Entry entry : constructorMap.entrySet()) {
            CustomSpreadsheetResultConstructor constructor = new CustomSpreadsheetResultConstructor((IOpenMethod)entry.getValue(), this);
            spreadsheetResultConstructorMap.put(new MethodKey((IOpenMethod)constructor), (IOpenMethod)constructor);
        }
        return spreadsheetResultConstructorMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomSpreadsheetResultOpenClass that = (CustomSpreadsheetResultOpenClass)((Object)o);
        return Objects.equals((Object)this.module, (Object)that.module) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        return result;
    }
}

