/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlElement;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.openl.gen.ByteCodeUtils;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.SpreadsheetCell;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultBeanClass;
import org.openl.util.ClassUtils;
import org.openl.util.JavaKeywordUtils;
import org.openl.util.StringUtils;

final class SpreadsheetResultBeanByteCodeGenerator {
    private static final Method DEFAULT_CONSTRUCTOR = Method.getMethod((String)"void <init> ()");
    private static final String SR_BEAN_CLASS = Type.getDescriptor(SpreadsheetResultBeanClass.class);
    private static final String SPREADSHEET_CELL = Type.getDescriptor(SpreadsheetCell.class);
    private static final String XML_ELEMENT = Type.getDescriptor(XmlElement.class);
    public static final Type VALUES_TYPE = Type.getType(HashMap.class);
    public static final Method GET_VALUE = Method.getMethod((String)"Object get(Object)");
    public static final Method SET_VALUE = Method.getMethod((String)"Object put(Object, Object)");
    private static final Type SR_TYPE = Type.getType(SpreadsheetResult.class);
    private static final Method SR_GET_VALUE = Method.getMethod((String)"Object getModelValue(String)");
    private static final Type METHOD_TYPE = Type.getType(java.lang.reflect.Method.class);
    private final List<FieldDescription> fields;
    private final Type beanType;
    private final String namespace;
    private final String name;
    private final String propertyNameSpace;
    private final Method valueOfMethod;

    public static byte[] byteCode(String beanName, List<FieldDescription> beanFields) {
        return new SpreadsheetResultBeanByteCodeGenerator(beanName, beanFields).getBytes();
    }

    private SpreadsheetResultBeanByteCodeGenerator(String beanNameWithPackage, List<FieldDescription> beanFields) {
        SpreadsheetResultBeanByteCodeGenerator.fixDuplicates(beanFields, (field, name) -> {
            field.fieldName = name;
        }, field -> field.fieldName);
        SpreadsheetResultBeanByteCodeGenerator.fixDuplicates(beanFields, (field, name) -> {
            field.xmlName = name;
        }, field -> field.xmlName);
        this.fields = beanFields;
        this.beanType = Type.getType((String)ByteCodeUtils.toTypeDescriptor((String)beanNameWithPackage));
        this.valueOfMethod = Method.getMethod((String)(beanNameWithPackage + " valueOf(org.openl.rules.calc.SpreadsheetResult, java.util.function.BiFunction)"));
        String[] parts = StringUtils.split((String)beanNameWithPackage, (char)'.');
        StringBuilder str = new StringBuilder(beanNameWithPackage.length());
        str.append("https://");
        for (int i = parts.length - 2; i >= 0; --i) {
            str.append(parts[i]);
            if (i == 0) continue;
            str.append('.');
        }
        this.namespace = str.toString();
        this.name = parts[parts.length - 1];
        this.propertyNameSpace = this.namespace + "/" + this.name;
    }

    private byte[] getBytes() {
        ClassWriter classWriter = new ClassWriter(1);
        this.visitClassDescription(classWriter);
        this.visitClassAnnotations(classWriter);
        this.visitConstructor(classWriter);
        this.visitFields(classWriter);
        this.visitValueOf(classWriter);
        return classWriter.toByteArray();
    }

    private static void fixDuplicates(List<FieldDescription> fields, BiConsumer<FieldDescription, String> set, Function<FieldDescription, String> get) {
        HashSet<Object> names = new HashSet<Object>(fields.size());
        ArrayList<FieldDescription> duplicates = new ArrayList<FieldDescription>();
        for (FieldDescription field : fields) {
            if (names.add(get.apply(field))) continue;
            duplicates.add(field);
        }
        for (FieldDescription field : duplicates) {
            String name = get.apply(field);
            int i = 1;
            while (names.contains(name + i)) {
                ++i;
            }
            String newName = name + i;
            set.accept(field, newName);
            names.add(newName);
        }
    }

    private void visitClassDescription(ClassWriter classWriter) {
        classWriter.visit(55, 33, this.beanType.getInternalName(), null, "java/lang/Object", new String[]{"java/io/Serializable"});
    }

    private void visitClassAnnotations(ClassWriter classWriter) {
        AnnotationVisitor av = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlRootElement;", true);
        av.visit("namespace", (Object)this.namespace);
        av.visit("name", (Object)this.name);
        av.visitEnd();
        av = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlAccessorType;", true);
        av.visitEnum("value", "Ljavax/xml/bind/annotation/XmlAccessType;", "PROPERTY");
        av.visitEnd();
        av = classWriter.visitAnnotation(SR_BEAN_CLASS, true);
        av.visitEnd();
        av = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        av.visit("namespace", (Object)this.namespace);
        av.visit("name", (Object)this.name);
        AnnotationVisitor av1 = av.visitArray("propOrder");
        for (FieldDescription e : this.fields) {
            av1.visit(null, (Object)e.fieldName);
        }
        av1.visitEnd();
        av.visitEnd();
    }

    private void visitConstructor(ClassWriter classWriter) {
        FieldVisitor map = classWriter.visitField(18, "values", "Ljava/util/HashMap;", "Ljava/util/HashMap<Lorg/openl/cache/GenericKey;Ljava/lang/Object;>;", null);
        map.visitEnd();
        GeneratorAdapter mg = new GeneratorAdapter(1, DEFAULT_CONSTRUCTOR, null, null, (ClassVisitor)classWriter);
        mg.loadThis();
        mg.invokeConstructor(Type.getType(Object.class), DEFAULT_CONSTRUCTOR);
        mg.loadThis();
        mg.newInstance(VALUES_TYPE);
        mg.dup();
        mg.push(this.fields.size());
        mg.push(1.0f);
        mg.invokeConstructor(VALUES_TYPE, Method.getMethod((String)"void <init> (int, float)"));
        mg.putField(this.beanType, "values", VALUES_TYPE);
        mg.returnValue();
        mg.endMethod();
    }

    private void visitFields(ClassWriter classWriter) {
        for (FieldDescription field : this.fields) {
            this.generateGetter(classWriter, field.fieldName, field);
            this.generateSetter(classWriter, field.fieldName, field);
        }
    }

    private void generateGetter(ClassWriter classWriter, String fieldName, FieldDescription fieldDescription) {
        String getterMethod = fieldDescription.className + " " + ClassUtils.getter((String)fieldName) + "()";
        GeneratorAdapter mg = new GeneratorAdapter(1, Method.getMethod((String)getterMethod), null, null, (ClassVisitor)classWriter);
        mg.loadThis();
        mg.getField(this.beanType, "values", VALUES_TYPE);
        mg.push(fieldDescription.cell);
        mg.invokeVirtual(VALUES_TYPE, GET_VALUE);
        mg.checkCast(fieldDescription.type);
        mg.returnValue();
        AnnotationVisitor av = mg.visitAnnotation(SPREADSHEET_CELL, true);
        av.visit("cell", (Object)fieldDescription.cell);
        if (fieldDescription.column != null) {
            av.visit("column", (Object)fieldDescription.column);
        }
        if (fieldDescription.row != null) {
            av.visit("row", (Object)fieldDescription.row);
        }
        av.visitEnd();
        av = mg.visitAnnotation(XML_ELEMENT, true);
        av.visit("name", (Object)fieldDescription.xmlName);
        av.visit("namespace", (Object)this.propertyNameSpace);
        av.visitEnd();
        mg.endMethod();
    }

    private void generateSetter(ClassWriter classWriter, String fieldName, FieldDescription fieldDescription) {
        String setterMethod = "void " + ClassUtils.setter((String)fieldName) + "(" + fieldDescription.className + ")";
        GeneratorAdapter mg = new GeneratorAdapter(1, Method.getMethod((String)setterMethod), null, null, (ClassVisitor)classWriter);
        mg.loadThis();
        mg.getField(this.beanType, "values", VALUES_TYPE);
        mg.push(fieldDescription.cell);
        mg.loadArg(0);
        mg.invokeVirtual(VALUES_TYPE, SET_VALUE);
        mg.pop();
        mg.returnValue();
        mg.endMethod();
    }

    private void visitValueOf(ClassWriter classWriter) {
        GeneratorAdapter mg = new GeneratorAdapter(9, this.valueOfMethod, null, null, (ClassVisitor)classWriter);
        mg.visitCode();
        mg.newInstance(this.beanType);
        mg.dup();
        mg.invokeConstructor(this.beanType, DEFAULT_CONSTRUCTOR);
        int bean = mg.newLocal(this.beanType);
        mg.storeLocal(bean);
        mg.push(this.beanType);
        mg.invokeVirtual(Type.getType(Class.class), Method.getMethod((String)"java.lang.reflect.Method[] getDeclaredMethods()"));
        int array = mg.newLocal(Type.getType(java.lang.reflect.Method[].class));
        mg.storeLocal(array);
        mg.loadLocal(array);
        mg.arrayLength();
        int end = mg.newLocal(Type.INT_TYPE);
        mg.storeLocal(end);
        mg.push(0);
        int index = mg.newLocal(Type.INT_TYPE);
        mg.storeLocal(index);
        MethodVisitor methodVisitor = mg.getDelegate();
        Label forLoop = mg.mark();
        methodVisitor.visitFrame(0, 6, new Object[]{"org/openl/rules/calc/SpreadsheetResult", "java/util/function/BiFunction", this.beanType.getInternalName(), "[Ljava/lang/reflect/Method;", Opcodes.INTEGER, Opcodes.INTEGER}, 0, new Object[0]);
        mg.loadLocal(index);
        mg.loadLocal(end);
        Label exitFor = mg.newLabel();
        mg.ifCmp(Type.INT_TYPE, 156, exitFor);
        mg.loadLocal(array);
        mg.loadLocal(index);
        mg.arrayLoad(METHOD_TYPE);
        int method = mg.newLocal(METHOD_TYPE);
        mg.storeLocal(method);
        mg.loadLocal(method);
        mg.push(Type.getType(SpreadsheetCell.class));
        mg.invokeVirtual(METHOD_TYPE, Method.getMethod((String)"java.lang.annotation.Annotation getAnnotation(Class)"));
        mg.checkCast(Type.getType(SpreadsheetCell.class));
        int annotation = mg.newLocal(Type.getType(SpreadsheetCell.class));
        mg.storeLocal(annotation);
        mg.loadLocal(annotation);
        Label exitIf = mg.newLabel();
        mg.ifNull(exitIf);
        mg.loadLocal(annotation);
        mg.invokeInterface(Type.getType(SpreadsheetCell.class), Method.getMethod((String)"String cell()"));
        int cell = mg.newLocal(Type.getType(String.class));
        mg.storeLocal(cell);
        mg.loadLocal(bean);
        mg.getField(this.beanType, "values", VALUES_TYPE);
        mg.loadLocal(cell);
        mg.loadArg(1);
        mg.loadArg(0);
        mg.loadLocal(cell);
        mg.invokeVirtual(SR_TYPE, SR_GET_VALUE);
        mg.loadLocal(method);
        mg.invokeVirtual(METHOD_TYPE, Method.getMethod((String)"Class getReturnType()"));
        mg.invokeInterface(Type.getType(BiFunction.class), Method.getMethod((String)"Object apply(Object, Object)"));
        mg.invokeVirtual(VALUES_TYPE, SET_VALUE);
        mg.pop();
        mg.mark(exitIf);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        mg.iinc(index, 1);
        mg.goTo(forLoop);
        mg.mark(exitFor);
        methodVisitor.visitFrame(2, 3, null, 0, null);
        mg.loadLocal(bean);
        mg.returnValue();
        mg.endMethod();
    }

    static final class FieldDescription {
        final String className;
        final Type type;
        final String row;
        final String column;
        final String cell;
        String fieldName;
        String xmlName;

        FieldDescription(String canonicalClassName, String row, String column) {
            Object fieldName;
            this.className = canonicalClassName;
            this.type = Type.getType((String)ByteCodeUtils.toTypeDescriptor((String)canonicalClassName));
            this.row = row;
            this.column = column;
            this.cell = ASpreadsheetField.createFieldName(column, row);
            if (column == null) {
                fieldName = JavaKeywordUtils.toJavaIdentifier((String)row);
                this.xmlName = fieldName;
            } else if (row == null) {
                fieldName = JavaKeywordUtils.toJavaIdentifier((String)column);
                this.xmlName = fieldName;
            } else {
                String c = JavaKeywordUtils.toJavaIdentifier((String)column);
                String r = JavaKeywordUtils.toJavaIdentifier((String)row);
                fieldName = c + StringUtils.capitalize((String)r);
                this.xmlName = c + "_" + r;
            }
            if (((String)fieldName).isEmpty()) {
                this.xmlName = fieldName = "_";
            }
            this.fieldName = ClassUtils.decapitalize((String)fieldName);
        }
    }
}

