/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.table.ICell;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.Invokable;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetCell
implements Invokable {
    private final int rowIndex;
    private final int columnIndex;
    private final ICell sourceCell;
    private final SpreadsheetCellType spreadsheetCellType;
    private Object value;
    private IOpenClass type;
    private IOpenMethod method;
    private boolean returnCell;

    public SpreadsheetCell(int rowIndex, int columnIndex, ICell sourceCell, SpreadsheetCellType spreadsheetCellType) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.sourceCell = sourceCell;
        this.spreadsheetCellType = spreadsheetCellType;
    }

    public ICell getSourceCell() {
        return this.sourceCell;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public SpreadsheetCellType getSpreadsheetCellType() {
        return this.spreadsheetCellType;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public IOpenClass getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.spreadsheetCellType == SpreadsheetCellType.EMPTY;
    }

    public boolean isMethodCell() {
        return this.spreadsheetCellType == SpreadsheetCellType.METHOD;
    }

    public boolean isValueCell() {
        return this.spreadsheetCellType == SpreadsheetCellType.VALUE;
    }

    public boolean isConstantCell() {
        return this.spreadsheetCellType == SpreadsheetCellType.CONSTANT;
    }

    public boolean isDefaultPrimitiveCell() {
        return this.type != null && !(this.type instanceof DomainOpenClass) && this.type.getInstanceClass() != null && this.type.getInstanceClass().isPrimitive() && this.isEmpty();
    }

    public void setMethod(IOpenMethod method) {
        this.method = method;
    }

    public void setType(IOpenClass type) {
        if (type != null) {
            this.type = type.equals(NullOpenClass.the) ? NullOpenClass.the : (type == JavaOpenClass.VOID ? JavaOpenClass.getOpenClass(Void.class) : type);
        }
    }

    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof IOpenMethod) {
            this.method = (IOpenMethod)value;
        } else {
            this.value = value;
        }
    }

    public boolean isReturnCell() {
        return this.returnCell;
    }

    public void setReturnCell(boolean returnCell) {
        this.returnCell = returnCell;
    }

    public Object invoke(Object spreadsheetResult, Object[] params, IRuntimeEnv env) {
        if (this.isValueCell() || this.isConstantCell() || this.isDefaultPrimitiveCell()) {
            return this.getValue();
        }
        if (this.isMethodCell()) {
            return this.getMethod().invoke(spreadsheetResult, params, env);
        }
        return null;
    }

    public String toString() {
        return "R" + this.getRowIndex() + "C" + this.getColumnIndex();
    }
}

