/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cloner;

import groovy.lang.MetaObjectProtocol;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import org.openl.rules.calc.AnySpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.StubSpreadSheetResult;
import org.openl.rules.cloner.ArrayCloner;
import org.openl.rules.cloner.ArrayImmutableCloner;
import org.openl.rules.cloner.BeanCloner;
import org.openl.rules.cloner.CollectionCloner;
import org.openl.rules.cloner.ICloner;
import org.openl.rules.cloner.MapCloner;
import org.openl.rules.cloner.UnmodifiableCloner;
import org.openl.rules.cloner.Wrapper;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.table.ILogicalTable;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.slf4j.Logger;

public class Cloner {
    private static final Set<Object> constants = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Class<?>> immutable = new HashSet();
    private static final Set<Class<?>> doNotClone = new HashSet();
    private static final Map<Class<?>, ICloner<?>> cloners = new HashMap();
    private static final Map<Class<?>, WeakReference<ICloner<?>>> cache = new WeakHashMap();

    private static void registerCloner(String privateClass, ICloner<?> fastCloner) {
        try {
            ClassLoader classLoader = Cloner.class.getClassLoader();
            Class<?> subListClz = classLoader.loadClass(privateClass);
            cloners.put(subListClz, fastCloner);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static boolean skipClone(Class<?> clazz) {
        return clazz.isPrimitive() || immutable.contains(clazz) || Cloner.skipCloneInstanceOf(clazz);
    }

    private static boolean skipCloneInstanceOf(Class<?> clazz) {
        for (Class<?> clz : doNotClone) {
            if (!clz.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static <T> T clone(T source) {
        if (source == null) {
            return null;
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>();
        return Cloner.clone(source, clones);
    }

    public static <T> T clone(T source, Map<Object, Object> clones) {
        Object instance;
        if (source == null || constants.contains(source)) {
            return source;
        }
        Class<?> clazz = source.getClass();
        if (Cloner.skipClone(clazz) || clazz == Object.class || clazz.isArray() && Array.getLength(source) == 0) {
            return source;
        }
        Object clone = clones.get(source);
        if (clone != null) {
            return (T)clone;
        }
        ICloner cloner = Cloner.getCloner(clazz);
        Object target = instance = cloner.getInstance(source);
        if (instance instanceof Wrapper) {
            Wrapper w = (Wrapper)instance;
            target = w.target;
            instance = w.unmodifiable;
        }
        clones.put(source, instance);
        cloner.clone(source, x -> Cloner.clone(x, clones), target);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ICloner getCloner(Class<T> clazz) {
        ICloner<Object> cloner = clazz.isArray() ? (Cloner.skipClone(clazz.getComponentType()) ? ArrayImmutableCloner.theInstance : ArrayCloner.theInstance) : cloners.get(clazz);
        if (cloner != null) {
            return cloner;
        }
        WeakReference<ICloner<?>> ref = cache.get(clazz);
        if (ref != null && (cloner = (BeanCloner<T>)ref.get()) != null) {
            return cloner;
        }
        cloner = new BeanCloner<T>(clazz);
        Map<Class<?>, WeakReference<ICloner<?>>> map = cache;
        synchronized (map) {
            cache.put(clazz, new WeakReference<BeanCloner<T>>(cloner));
        }
        return cloner;
    }

    static {
        constants.add(Collections.emptySet());
        constants.add(Collections.emptyNavigableSet());
        constants.add(Collections.emptySortedSet());
        constants.add(Collections.emptyMap());
        constants.add(Collections.emptyNavigableMap());
        constants.add(Collections.emptySortedMap());
        constants.add(Collections.emptyList());
        constants.add(Collections.emptyEnumeration());
        constants.add(Collections.emptyIterator());
        constants.add(Collections.emptyListIterator());
        immutable.add(Void.class);
        immutable.add(String.class);
        immutable.add(Double.class);
        immutable.add(Integer.class);
        immutable.add(Long.class);
        immutable.add(Boolean.class);
        immutable.add(BigDecimal.class);
        immutable.add(BigInteger.class);
        immutable.add(Character.class);
        immutable.add(Byte.class);
        immutable.add(Short.class);
        immutable.add(Float.class);
        immutable.add(LocalDate.class);
        immutable.add(LocalTime.class);
        immutable.add(LocalDateTime.class);
        immutable.add(ZonedDateTime.class);
        immutable.add(OffsetDateTime.class);
        immutable.add(OffsetTime.class);
        immutable.add(Duration.class);
        immutable.add(Instant.class);
        immutable.add(Period.class);
        immutable.add(Locale.class);
        immutable.add(UUID.class);
        immutable.add(URI.class);
        immutable.add(URL.class);
        immutable.add(Year.class);
        immutable.add(Month.class);
        immutable.add(YearMonth.class);
        immutable.add(MonthDay.class);
        immutable.add(DayOfWeek.class);
        immutable.add(Class.class);
        immutable.add(Pattern.class);
        immutable.add(CharRange.class);
        immutable.add(DateRange.class);
        immutable.add(IntRange.class);
        immutable.add(DoubleRange.class);
        immutable.add(StringRange.class);
        doNotClone.add(Path.class);
        doNotClone.add(Enum.class);
        doNotClone.add(MetaObjectProtocol.class);
        doNotClone.add(IOpenClass.class);
        doNotClone.add(IOpenMember.class);
        doNotClone.add(InvocationHandler.class);
        doNotClone.add(ILogicalTable.class);
        doNotClone.add(Logger.class);
        cloners.put(GregorianCalendar.class, ICloner.create(x -> {
            GregorianCalendar result = new GregorianCalendar((TimeZone)x.getTimeZone().clone());
            result.setTimeInMillis(x.getTimeInMillis());
            return result;
        }));
        cloners.put(java.util.Date.class, ICloner.create(x1 -> new java.util.Date(x1.getTime())));
        cloners.put(Time.class, ICloner.create(x1 -> new Time(x1.getTime())));
        cloners.put(Timestamp.class, ICloner.create(x1 -> new Timestamp(x1.getTime())));
        cloners.put(Date.class, ICloner.create(x1 -> new Date(x1.getTime())));
        CollectionCloner<Collection> listCloner = CollectionCloner.create(x -> new ArrayList(x.size()));
        CollectionCloner<Deque> linkedListCloner = CollectionCloner.create(x -> new LinkedList());
        CollectionCloner<Set> setCloner = CollectionCloner.create(x -> new HashSet(x.size()));
        CollectionCloner<Set> linkedHashSetCloner = CollectionCloner.create(x -> new LinkedHashSet(x.size()));
        CollectionCloner<SortedSet> treeSetCloner = CollectionCloner.create(x -> new TreeSet(x.comparator()));
        MapCloner<Map> mapCloner = MapCloner.create(x -> new HashMap(x.size()));
        MapCloner<Map> linkedMapCloner = MapCloner.create(x -> new LinkedHashMap(x.size()));
        MapCloner<SortedMap> treeMapCloner = MapCloner.create(x -> new TreeMap(x.comparator()));
        cloners.put(ArrayList.class, listCloner);
        cloners.put(LinkedList.class, linkedListCloner);
        cloners.put(HashSet.class, setCloner);
        cloners.put(HashMap.class, mapCloner);
        cloners.put(TreeMap.class, treeMapCloner);
        cloners.put(TreeSet.class, treeSetCloner);
        cloners.put(LinkedHashMap.class, linkedMapCloner);
        cloners.put(ConcurrentHashMap.class, MapCloner.create(x -> new ConcurrentHashMap(x.size())));
        cloners.put(ConcurrentLinkedQueue.class, CollectionCloner.create(x -> new ConcurrentLinkedQueue()));
        cloners.put(EnumMap.class, MapCloner.create(x -> new EnumMap(x)));
        cloners.put(LinkedHashSet.class, linkedHashSetCloner);
        cloners.put(SpreadsheetResult.class, ICloner.create(x -> {
            SpreadsheetResult result = new SpreadsheetResult((SpreadsheetResult)x);
            result.setResults(Cloner.clone(x.getResults()));
            return result;
        }));
        cloners.put(StubSpreadSheetResult.class, ICloner.doNotClone);
        cloners.put(AnySpreadsheetResult.class, ICloner.doNotClone);
        Cloner.registerCloner("java.util.AbstractList$SubList", listCloner);
        Cloner.registerCloner("java.util.ArrayList$SubList", listCloner);
        Cloner.registerCloner("java.util.ImmutableCollections$List12", listCloner);
        Cloner.registerCloner("java.util.ImmutableCollections$ListN", listCloner);
        Cloner.registerCloner("java.util.ImmutableCollections$Set12", setCloner);
        Cloner.registerCloner("java.util.ImmutableCollections$SetN", setCloner);
        Cloner.registerCloner("java.util.ImmutableCollections$Map1", mapCloner);
        Cloner.registerCloner("java.util.ImmutableCollections$MapN", mapCloner);
        Cloner.registerCloner("java.util.Collections$UnmodifiableCollection", UnmodifiableCloner.create(Collections::unmodifiableCollection, listCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableRandomAccessList", UnmodifiableCloner.create(Collections::unmodifiableList, listCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableSet", UnmodifiableCloner.create(Collections::unmodifiableSet, setCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableNavigableSet", UnmodifiableCloner.create(Collections::unmodifiableNavigableSet, treeSetCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableSortedSet", UnmodifiableCloner.create(Collections::unmodifiableSortedSet, treeSetCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableMap", UnmodifiableCloner.create(Collections::unmodifiableMap, mapCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableNavigableMap", UnmodifiableCloner.create(Collections::unmodifiableNavigableMap, treeMapCloner));
        Cloner.registerCloner("java.util.Collections$UnmodifiableSortedMap", UnmodifiableCloner.create(Collections::unmodifiableSortedMap, treeMapCloner));
    }
}

