/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import java.util.Date;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;

class String2DateConvertor
implements IString2DataConvertor<Date> {
    private static final LocalDate BASE_DATE = LocalDate.of(1930, 1, 1);

    String2DateConvertor() {
    }

    @Override
    public Date parse(String data, String format) {
        if (data == null) {
            return null;
        }
        if (format != null) {
            SimpleDateFormat df = new SimpleDateFormat(format, LocaleDependConvertor.getLocale());
            try {
                return df.parse(data);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Cannot convert '%s' to date type using: '%s' format", data, format));
            }
        }
        try {
            LocalDateTime localDateTime = new DateTimeFormatterBuilder().appendPattern("M/d/").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, BASE_DATE).parseStrict().toFormatter(LocaleDependConvertor.getLocale()).parse((CharSequence)data, TemporalQueries.localDate()).atTime(0, 0);
            return Date.from(localDateTime.toInstant(ZoneId.systemDefault().getRules().getOffset(localDateTime)));
        }
        catch (Exception localDateTime) {
            DateTimeFormatterBuilder patternBuilder = new DateTimeFormatterBuilder().appendPattern("y-M-d['T'H:m[:s[.").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).appendPattern("]][X]]");
            Date cal = String2DateConvertor.parsePattern(data, patternBuilder);
            if (cal != null) {
                return cal;
            }
            patternBuilder = new DateTimeFormatterBuilder().appendPattern("y-M-d['T'H:m[:s[.").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).appendPattern("]][XXX]]");
            cal = String2DateConvertor.parsePattern(data, patternBuilder);
            if (cal != null) {
                return cal;
            }
            patternBuilder = new DateTimeFormatterBuilder().appendPattern("M/d/y[ H:m[:s]]");
            cal = String2DateConvertor.parsePattern(data, patternBuilder);
            if (cal != null) {
                return cal;
            }
            patternBuilder = new DateTimeFormatterBuilder().appendPattern("M/d/y hh:mm a");
            cal = String2DateConvertor.parsePattern(data, patternBuilder);
            if (cal != null) {
                return cal;
            }
            throw new IllegalArgumentException(String.format("Cannot convert '%s' to Date type", data));
        }
    }

    private static Date parsePattern(String data, DateTimeFormatterBuilder patternBuilder) {
        DateTimeFormatter parser = patternBuilder.parseStrict().toFormatter(LocaleDependConvertor.getLocale());
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            TemporalAccessor result = parser.parse((CharSequence)data, parsePosition);
            if (parsePosition.getIndex() != data.length()) {
                return null;
            }
            LocalDate date = result.query(TemporalQueries.localDate());
            LocalTime time = result.query(TemporalQueries.localTime());
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
            if (time != null) {
                cal.set(11, time.getHour());
                cal.set(12, time.getMinute());
                cal.set(13, time.getSecond());
                cal.set(14, time.getNano() / 1000000);
            }
            if (result.isSupported(ChronoField.OFFSET_SECONDS)) {
                cal.set(15, result.get(ChronoField.OFFSET_SECONDS) * 1000);
                cal.set(16, 0);
            }
            return cal.getTime();
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

