/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.convertor.IString2DataConvertor;

public class String2InstantConverter
implements IString2DataConvertor<Instant> {
    private final List<DateTimeFormatter> supportedFormats = new ArrayList<DateTimeFormatter>();

    public String2InstantConverter() {
        this.supportedFormats.add(DateTimeFormatter.ISO_INSTANT);
        this.supportedFormats.add(DateTimeFormatter.ofPattern("M/dd/yyyy H:mm a VV"));
    }

    @Override
    public Instant parse(String data, String format) {
        if (data == null) {
            return null;
        }
        for (DateTimeFormatter dtFormat : this.supportedFormats) {
            try {
                return dtFormat.parse((CharSequence)data, Instant::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to Instant type", data));
    }
}

