/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.meta.StringValue;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.ObjectToDataConvertorFactory;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.DatatypeArrayMultiRowElementContext;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.helpers.ArraySplitter;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.vm.SimpleRulesVM;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;
import org.openl.util.MessageUtils;
import org.openl.vm.IRuntimeEnv;

public class ForeignKeyColumnDescriptor
extends ColumnDescriptor {
    private final IdentifierNode foreignKeyTable;
    private final IdentifierNode[] foreignKeyTableAccessorChainTokens;
    private final IdentifierNode foreignKey;
    private String[] foreignKeyColumnChainTokens = new String[0];
    private final CellKey foreignKeyCellCoordinate;

    public ForeignKeyColumnDescriptor(IOpenField field, IdentifierNode foreignKeyTable, IdentifierNode foreignKey, IdentifierNode[] foreignKeyTableAccessorChainTokens, ICell foreignKeyCell, StringValue displayValue, OpenL openl, boolean constructor, IdentifierNode[] fieldChainTokens, int columnNum) {
        super(field, displayValue, openl, constructor, fieldChainTokens, columnNum, false);
        this.foreignKeyTable = foreignKeyTable;
        this.foreignKey = foreignKey;
        this.foreignKeyTableAccessorChainTokens = foreignKeyTableAccessorChainTokens;
        this.foreignKeyCellCoordinate = CellKey.CellKeyFactory.getCellKey(foreignKeyCell.getAbsoluteColumn(), foreignKeyCell.getAbsoluteRow());
    }

    private String getCellStringValue(ILogicalTable cellTable) {
        String value = cellTable.getSource().getCell(0, 0).getStringValue();
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private ArrayList<Object> getArrayValuesByForeignKey(ILogicalTable valuesTable, IBindingContext bindingContext, ITable foreignTable, int foreignKeyIndex, IdentifierNode[] foreignKeyTableAccessorChainTokens) throws SyntaxNodeException {
        ArrayList<Object> values;
        block4: {
            int valuesHeight;
            block3: {
                String[] tokens;
                valuesHeight = valuesTable.getHeight();
                values = new ArrayList<Object>(valuesHeight);
                if (valuesHeight != 1) break block3;
                String src = valuesTable.getSource().getCell(0, 0).getStringValue();
                if (src == null) break block4;
                for (String token : tokens = ArraySplitter.split(src)) {
                    Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, foreignKeyTableAccessorChainTokens, valuesTable, token);
                    this.addResValues(values, res);
                }
                break block4;
            }
            for (int i = 0; i < valuesHeight; ++i) {
                ILogicalTable valueTable = (ILogicalTable)valuesTable.getRow(i);
                String value = this.getCellStringValue(valueTable);
                if (value == null || value.length() == 0) {
                    values.add(null);
                    continue;
                }
                Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, foreignKeyTableAccessorChainTokens, valueTable, value);
                this.addResValues(values, res);
            }
        }
        return values;
    }

    private void addResValues(ArrayList<Object> values, Object res) {
        if (res != null && res.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(res); ++i) {
                values.add(Array.get(res, i));
            }
        } else {
            values.add(res);
        }
    }

    private Object getValueByForeignKeyIndex(IBindingContext bindingContext, ITable foreignTable, int foreignKeyIndex, IdentifierNode[] foreignKeyTableAccessorChainTokens, ILogicalTable valueTable, String key) throws SyntaxNodeException {
        Object result;
        try {
            if (this.foreignKeyColumnChainTokens.length == 0) {
                this.foreignKeyColumnChainTokens = (String[])ArrayUtils.add((Object[])this.foreignKeyColumnChainTokens, (Object)foreignTable.getColumnName(foreignKeyIndex));
                ColumnDescriptor foreignColumnDescriptor = foreignTable.getDataModel().getDescriptor(foreignKeyIndex);
                if (foreignColumnDescriptor.isReference() && foreignColumnDescriptor instanceof ForeignKeyColumnDescriptor) {
                    Object[] endOfChain = ((ForeignKeyColumnDescriptor)foreignColumnDescriptor).foreignKeyColumnChainTokens;
                    this.foreignKeyColumnChainTokens = (String[])ArrayUtils.addAll((Object[])this.foreignKeyColumnChainTokens, (Object[])endOfChain);
                }
            }
            result = foreignTable.findObject(foreignKeyIndex, key, bindingContext);
            IOpenClass resType = foreignTable.getDataModel().getType();
            if (result == null) {
                throw this.createIndexNotFoundError(foreignTable, valueTable, key, null, bindingContext);
            }
            if (!ArrayUtils.isEmpty((Object[])foreignKeyTableAccessorChainTokens)) {
                ResultChainObject chainRes = this.getChainObject(bindingContext, resType, result, foreignKeyTableAccessorChainTokens);
                if (chainRes == null) {
                    throw this.createIndexNotFoundError(foreignTable, valueTable, key, null, bindingContext);
                }
                result = chainRes.getValue();
            }
        }
        catch (SyntaxNodeException ex) {
            throw this.createIndexNotFoundError(foreignTable, valueTable, key, (Exception)((Object)ex), bindingContext);
        }
        return result;
    }

    private SyntaxNodeException createIndexNotFoundError(ITable foreignTable, ILogicalTable valuesTable, String src, Exception ex, IBindingContext bindingContext) {
        String message = MessageUtils.getUnknownForeignKeyIndexErrorMessage((String)src, (String)foreignTable.getName());
        return SyntaxNodeExceptionUtils.createError((String)message, (Throwable)ex, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(valuesTable.getSource(), bindingContext));
    }

    public Object getLiteralByForeignKey(IOpenClass fieldType, ILogicalTable valuesTable, IDataBase db, IBindingContext bindingContext) throws Exception {
        boolean valuesAnArray;
        String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
        ITable foreignTable = db.getTable(foreignKeyTableName);
        Object result = null;
        int foreignKeyIndex = 0;
        if (this.foreignKey != null) {
            String columnName = this.foreignKey.getIdentifier();
            foreignKeyIndex = foreignTable.getColumnIndex(columnName);
        }
        if (!(valuesAnArray = ForeignKeyColumnDescriptor.isValuesAnArray(fieldType))) {
            String value = this.getCellStringValue(valuesTable);
            if (value != null && value.length() > 0) {
                result = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, valuesTable, value);
            }
        } else {
            ILogicalTable valueTable;
            String value;
            ArrayList<Object> values = new ArrayList<Object>();
            int valuesHeight = valuesTable.getHeight();
            for (int i = 0; i < valuesHeight && (value = this.getCellStringValue(valueTable = (ILogicalTable)valuesTable.getRow(i))) != null && value.length() != 0; ++i) {
                Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, valueTable, value);
                values.add(res);
            }
            IOpenClass componentType = fieldType.getAggregateInfo().getComponentType(fieldType);
            Object ary = fieldType.getAggregateInfo().makeIndexedAggregate(componentType, values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(ary, i, values.get(i));
            }
            result = ary;
        }
        return result;
    }

    @Override
    public boolean isReference() {
        return this.foreignKeyTable != null;
    }

    public void populateLiteralByForeignKey(Object target, ILogicalTable valuesTable, IDataBase db, IBindingContext cxt, IRuntimeEnv env) throws Exception {
        if (this.getField() != null && this.foreignKeyTable != null) {
            Object result;
            String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
            ITable foreignTable = db.getTable(foreignKeyTableName);
            int foreignKeyIndex = this.getForeignKeyIndex(foreignTable);
            valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
            IOpenClass fieldType = this.getField().getType();
            IOpenClass resType = foreignTable.getDataModel().getType();
            String s = this.getCellStringValue(valuesTable);
            if (!StringUtils.isEmpty((CharSequence)s) && (result = foreignTable.findObject(foreignKeyIndex, s, cxt)) != null) {
                ResultChainObject chainRes = this.getChainObject(cxt, resType, result, this.foreignKeyTableAccessorChainTokens);
                if (chainRes == null) {
                    throw this.createIndexNotFoundError(foreignTable, valuesTable, s, null, cxt);
                }
                resType = chainRes.getType();
            }
            boolean isCollection = ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), Collection.class);
            boolean f = true;
            if (fieldType.isArray()) {
                f = !fieldType.getComponentClass().getInstanceClass().equals(resType.getInstanceClass());
            } else if (isCollection) {
                f = fieldType.isAssignableFrom(resType);
            }
            if (this.isSupportMultirows()) {
                this.populateLiteralByForeignKeyWithMultiRowSupport(target, valuesTable, cxt, foreignTable, foreignKeyIndex, !f, resType, env);
                return;
            }
            if (f) {
                if (!StringUtils.isEmpty((CharSequence)s)) {
                    IOpenCast cast = cxt.getCast(resType, fieldType);
                    if (cast == null || !cast.isImplicit()) {
                        String message = MessageUtils.getIncompatibleTypesErrorMessage((IOpenField)this.getField(), (IOpenClass)fieldType, (IOpenClass)resType);
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
                    }
                    Object res = this.getValueByForeignKeyIndex(cxt, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, valuesTable, s);
                    this.getField().set(target, cast.convert(res), env);
                }
            } else {
                IOpenClass componentType = this.getComponentType(fieldType);
                IOpenCast cast = null;
                if (fieldType.isArray() && ((cast = cxt.getCast(resType, componentType)) == null || !cast.isImplicit())) {
                    String message = MessageUtils.getIncompatibleTypesErrorMessage((IOpenField)this.getField(), (IOpenClass)fieldType, (IOpenClass)resType.getArrayType(1));
                    throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
                }
                ArrayList<Object> cellValues = this.getArrayValuesByForeignKey(valuesTable, cxt, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens);
                List values = CollectionUtils.findAll(cellValues, Objects::nonNull);
                if (!values.isEmpty()) {
                    int size = values.size();
                    Object v = fieldType.getAggregateInfo().makeIndexedAggregate(componentType, size);
                    boolean isList = ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), List.class);
                    boolean isSet = ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), Set.class);
                    for (int i = 0; i < size; ++i) {
                        Object value = values.get(i);
                        if (cast != null) {
                            value = cast.convert(value);
                        }
                        if (isList) {
                            ((List)v).set(i, cast != null ? cast.convert(value) : value);
                            continue;
                        }
                        if (isSet) {
                            ((Set)v).add(cast != null ? cast.convert(value) : value);
                            continue;
                        }
                        Array.set(v, i, value);
                    }
                    this.getField().set(target, v, env);
                }
            }
        }
    }

    private IOpenClass getComponentType(IOpenClass fieldType) {
        return this.isValuesAnArray() ? fieldType.getAggregateInfo().getComponentType(fieldType) : JavaOpenClass.OBJECT;
    }

    private void populateLiteralByForeignKeyWithMultiRowSupport(Object target, ILogicalTable valuesTable, IBindingContext cxt, ITable foreignTable, int foreignKeyIndex, boolean isCollection, IOpenClass resType, IRuntimeEnv env) throws Exception {
        DatatypeArrayMultiRowElementContext context = (DatatypeArrayMultiRowElementContext)env.getLocalFrame()[0];
        IOpenClass fieldType = this.getField().getType();
        for (int i = 0; i < valuesTable.getSource().getHeight(); ++i) {
            context.setRow(i);
            ILogicalTable logicalTable = (ILogicalTable)LogicalTableHelper.logicalTable((IGridTable)valuesTable.getSource().getSubtable(0, i, 1, i + 1)).getSubtable(0, 0, 1, 1);
            if (isCollection) {
                Object v;
                int size;
                ArrayList<Object> cellValues = this.getArrayValuesByForeignKey(logicalTable, cxt, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens);
                List values = CollectionUtils.findAll(cellValues, Objects::nonNull);
                IOpenClass componentType = this.getComponentType(fieldType);
                Object currentValue = this.getField().get(target, env);
                boolean isList = ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), List.class);
                boolean isSet = ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), Set.class);
                boolean isArray = !isList && !isSet;
                int shift = 0;
                if (currentValue == null) {
                    size = isArray ? values.size() : 0;
                    v = fieldType.getAggregateInfo().makeIndexedAggregate(componentType, size);
                } else if (isArray) {
                    shift = Array.getLength(currentValue);
                    size = values.size() + shift;
                    v = fieldType.getAggregateInfo().makeIndexedAggregate(componentType, size);
                    System.arraycopy(currentValue, 0, v, 0, shift);
                } else {
                    v = currentValue;
                }
                for (int j = 0; j < values.size(); ++j) {
                    Object value = values.get(j);
                    if (isList) {
                        ((List)v).add(value);
                        continue;
                    }
                    if (isSet) {
                        ((Set)v).add(value);
                        continue;
                    }
                    Array.set(v, j + shift, value);
                }
                this.getField().set(target, v, env);
                continue;
            }
            String s = this.getCellStringValue(logicalTable);
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            Object res = this.getValueByForeignKeyIndex(cxt, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, logicalTable, s);
            IOpenCast cast = cxt.getCast(resType, fieldType);
            if (cast == null || !cast.isImplicit()) {
                String message = MessageUtils.getIncompatibleTypesErrorMessage((IOpenField)this.getField(), (IOpenClass)fieldType, (IOpenClass)resType);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
            this.getField().set(target, cast.convert(res), env);
        }
    }

    private int getForeignKeyIndex(ITable foreignTable) {
        if (foreignTable != null) {
            if (this.foreignKey != null) {
                String columnName = this.foreignKey.getIdentifier();
                return foreignTable.getColumnIndex(columnName);
            }
            ColumnDescriptor descriptor = foreignTable.getDataModel().getDescriptors()[0];
            if (descriptor.isPrimaryKey()) {
                return descriptor.getColumnIdx();
            }
            ColumnDescriptor firstColDescriptor = foreignTable.getDataModel().getDescriptor(0);
            if (firstColDescriptor.isPrimaryKey()) {
                return descriptor.getColumnIdx();
            }
            return 0;
        }
        return -1;
    }

    public DomainOpenClass getDomainClassForForeignTable(IDataBase db) throws SyntaxNodeException {
        if (this.foreignKeyTable != null) {
            String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
            ITable foreignTable = db.getTable(foreignKeyTableName);
            int foreignKeyIndex = this.getForeignKeyIndex(foreignTable);
            if (foreignKeyIndex == -1) {
                return null;
            }
            return this.getDomainClass(foreignTable, foreignKeyIndex);
        }
        return null;
    }

    private DomainOpenClass getDomainClass(ITable foreignTable, int foreignKeyIndex) throws SyntaxNodeException {
        if (this.getField() == null) {
            return null;
        }
        Collection<Object> foreignTableValues = foreignTable.getUniqueValues(foreignKeyIndex);
        IOpenClass columnType = foreignTable.getColumnType(foreignKeyIndex);
        if (columnType == null || !columnType.isSimple()) {
            columnType = JavaOpenClass.OBJECT;
        }
        Object[] foreignArray = new Object[foreignTableValues.size()];
        int i = 0;
        Iterator<Object> iterator = foreignTableValues.iterator();
        while (iterator.hasNext()) {
            IObjectToDataConvertor convertor;
            Object foreignValue;
            foreignArray[i] = foreignValue = iterator.next();
            if (foreignValue != null && !(foreignValue instanceof String) && (convertor = ObjectToDataConvertorFactory.getConvertor(columnType.getInstanceClass(), foreignValue.getClass())) != ObjectToDataConvertorFactory.NO_Convertor) {
                foreignArray[i] = convertor.convert(foreignValue);
            }
            ++i;
        }
        EnumDomain domain = new EnumDomain(foreignArray);
        return new DomainOpenClass(this.getField().getName(), columnType, (IDomain)domain, null, null);
    }

    private ResultChainObject getChainObject(IBindingContext bindingContext, IOpenClass resType, Object parentObj, IdentifierNode[] fieldChainTokens) {
        Object resObj = parentObj;
        if (fieldChainTokens.length > 1) {
            IOpenField openField = DataTableBindHelper.processFieldsChain(bindingContext, null, resType, (IdentifierNode[])ArrayUtils.subarray((Object[])fieldChainTokens, (int)1, (int)fieldChainTokens.length));
            if (openField == null) {
                return null;
            }
            resObj = openField.get(resObj, (IRuntimeEnv)new SimpleRulesVM().getRuntimeEnv());
            resType = openField.getType();
        }
        return new ResultChainObject(resObj, resType);
    }

    public IdentifierNode getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public IdentifierNode getForeignKey() {
        return this.foreignKey;
    }

    public CellKey getForeignKeyCellCoordinate() {
        return this.foreignKeyCellCoordinate;
    }

    public IOpenField getForeignKeyField(IOpenClass type, IDataBase db) {
        if (this.foreignKeyColumnChainTokens.length > 0) {
            String fieldName = this.foreignKeyColumnChainTokens[this.foreignKeyColumnChainTokens.length - 1];
            if (ForeignKeyColumnDescriptor.isValuesAnArray(type)) {
                type = type.getComponentClass();
            }
            ITable table = db == null || this.foreignKeyTable == null ? null : db.getTable(this.foreignKeyTable.getIdentifier());
            return table == null ? type.getField(fieldName) : DataTableBindHelper.findField(fieldName, table, type);
        }
        return null;
    }

    static class ResultChainObject {
        private final Object value;
        private final IOpenClass type;

        ResultChainObject(Object value, IOpenClass type) {
            this.value = value;
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public IOpenClass getType() {
            return this.type;
        }
    }
}

