/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ContextPropertyBinderUtils;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.classloader.OpenLClassLoader;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.gen.ByteCodeGenerationException;
import org.openl.gen.FieldDescription;
import org.openl.gen.TypeDescription;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.gen.FieldDescriptionBuilder;
import org.openl.rules.datatype.gen.JavaBeanClassBuilder;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.lang.xls.types.DatatypeOpenField;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.DatatypeTableMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.impl.InternalDatatypeClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayUtils;
import org.openl.util.ClassUtils;
import org.openl.util.ParserUtils;
import org.openl.util.StringUtils;
import org.openl.util.TableNameChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeTableBoundNode
implements IMemberBoundNode {
    private static final Pattern CONTEXT_SPLITTER = Pattern.compile("\\s*:\\s*context\\s*");
    public static final String NON_TRANSIENT_FIELD_SUFFIX = "*";
    public static final String TRANSIENT_FIELD_SUFFIX = "~";
    private static final Logger LOG = LoggerFactory.getLogger(DatatypeTableBoundNode.class);
    private final TableSyntaxNode tableSyntaxNode;
    private final DatatypeOpenClass dataType;
    private final IdentifierNode parentClassIdentifier;
    private final String parentClassName;
    private final ModuleOpenClass moduleOpenClass;
    private DatatypeTableBoundNode parentDatatypeTableBoundNode;
    private boolean generated;
    private boolean generatingInProcess;
    private boolean byteCodeReadyToLoad;
    private ILogicalTable table;
    private final OpenL openl;
    private Map<String, FieldDescription> fields;

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl) {
        this(tableSyntaxNode, datatype, moduleOpenClass, table, openl, null);
    }

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl, IdentifierNode parentClassIdentifier) {
        this.tableSyntaxNode = tableSyntaxNode;
        this.dataType = datatype;
        this.table = table;
        this.openl = openl;
        this.parentClassIdentifier = parentClassIdentifier;
        this.parentClassName = parentClassIdentifier != null ? parentClassIdentifier.getIdentifier() : null;
        this.moduleOpenClass = moduleOpenClass;
    }

    public static GridCellSourceCodeModule getCellSource(ILogicalTable row, IBindingContext cxt, int columnIndex) {
        return new GridCellSourceCodeModule(((ILogicalTable)row.getColumn(columnIndex)).getSource(), cxt);
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFieldsAndGenerateByteCode(IBindingContext bindingContext) {
        List errors;
        ILogicalTable dataTable;
        this.table = dataTable = DatatypeHelper.getNormalizedDataPartTable(this.table, this.openl, bindingContext);
        int tableHeight = 0;
        if (dataTable != null) {
            tableHeight = dataTable.getHeight();
        }
        this.fields = new LinkedHashMap<String, FieldDescription>();
        boolean useTransientSuffix = true;
        for (int i = 0; i < tableHeight; ++i) {
            if (!DatatypeTableBoundNode.fieldNameEndsWithNonTransientSuffix((ILogicalTable)dataTable.getRow(i), bindingContext)) continue;
            useTransientSuffix = false;
            break;
        }
        bindingContext.pushErrors();
        try {
            for (int i = 0; i < tableHeight; ++i) {
                this.processRow((ILogicalTable)dataTable.getRow(i), bindingContext, this.fields, i == 0, useTransientSuffix);
            }
            this.validateInheritedFieldsDuplication(bindingContext);
            this.validateContextPropertyFields(bindingContext);
        }
        finally {
            errors = bindingContext.popErrors();
            errors.forEach(arg_0 -> ((IBindingContext)bindingContext).addError(arg_0));
        }
        if (errors.isEmpty() && this.beanClassCanBeGenerated(bindingContext)) {
            String datatypeClassName = this.dataType.getJavaName();
            OpenLClassLoader classLoader = (OpenLClassLoader)Thread.currentThread().getContextClassLoader();
            try {
                Class beanClass = classLoader.loadClass(datatypeClassName);
                this.byteCodeReadyToLoad = true;
                this.validateDatatypeClass(beanClass, this.fields, bindingContext);
                LOG.debug("Class '{}' is loaded from classloader.", (Object)datatypeClassName);
            }
            catch (ClassNotFoundException e) {
                try {
                    byte[] byteCode = this.buildByteCodeForDatatype(this.fields);
                    classLoader.addGeneratedClass(datatypeClassName, byteCode);
                    this.dataType.setBytecode(byteCode);
                    this.byteCodeReadyToLoad = true;
                    LOG.debug("Class '{}' is generated and loaded to classloader.", (Object)datatypeClassName);
                }
                catch (ByteCodeGenerationException e1) {
                    LOG.debug("Error occurred: ", (Throwable)e1);
                    String errorMessage = String.format("Failed to generate a class for datatype '%s'. %s", datatypeClassName, e1.getMessage());
                    BindHelper.processError((String)errorMessage, (Throwable)e1, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)bindingContext);
                }
                catch (Exception e2) {
                    LOG.debug("Error occurred: ", (Throwable)e2);
                    String errorMessage = String.format("Failed to generate a class for datatype '%s'.", datatypeClassName);
                    BindHelper.processError((String)errorMessage, (Throwable)e2, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)bindingContext);
                }
            }
        }
    }

    private void validateContextPropertyFields(IBindingContext bindingContext) {
        HashMap contextPropertiesCounter = new HashMap();
        this.dataType.getFields().stream().filter(f -> Objects.nonNull(f.getContextProperty())).forEach(e -> contextPropertiesCounter.merge(e.getContextProperty(), 1, Integer::sum));
        for (Map.Entry entry : contextPropertiesCounter.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            String errorMessage = String.format("Multiple fields refer to the same context property '%s'.", entry.getKey());
            BindHelper.processError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)bindingContext);
        }
    }

    private boolean beanClassCanBeGenerated(IBindingContext cxt) {
        if (this.parentClassName != null) {
            IOpenClass parentClass = cxt.findType("org.openl.this", this.parentClassName);
            return parentClass != null;
        }
        return true;
    }

    private void extractParentFields(DatatypeTableBoundNode datatypeTableBoundNode, LinkedHashMap<String, FieldDescription> parentFields, Set<DatatypeTableBoundNode> used) {
        if (datatypeTableBoundNode.parentDatatypeTableBoundNode != null) {
            if (used.contains(datatypeTableBoundNode.parentDatatypeTableBoundNode)) {
                return;
            }
            used.add(datatypeTableBoundNode.parentDatatypeTableBoundNode);
            this.extractParentFields(datatypeTableBoundNode.parentDatatypeTableBoundNode, parentFields, used);
            parentFields.putAll(datatypeTableBoundNode.parentDatatypeTableBoundNode.getFields());
        } else if (datatypeTableBoundNode.dataType.getSuperClass() != null) {
            for (IOpenField field : datatypeTableBoundNode.dataType.getSuperClass().getFields()) {
                parentFields.put(field.getName(), new FieldDescription(field.getType().getJavaName()));
            }
        }
    }

    private byte[] buildByteCodeForDatatype(Map<String, FieldDescription> fields) {
        String datatypeClassName = this.dataType.getJavaName();
        IOpenClass superOpenClass = this.dataType.getSuperClass();
        JavaBeanClassBuilder beanBuilder = new JavaBeanClassBuilder(datatypeClassName);
        if (superOpenClass != null) {
            beanBuilder.setParentType(new TypeDescription(superOpenClass.getJavaName()));
            if (superOpenClass instanceof DatatypeOpenClass) {
                LinkedHashMap<String, FieldDescription> parentFields = new LinkedHashMap<String, FieldDescription>();
                this.extractParentFields(this, parentFields, new HashSet<DatatypeTableBoundNode>());
                for (Map.Entry<String, FieldDescription> field : parentFields.entrySet()) {
                    beanBuilder.addParentField(field.getKey(), field.getValue());
                }
            }
        }
        beanBuilder.addFields(fields);
        return beanBuilder.byteCode();
    }

    private Map<String, FieldDescription> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, FieldDescription> fields) {
        this.fields = fields;
    }

    /*
     * WARNING - void declaration
     */
    private void validateDatatypeClass(Class<?> datatypeClass, Map<String, FieldDescription> fields, IBindingContext cxt) {
        Object errorMessage;
        String datatypeClassName = this.dataType.getJavaName();
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null && !datatypeClass.getSuperclass().getName().equals(superClass.getJavaName())) {
            String errorMessage2 = String.format("Invalid parent class in the '%s' class. Update the class so that it is compatible with the datatype.\n", datatypeClassName);
            BindHelper.processError((String)errorMessage2, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
        }
        try {
            datatypeClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            errorMessage = String.format("Default constructor is not found in the '%s' class. \" + \" Update the class so that it is compatible with the datatype.", datatypeClassName);
            BindHelper.processError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
        }
        Object instance = null;
        try {
            instance = datatypeClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.debug("Error occurred: ", (Throwable)e);
            String string = String.format("Default constructor is not found in class '%s' or the class is not instantiatable. Please, update the class to be compatible with the datatype.", datatypeClassName);
            BindHelper.processError((String)string, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
        }
        for (Map.Entry<String, FieldDescription> entry : fields.entrySet()) {
            void var12_23;
            String fieldName = entry.getKey();
            FieldDescription fieldDescription = entry.getValue();
            try {
                Field field = datatypeClass.getDeclaredField(fieldName);
                if (fieldDescription.isTransient() != Modifier.isTransient(field.getModifiers()) || fieldDescription.isTransient() && !field.isAnnotationPresent(XmlTransient.class) || !fieldDescription.isTransient() && field.isAnnotationPresent(XmlTransient.class)) {
                    String string = String.format("The '%s' field is " + (fieldDescription.isTransient() ? "not " : "") + "transient in the '%s' class. Update the class so that it is compatible with the datatype.", fieldName, datatypeClassName);
                    BindHelper.processError((String)string, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                }
            }
            catch (NoSuchFieldException e) {
                LOG.debug("Error occurred: ", (Throwable)e);
                String string = String.format("The '%s' %s is not found in the '%s' class. Update the class so that it is compatible with the datatype.", fieldName, this.dataType.isStatic() ? "static field" : "field", datatypeClassName);
                BindHelper.processError((String)string, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
            }
            String name = ClassUtils.capitalize((String)fieldName);
            Object var12_28 = null;
            try {
                Method method = datatypeClass.getMethod("get" + name, new Class[0]);
                if (fieldDescription.isTransient() && !method.isAnnotationPresent(XmlTransient.class) || !fieldDescription.isTransient() && method.isAnnotationPresent(XmlTransient.class)) {
                    String errorMessage5 = String.format("The '%s' field is " + (fieldDescription.isTransient() ? "not " : "") + "transient in the '%s' class. Update the class so that it is compatible with the datatype.", fieldName, datatypeClassName);
                    BindHelper.processError((String)errorMessage5, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                }
            }
            catch (NoSuchMethodException e) {
                String errorMessage4 = String.format("The 'get%s' method is not found in the '%s' class. Update the class so that it is compatible with the datatype.", name, datatypeClassName);
                name = StringUtils.capitalize((String)fieldName);
                try {
                    Method method = datatypeClass.getMethod("get" + name, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    BindHelper.processError((String)errorMessage4, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                }
            }
            if (var12_23 != null) {
                String errorMessage2;
                if (!var12_23.getReturnType().getName().equals(fieldDescription.getTypeName())) {
                    errorMessage2 = String.format("Unexpected return type for method '%s' in class '%s'. Please, update the class to be compatible with the datatype.", var12_23.getName(), datatypeClassName);
                    BindHelper.processError((String)errorMessage2, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                } else if (!Modifier.isPublic(var12_23.getModifiers())) {
                    errorMessage2 = String.format("Unexpected access modifier on method '%s' in class '%s'. Please, update the class to be compatible with the datatype.", var12_23.getName(), datatypeClassName);
                    BindHelper.processError((String)errorMessage2, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                } else if (instance != null && entry.getValue().getDefaultValue() != null) {
                    boolean f = false;
                    try {
                        Object defaultValue;
                        if (entry.getValue().hasDefaultKeyWord()) {
                            defaultValue = var12_23.invoke(instance, new Object[0]);
                            if (defaultValue == null) {
                                f = true;
                            }
                        } else if (entry.getValue().hasDefaultValue()) {
                            defaultValue = var12_23.invoke(instance, new Object[0]);
                            if (var12_23.getReturnType().isArray() && defaultValue.getClass().isArray()) {
                                if (!ArrayUtils.deepEquals((Object)entry.getValue().getDefaultValue(), (Object)defaultValue)) {
                                    f = true;
                                }
                            } else if (!Objects.equals(entry.getValue().getDefaultValue(), defaultValue)) {
                                f = true;
                            }
                        }
                    }
                    catch (LinkageError | ReflectiveOperationException e) {
                        LOG.debug("Ignored error: ", e);
                    }
                    if (f) {
                        String errorMessage3 = String.format("The default value for the '%s' field in the '%s' class mismatches the default value used in the '%s' datatype. Update the class so that it is compatible with the datatype.", entry.getKey(), datatypeClassName, this.dataType.getName());
                        BindHelper.processError((String)errorMessage3, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                    }
                }
            }
            String setterMethodName = "set" + name;
            Method[] methods = datatypeClass.getMethods();
            boolean found = false;
            for (Method method : methods) {
                if (!method.getName().equals(setterMethodName) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals(fieldDescription.getTypeName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            String errorMessage7 = String.format("The '%s(%s)' method is not found in the '%s' class. Update the class so that it is compatible with the datatype.", setterMethodName, fieldDescription.getTypeName(), datatypeClassName);
            BindHelper.processError((String)errorMessage7, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
        }
        if (this.parentDatatypeTableBoundNode != null) {
            void var12_35;
            Constructor<?>[] x;
            if (datatypeClass.getSuperclass() == null || !Objects.equals(this.parentDatatypeTableBoundNode.getDataType().getJavaName(), datatypeClass.getSuperclass().getName())) {
                errorMessage = String.format("Invalid parent class '%s' is found in class '%s'. Please, update the class to be compatible with the datatype.", datatypeClass.getSuperclass() != null ? " " + datatypeClass.getSuperclass().getTypeName() : "", datatypeClassName);
                BindHelper.processError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
            }
            for (Map.Entry entry : this.parentDatatypeTableBoundNode.getFields().entrySet()) {
                try {
                    Field f = datatypeClass.getSuperclass().getDeclaredField((String)entry.getKey());
                    if (Modifier.isPublic(f.getModifiers()) || Modifier.isProtected(f.getModifiers())) continue;
                    String errorMessage8 = String.format("An invalid access modifier is found for the '%s' field in the '%s' class. Update the class so that it is compatible with the datatype.", entry.getKey(), datatypeClass.getSuperclass().getTypeName());
                    BindHelper.processError((String)errorMessage8, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                }
                catch (NoSuchFieldException e) {
                    LOG.debug("Ignored error: ", (Throwable)e);
                }
            }
            boolean g = false;
            LinkedList<FieldDescription> linkedList = new LinkedList<FieldDescription>();
            DatatypeTableBoundNode p = this.parentDatatypeTableBoundNode;
            while (p != null) {
                x = new LinkedList();
                for (FieldDescription fieldDescription : p.getFields().values()) {
                    x.addFirst(fieldDescription);
                }
                for (FieldDescription fieldDescription : x) {
                    linkedList.addFirst(fieldDescription);
                }
                p = p.parentDatatypeTableBoundNode;
            }
            x = datatypeClass.getSuperclass().getConstructors();
            int n = x.length;
            boolean bl = false;
            while (var12_35 < n) {
                Constructor<?> constructor = x[var12_35];
                if (constructor.getParameterCount() == linkedList.size()) {
                    int i = 0;
                    boolean f = true;
                    for (FieldDescription fieldDescription : linkedList) {
                        if (!constructor.getParameterTypes()[i].getName().equals(fieldDescription.getTypeName())) {
                            f = false;
                            break;
                        }
                        ++i;
                    }
                    if (f) {
                        g = true;
                        break;
                    }
                }
                ++var12_35;
            }
            if (!g) {
                String errorMessage4 = String.format("A mandatory constructor with parameters is not found in the '%s' class. Update the class so that it is compatible with the datatype.", datatypeClass.getSuperclass().getTypeName());
                BindHelper.processError((String)errorMessage4, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
            }
        }
    }

    private static boolean fieldNameEndsWithNonTransientSuffix(ILogicalTable row, IBindingContext bindingContext) {
        GridCellSourceCodeModule nameCellSource = DatatypeTableBoundNode.getCellSource(row, bindingContext, 1);
        String rawFieldName = nameCellSource.getCode();
        return rawFieldName.matches("^[^\\s]+\\*(\\s*:\\s*context.*)?$");
    }

    private void processRow(ILogicalTable row, IBindingContext bindingContext, Map<String, FieldDescription> fields, boolean firstRow, boolean useTransientSuffix) {
        String contextProperty;
        GridCellSourceCodeModule typeCellSource = DatatypeTableBoundNode.getCellSource(row, bindingContext, 0);
        if (ParserUtils.isBlankOrCommented((String)typeCellSource.getCode())) {
            return;
        }
        if (row.getWidth() < 2) {
            String errorMessage = "Bad table structure: expected {header} / {type | name}.";
            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)typeCellSource, (IBindingContext)bindingContext);
            return;
        }
        IOpenClass fieldType = OpenLManager.makeType((OpenL)bindingContext.getOpenL(), (String)typeCellSource.getCode(), (IOpenSourceCodeModule)typeCellSource, (IBindingContext)bindingContext);
        if (fieldType == NullOpenClass.the) {
            fieldType = JavaOpenClass.OBJECT;
        }
        GridCellSourceCodeModule nameCellSource = DatatypeTableBoundNode.getCellSource(row, bindingContext, 1);
        String code = nameCellSource.getCode();
        String[] parts = CONTEXT_SPLITTER.split(code, 2);
        String rawFieldName = parts[0];
        boolean isTransient = useTransientSuffix ? rawFieldName.endsWith(TRANSIENT_FIELD_SUFFIX) : !rawFieldName.endsWith(NON_TRANSIENT_FIELD_SUFFIX);
        String fieldName = DatatypeTableBoundNode.extractFieldName(rawFieldName);
        if (TableNameChecker.isInvalidJavaIdentifier((String)fieldName)) {
            String errorMessage = String.format("Bad field name: '%s'.", fieldName);
            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)nameCellSource, (IBindingContext)bindingContext);
            return;
        }
        if (parts.length > 1) {
            contextProperty = parts[1];
            if (contextProperty.isEmpty()) {
                contextProperty = fieldName;
            } else if (contextProperty.startsWith(".") && TableNameChecker.isInvalidJavaIdentifier((String)(contextProperty = StringUtils.trim((String)contextProperty.substring(1))))) {
                String errorMessage = String.format("Bad context property name: '%s'.", contextProperty);
                BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)nameCellSource, (IBindingContext)bindingContext);
                return;
            }
            String errorMessage = ContextPropertyBinderUtils.validateContextProperty(contextProperty, fieldType, bindingContext);
            if (errorMessage != null) {
                contextProperty = null;
                GridCellSourceCodeModule cellSource = DatatypeTableBoundNode.getCellSource(row, bindingContext, 1);
                BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)cellSource, (IBindingContext)bindingContext);
            }
        } else {
            contextProperty = null;
        }
        if (fields.containsKey(fieldName)) {
            String errorMessage = String.format("Field '%s' is already declared.", fieldName);
            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)nameCellSource, (IBindingContext)bindingContext);
            return;
        }
        if (fields.containsKey(ClassUtils.decapitalize((String)fieldName)) || fields.containsKey(ClassUtils.capitalize((String)fieldName))) {
            String f = null;
            if (fields.containsKey(ClassUtils.decapitalize((String)fieldName))) {
                f = ClassUtils.decapitalize((String)fieldName);
            }
            if (fields.containsKey(ClassUtils.capitalize((String)fieldName))) {
                f = ClassUtils.capitalize((String)fieldName);
            }
            String errorMessage = String.format("Field '%s' conflicts with field '%s'.", fieldName, f);
            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)nameCellSource, (IBindingContext)bindingContext);
        }
        FieldDescriptionBuilder fieldDescriptionBuilder = FieldDescriptionBuilder.create(fieldType.getJavaName()).setTransient(isTransient).setContextPropertyName(contextProperty);
        fieldDescriptionBuilder.setContextPropertyName(contextProperty);
        Object defaultValue = null;
        GridCellSourceCodeModule defaultValueCellSource = null;
        String defaultValueCode = null;
        if (row.getWidth() > 2) {
            defaultValueCellSource = DatatypeTableBoundNode.getCellSource(row, bindingContext, 2);
            defaultValueCode = defaultValueCellSource.getCode();
            if (ParserUtils.isBlankOrCommented((String)defaultValueCode)) {
                defaultValueCode = null;
            }
            defaultValue = defaultValueCode;
            ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(bindingContext, defaultValueCode);
            if (constantOpenField != null) {
                defaultValue = constantOpenField.getValue();
                fieldDescriptionBuilder.setDefaultValue(defaultValue);
                fieldDescriptionBuilder.setDefaultValueAsString(constantOpenField.getValueAsString());
                if (!bindingContext.isExecutionMode()) {
                    ICell cell = defaultValueCellSource.getCell();
                    MetaInfoReader metaInfoReader = this.tableSyntaxNode.getMetaInfoReader();
                    if (metaInfoReader instanceof BaseMetaInfoReader) {
                        ((BaseMetaInfoReader)metaInfoReader).addConstant(cell, constantOpenField);
                    }
                }
            } else {
                ICell theCellValue;
                fieldDescriptionBuilder.setDefaultValueAsString(defaultValueCode);
                if (String.class != fieldType.getInstanceClass() && (theCellValue = ((ILogicalTable)row.getColumn(2)).getCell(0, 0)).hasNativeType()) {
                    defaultValue = RuleRowHelper.loadNativeValue(theCellValue, fieldType);
                    if (defaultValue == null && !"_DEFAULT_".equals(defaultValueCode)) {
                        defaultValue = String2DataConvertorFactory.parse(fieldType.getInstanceClass(), defaultValueCode, bindingContext);
                    }
                    if (defaultValue != null) {
                        fieldDescriptionBuilder.setDefaultValue(defaultValue);
                    }
                }
            }
        }
        try {
            FieldDescription fieldDescription = fieldDescriptionBuilder.build();
            if (defaultValue != null && !fieldDescription.hasDefaultKeyWord()) {
                try {
                    RuleRowHelper.validateValue(defaultValue, fieldType);
                }
                catch (Exception e) {
                    BindHelper.processError((Throwable)e, (IOpenSourceCodeModule)defaultValueCellSource, (IBindingContext)bindingContext);
                }
            }
            fields.put(fieldName, fieldDescription);
        }
        catch (RuntimeException e) {
            String errorMessage = String.format("Cannot parse cell value '%s'.", defaultValueCode);
            BindHelper.processError((String)errorMessage, (Throwable)e, (IOpenSourceCodeModule)defaultValueCellSource, (IBindingContext)bindingContext);
        }
        DatatypeOpenField field = new DatatypeOpenField((IOpenClass)this.dataType, fieldName, fieldType, contextProperty, isTransient);
        this.dataType.addField((IOpenField)field);
        if (firstRow) {
            this.dataType.setIndexField((IOpenField)field);
        }
    }

    private static String extractFieldName(String fieldName) {
        return fieldName.endsWith(NON_TRANSIENT_FIELD_SUFFIX) || fieldName.endsWith(TRANSIENT_FIELD_SUFFIX) ? fieldName.substring(0, fieldName.length() - 1) : fieldName;
    }

    public void addTo(ModuleOpenClass openClass) {
        InternalDatatypeClass internalClassMember = new InternalDatatypeClass((IOpenClass)this.dataType, (IOpenClass)openClass);
        this.tableSyntaxNode.setMember((IOpenMember)internalClassMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        try {
            if (!this.byteCodeReadyToLoad) {
                return;
            }
            OpenLClassLoader classLoader = (OpenLClassLoader)Thread.currentThread().getContextClassLoader();
            Class datatypeClass = classLoader.loadClass(this.dataType.getJavaName());
            this.dataType.setInstanceClass(datatypeClass);
            this.moduleOpenClass.addType((IOpenClass)this.dataType);
        }
        catch (ClassNotFoundException | LinkageError e) {
            LOG.debug("Error occurred: ", e);
            String errorMessage = String.format("Failed to load a class for datatype '%s'.", this.dataType.getJavaName());
            BindHelper.processError((String)errorMessage, (Throwable)e, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)bindingContext);
        }
        finally {
            this.fields = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateByteCode(IBindingContext bindingContext) throws Exception {
        if (!bindingContext.isExecutionMode()) {
            this.tableSyntaxNode.setMetaInfoReader(new DatatypeTableMetaInfoReader(this));
        }
        if (!this.generated) {
            if (this.generatingInProcess) {
                throw new OpenLCompilationException(String.format("Circular dependency with respect to inheritance '%s' is detected.", this.parentClassName));
            }
            this.generatingInProcess = true;
            try {
                if (this.parentClassName != null) {
                    DatatypeOpenClass parentOpenClass;
                    DatatypeTableBoundNode parentBoundNode = this.getParentDatatypeTableBoundNode();
                    if (parentBoundNode != null) {
                        parentBoundNode.generateByteCode(bindingContext);
                        parentOpenClass = parentBoundNode.getDataType();
                    } else {
                        parentOpenClass = bindingContext.findType("org.openl.this", this.parentClassName);
                    }
                    if (parentOpenClass == null) {
                        this.byteCodeReadyToLoad = true;
                        throw new OpenLCompilationException(String.format("Parent class '%s' is not found.", this.parentClassName));
                    }
                    if (parentOpenClass.getInstanceClass() != null) {
                        if (Modifier.isFinal(parentOpenClass.getInstanceClass().getModifiers())) {
                            throw new OpenLCompilationException(String.format("Cannot inherit from final class '%s'.", this.parentClassName));
                        }
                        try {
                            parentOpenClass.getInstanceClass().getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException e) {
                            throw new OpenLCompilationException(String.format("Cannot inherit from class '%s'. Default constructor is not found.", this.parentClassName));
                        }
                    }
                    if (parentOpenClass instanceof DomainOpenClass) {
                        throw new OpenLCompilationException(String.format("Parent class '%s' cannot be a domain type.", this.parentClassName));
                    }
                    this.dataType.setSuperClass((IOpenClass)parentOpenClass);
                }
                this.readFieldsAndGenerateByteCode(bindingContext);
            }
            finally {
                this.generated = true;
                this.generatingInProcess = false;
            }
        }
    }

    private void validateInheritedFieldsDuplication(IBindingContext cxt) {
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null) {
            for (IOpenField field : this.dataType.getDeclaredFields()) {
                IOpenField fieldInParent = superClass.getField(field.getName());
                if (fieldInParent == null) continue;
                if (Objects.equals(fieldInParent.getType(), field.getType())) {
                    BindHelper.processWarn((String)String.format("Field '%s' is already declared in parent class '%s'.", field.getName(), fieldInParent.getDeclaringClass().getDisplayName(0)), (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                    continue;
                }
                String errorMessage = String.format("Field '%s' is already declared in class '%s' with another type.", field.getName(), fieldInParent.getDeclaringClass().getDisplayName(0));
                BindHelper.processError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
            }
        }
    }

    public void removeDebugInformation(IBindingContext cxt) {
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public DatatypeOpenClass getDataType() {
        return this.dataType;
    }

    public ILogicalTable getTable() {
        return this.table;
    }

    public IdentifierNode getParentClassIdentifier() {
        return this.parentClassIdentifier;
    }

    public DatatypeTableBoundNode getParentDatatypeTableBoundNode() {
        return this.parentDatatypeTableBoundNode;
    }

    public void setParentDatatypeTableBoundNode(DatatypeTableBoundNode parentDatatypeTableBoundNode) {
        this.parentDatatypeTableBoundNode = parentDatatypeTableBoundNode;
    }
}

