/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.objectweb.asm.ClassWriter;
import org.openl.gen.FieldDescription;
import org.openl.gen.POJOByteCodeGenerator;
import org.openl.gen.TypeDescription;

public class JavaBeanClassBuilder {
    protected final String beanName;
    protected TypeDescription parentType = POJOByteCodeGenerator.OBJECT_TYPE_DESCRIPTION;
    protected final LinkedHashMap<String, FieldDescription> parentFields = new LinkedHashMap(0);
    protected final LinkedHashMap<String, FieldDescription> fields = new LinkedHashMap(0);
    protected boolean additionalConstructor = true;
    protected boolean equalsHashCodeToStringMethods = true;
    protected final LinkedHashSet<Consumer<ClassWriter>> typeWriters = new LinkedHashSet();

    public JavaBeanClassBuilder(String beanName) {
        this.beanName = beanName.replace('.', '/');
    }

    public JavaBeanClassBuilder setParentType(TypeDescription parentType) {
        this.parentType = parentType;
        return this;
    }

    public JavaBeanClassBuilder addParentField(String name, FieldDescription type) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(type, "type type be null");
        FieldDescription put = this.parentFields.put(name, type);
        if (put != null) {
            throw new IllegalArgumentException(String.format("The same parent field '%s has been added.", name));
        }
        return this;
    }

    public JavaBeanClassBuilder writeToType(Consumer<ClassWriter> writer) {
        if (writer != null) {
            this.typeWriters.add(writer);
        }
        return this;
    }

    public JavaBeanClassBuilder addField(String name, FieldDescription type) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(type, "type type be null");
        FieldDescription put = this.fields.put(name, type);
        if (put != null) {
            throw new IllegalArgumentException(String.format("The same field '%s has been added.", name));
        }
        return this;
    }

    public JavaBeanClassBuilder addField(String name, String type) {
        this.addField(name, new FieldDescription(type));
        return this;
    }

    public JavaBeanClassBuilder addFields(Map<String, FieldDescription> fields) {
        for (Map.Entry<String, FieldDescription> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
        return this;
    }

    public JavaBeanClassBuilder withAdditionalConstructor(boolean additionalConstructor) {
        this.additionalConstructor = additionalConstructor;
        return this;
    }

    public JavaBeanClassBuilder withEqualsHashCodeToStringMethods(boolean equalsHashCodeToStringMethods) {
        this.equalsHashCodeToStringMethods = equalsHashCodeToStringMethods;
        return this;
    }

    public byte[] byteCode() {
        return new POJOByteCodeGenerator(this.beanName, this.fields, this.parentType, this.parentFields, this.typeWriters, this.additionalConstructor, this.equalsHashCodeToStringMethods, false).byteCode();
    }
}

