/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openl.domain.IIntIterator;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.dt.IBaseAction;
import org.openl.types.IOpenClass;
import org.openl.types.Invokable;
import org.openl.util.ClassUtils;
import org.openl.vm.IRuntimeEnv;

public class ActionInvoker
implements Invokable {
    private final List<Integer> firedRules = new ArrayList<Integer>();
    private final IIntIterator rulesIntIterator;
    private final IBaseAction[] actions;
    private final boolean returnEmptyResult;

    ActionInvoker(IIntIterator rulesIntIterator, IBaseAction[] actions, boolean returnEmptyResult) {
        this.rulesIntIterator = rulesIntIterator;
        this.actions = actions;
        this.returnEmptyResult = returnEmptyResult;
    }

    private static Object addReturnValues(Collection<Object> returnValue, Object returnValues, boolean[] f) {
        int returnValuesLength = Array.getLength(returnValues);
        for (int i = 0; i < returnValuesLength; ++i) {
            if (!f[i] || Array.get(returnValues, i) == null) continue;
            returnValue.add(Array.get(returnValues, i));
        }
        return returnValue;
    }

    private Object addReturnValues(Map<Object, Object> returnValue, Object returnValues, Object keyValues, boolean[] f) {
        int returnValuesLength = Array.getLength(returnValues);
        for (int i = 0; i < returnValuesLength; ++i) {
            if (!f[i] || !this.isValidResult(Array.get(keyValues, i)) || !this.isValidResult(Array.get(returnValues, i))) continue;
            returnValue.put(Array.get(keyValues, i), Array.get(returnValues, i));
        }
        return returnValue;
    }

    private Object processReturnValue(Object returnValues, Object keyValues, boolean[] f, IOpenClass type) {
        if (type.isArray()) {
            Object ret;
            int i;
            int c = 0;
            for (boolean b : f) {
                if (!b) continue;
                ++c;
            }
            int returnValuesLength = Array.getLength(returnValues);
            if (c == 0) {
                int retLength = 0;
                for (i = 0; i < returnValuesLength; ++i) {
                    if (!this.isValidResult(Array.get(returnValues, i))) continue;
                    ++retLength;
                }
                ret = Array.newInstance(type.getComponentClass().getInstanceClass(), retLength);
            } else {
                ret = Array.newInstance(type.getComponentClass().getInstanceClass(), c);
            }
            int j = 0;
            for (i = 0; i < returnValuesLength; ++i) {
                if (!f[i] && c != 0 || !this.isValidResult(Array.get(returnValues, i))) continue;
                Array.set(ret, j, Array.get(returnValues, i));
                ++j;
            }
            return ret;
        }
        if (Map.class == type.getInstanceClass()) {
            return this.addReturnValues(new HashMap<Object, Object>(), returnValues, keyValues, f);
        }
        if (SortedMap.class == type.getInstanceClass()) {
            return this.addReturnValues(new TreeMap<Object, Object>(), returnValues, keyValues, f);
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class)) {
            try {
                return this.addReturnValues((Map)type.getInstanceClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), returnValues, keyValues, f);
            }
            catch (Exception e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
        if (Collection.class == type.getInstanceClass() || List.class == type.getInstanceClass()) {
            return ActionInvoker.addReturnValues(new ArrayList<Object>(), returnValues, f);
        }
        if (Set.class == type.getInstanceClass()) {
            return ActionInvoker.addReturnValues(new HashSet<Object>(), returnValues, f);
        }
        if (SortedSet.class == type.getInstanceClass()) {
            return ActionInvoker.addReturnValues(new TreeSet<Object>(), returnValues, f);
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Collection.class)) {
            try {
                return ActionInvoker.addReturnValues((Collection)type.getInstanceClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), returnValues, f);
            }
            catch (Exception e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
        throw new OpenLRuntimeException();
    }

    private boolean isValidResult(Object actionResult) {
        return actionResult != null || this.returnEmptyResult;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        Object[] retVal = null;
        Object[] keyValues = null;
        Object returnValues = null;
        boolean[] f = null;
        boolean isCollectReturn = false;
        IOpenClass type = null;
        for (IBaseAction action : this.actions) {
            int[] rules;
            if (action.isCollectReturnAction()) {
                rules = this.getRules();
                if (returnValues == null) {
                    type = action.getType();
                    returnValues = type.isArray() ? Array.newInstance(type.getComponentClass().getInstanceClass(), rules.length) : new Object[rules.length];
                    if (f == null) {
                        f = new boolean[rules.length];
                        Arrays.fill(f, false);
                    }
                }
                this.executeActionAndWriteValues(target, params, env, returnValues, f, action, rules);
                retVal = returnValues;
                isCollectReturn = true;
                continue;
            }
            if (action.isCollectReturnKeyAction()) {
                rules = this.getRules();
                if (keyValues == null) {
                    keyValues = new Object[rules.length];
                    if (f == null) {
                        f = new boolean[rules.length];
                        Arrays.fill(f, false);
                    }
                }
                this.executeActionAndWriteValues(target, params, env, keyValues, f, action, rules);
                continue;
            }
            Object actionResult = null;
            SmartIterator itr = new SmartIterator(this.firedRules.iterator(), this.rulesIntIterator);
            ArrayList<Integer> newFiredRules = new ArrayList<Integer>();
            while (itr.hasNext()) {
                boolean g = itr.itr1.hasNext();
                int rule = itr.next();
                if (!g) {
                    newFiredRules.add(rule);
                }
                if (action.isReturnAction()) {
                    actionResult = action.executeAction(rule, target, params, env);
                    if (!this.isValidResult(actionResult)) continue;
                    break;
                }
                action.executeAction(rule, target, params, env);
            }
            this.firedRules.addAll(newFiredRules);
            if (retVal != null || actionResult == null) continue;
            retVal = actionResult;
        }
        if (isCollectReturn) {
            return this.processReturnValue(retVal, keyValues, f, type);
        }
        return retVal;
    }

    private void executeActionAndWriteValues(Object target, Object[] params, IRuntimeEnv env, Object values, boolean[] f, IBaseAction action, int[] rules) {
        for (int i = 0; i < rules.length; ++i) {
            Object actionResult = action.executeAction(rules[i], target, params, env);
            if (!this.isValidResult(actionResult) || Array.get(values, i) != null && f[i]) continue;
            Array.set(values, i, actionResult);
            f[i] = true;
        }
    }

    public int[] getRules() {
        while (this.rulesIntIterator.hasNext()) {
            this.firedRules.add(this.rulesIntIterator.nextInt());
        }
        return this.firedRules.stream().mapToInt(e -> e).toArray();
    }

    private static class SmartIterator {
        Iterator<Integer> itr1;
        IIntIterator itr2;

        public SmartIterator(Iterator<Integer> itr1, IIntIterator itr2) {
            this.itr1 = itr1;
            this.itr2 = itr2;
        }

        public boolean hasNext() {
            return this.itr1.hasNext() || this.itr2.hasNext();
        }

        public Integer next() {
            return this.itr1.hasNext() ? this.itr1.next() : (Integer)this.itr2.next();
        }
    }
}

