/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.data;

import java.util.Objects;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class ConditionOrActionDirectParameterField
implements IOpenField {
    private final int numberOfTableParameters;
    private final IDecisionRow decisionRow;
    private final int paramNum;
    private final DecisionTableDataType decisionTableDataType;

    ConditionOrActionDirectParameterField(DecisionTable decisionTable, IDecisionRow decisionRow, int paramNum, DecisionTableDataType decisionTableDataType) {
        this.numberOfTableParameters = decisionTable.getSignature().getNumberOfParameters();
        this.decisionTableDataType = Objects.requireNonNull(decisionTableDataType, "declaringClass cannot be null");
        this.decisionRow = Objects.requireNonNull(decisionRow, "decisionRow cannot be null");
        this.paramNum = paramNum;
    }

    public IBaseDecisionRow getConditionOrAction() {
        return this.decisionRow;
    }

    public Object get(Object target, IRuntimeEnv env) {
        Object ret;
        RuleExecutionObject reo = (RuleExecutionObject)((Object)target);
        int ruleNum = reo.getRuleNum();
        Object[] params = env.getLocalFrame();
        if (this.numberOfTableParameters != env.getLocalFrame().length) {
            params = new Object[this.numberOfTableParameters];
            System.arraycopy(env.getLocalFrame(), 0, params, 0, this.numberOfTableParameters);
        }
        if ((ret = this.decisionRow.loadValue(this.paramNum, ruleNum, target, params, env)) == null) {
            return this.getType().nullObject();
        }
        return ret;
    }

    public boolean isConst() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        throw new UnsupportedOperationException();
    }

    public int getParamNum() {
        return this.paramNum;
    }

    public IOpenClass getDeclaringClass() {
        return this.decisionTableDataType;
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public IOpenClass getType() {
        return this.decisionRow.getParams()[this.paramNum].getType();
    }

    public boolean isStatic() {
        return false;
    }

    public String getDisplayName(int mode) {
        return "$" + this.decisionRow.getName() + "." + this.getName();
    }

    public String getName() {
        return this.decisionRow.getParams()[this.paramNum].getName();
    }
}

