/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.engine.OpenLManager;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.text.TextInfo;

public abstract class AExecutableNodeBinder<T extends IMemberBoundNode>
extends AXlsTableBinder {
    public T preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        OpenMethodHeader header = this.createHeader(tableSyntaxNode, openl, bindingContext);
        header.setDeclaringClass((IOpenClass)module);
        this.checkForDuplicates(tableSyntaxNode, bindingContext, header);
        T node = this.createNode(tableSyntaxNode, openl, header, module, (IBindingContext)bindingContext);
        if (!bindingContext.isExecutionMode()) {
            tableSyntaxNode.setMetaInfoReader(this.createMetaInfoReader(node));
        }
        return node;
    }

    protected abstract MetaInfoReader createMetaInfoReader(T var1);

    public IOpenSourceCodeModule createHeaderSource(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) throws SyntaxNodeException {
        IGridTable table = tableSyntaxNode.getGridTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table, bindingContext);
        return new SubTextSourceCodeModule((IOpenSourceCodeModule)source, tableSyntaxNode.getHeader().getHeaderToken().getSourceLocation().getEnd().getAbsolutePosition(new TextInfo(source.getCode())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenMethodHeader createHeader(TableSyntaxNode tableSyntaxNode, OpenL openl, RulesModuleBindingContext bindingContext) throws SyntaxNodeException {
        try {
            bindingContext.setIgnoreCustomSpreadsheetResultCompilation(true);
            IOpenSourceCodeModule headerSource = this.createHeaderSource(tableSyntaxNode, (IBindingContext)bindingContext);
            OpenMethodHeader methodHeader = (OpenMethodHeader)OpenLManager.makeMethodHeader((OpenL)openl, (IOpenSourceCodeModule)headerSource, (IBindingContext)bindingContext);
            if (methodHeader == null) {
                throw SyntaxNodeExceptionUtils.createError((String)"Invalid method header.", (ISyntaxNode)tableSyntaxNode);
            }
            OpenMethodHeader openMethodHeader = methodHeader;
            return openMethodHeader;
        }
        finally {
            bindingContext.setIgnoreCustomSpreadsheetResultCompilation(false);
        }
    }

    protected abstract T createNode(TableSyntaxNode var1, OpenL var2, OpenMethodHeader var3, XlsModuleOpenClass var4, IBindingContext var5);

    private void checkForDuplicates(TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext bindingContext, OpenMethodHeader header) throws DuplicatedTableException {
        String key = this.makeKey(tableSyntaxNode, header);
        if (bindingContext.isTableSyntaxNodePresented(key)) {
            throw new DuplicatedTableException(tableSyntaxNode.getDisplayName(), tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private String makeKey(TableSyntaxNode tableSyntaxNode, OpenMethodHeader header) {
        StringBuilder builder = new StringBuilder();
        builder.append(header.getName());
        ArrayList<String> names = new ArrayList<String>();
        for (IOpenClass parameter : header.getSignature().getParameterTypes()) {
            names.add(parameter.getName());
        }
        builder.append("(").append(String.join((CharSequence)", ", names)).append(")");
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String property : TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames()) {
            values.add(tableProperties.getPropertyValue(property));
        }
        builder.append("[").append(AExecutableNodeBinder.join(values)).append(tableProperties.getVersion()).append("]");
        return builder.toString();
    }

    static String join(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(", ");
            Object obj = iterator.next();
            if (obj == null) continue;
            if (obj.getClass().isArray()) {
                buf.append(Arrays.toString((Object[])obj));
                continue;
            }
            buf.append(obj);
        }
        return buf.toString();
    }
}

