/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.dt.ADtColumnsDefinitionTableBoundNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReaderUtils;
import org.openl.rules.table.CellKey;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

public class DtColumnsDefinitionMetaInfoReader
extends BaseMetaInfoReader<ADtColumnsDefinitionTableBoundNode> {
    private final Map<CellKey, Pair<CompositeMethod, String>> expressions = new HashMap<CellKey, Pair<CompositeMethod, String>>();
    private final Map<CellKey, Triple<IOpenMethodHeader, String, Integer>> inputs = new HashMap<CellKey, Triple<IOpenMethodHeader, String, Integer>>();
    private final Map<CellKey, Pair<IParameterDeclaration, String>> parameters = new HashMap<CellKey, Pair<IParameterDeclaration, String>>();

    public DtColumnsDefinitionMetaInfoReader(ADtColumnsDefinitionTableBoundNode boundNode) {
        super(boundNode);
    }

    @Override
    protected CellMetaInfo getHeaderMetaInfo() {
        return null;
    }

    @Override
    protected TableSyntaxNode getTableSyntaxNode() {
        return ((ADtColumnsDefinitionTableBoundNode)((Object)this.getBoundNode())).getTableSyntaxNode();
    }

    @Override
    public CellMetaInfo getBodyMetaInfo(int row, int col) {
        Pair<IParameterDeclaration, String> value2;
        String stringValue;
        CellKey cellKey = CellKey.CellKeyFactory.getCellKey(col, row);
        Pair<CompositeMethod, String> value = this.expressions.get(cellKey);
        if (value != null && (stringValue = (String)value.getValue()) != null) {
            CompositeMethod method = (CompositeMethod)value.getKey();
            int startIndex = 0;
            List<NodeUsage> parsedNodeUsages = MetaInfoReaderUtils.getNodeUsages(method, stringValue, startIndex);
            ArrayList<NodeUsage> nodeUsages = new ArrayList<NodeUsage>(parsedNodeUsages);
            return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages, false);
        }
        Triple<IOpenMethodHeader, String, Integer> value1 = this.inputs.get(cellKey);
        if (value1 != null) {
            ArrayList<SimpleNodeUsage> nodeUsages = new ArrayList<SimpleNodeUsage>();
            IOpenMethodHeader header = (IOpenMethodHeader)value1.getLeft();
            for (int i = 0; i < header.getSignature().getNumberOfParameters(); ++i) {
                IOpenClass parameterType = header.getSignature().getParameterType(i);
                IMetaInfo metaInfo = parameterType.getMetaInfo();
                while (metaInfo == null && parameterType.isArray()) {
                    parameterType = parameterType.getComponentClass();
                    metaInfo = parameterType.getMetaInfo();
                }
                if (metaInfo == null || !(header instanceof OpenMethodHeader)) continue;
                OpenMethodHeader openMethodHeader = (OpenMethodHeader)header;
                ILocation[] paramTypeLocations = openMethodHeader.getParamTypeLocations();
                ILocation sourceLocation = paramTypeLocations[i];
                TextInfo text = new TextInfo((String)value1.getMiddle());
                int start = sourceLocation.getStart().getAbsolutePosition(text) - (Integer)value1.getRight();
                int end = sourceLocation.getEnd().getAbsolutePosition(text) - (Integer)value1.getRight() + 1;
                nodeUsages.add(new SimpleNodeUsage(start, end, metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), parameterType, NodeType.DATATYPE));
            }
            if (CollectionUtils.isNotEmpty(nodeUsages)) {
                return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages);
            }
        }
        if ((value2 = this.parameters.get(cellKey)) != null) {
            IOpenClass type = ((IParameterDeclaration)value2.getKey()).getType();
            while (type.getMetaInfo() == null && type.isArray()) {
                type = type.getComponentClass();
            }
            IMetaInfo metaInfo = type.getMetaInfo();
            if (metaInfo != null) {
                IdentifierNode[] paramNodes;
                StringSourceCodeModule source = new StringSourceCodeModule((String)value2.getValue(), this.getTableSyntaxNode().getUri());
                try {
                    paramNodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)"[] \n\r");
                }
                catch (OpenLCompilationException e) {
                    return null;
                }
                if (paramNodes.length > 0) {
                    SimpleNodeUsage nodeUsage = new SimpleNodeUsage(paramNodes[0], metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), type, NodeType.DATATYPE);
                    return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
                }
            }
        }
        return null;
    }

    public void addExpression(int col, int row, CompositeMethod compositeMethod, String expression) {
        this.expressions.put(CellKey.CellKeyFactory.getCellKey(col, row), (Pair<CompositeMethod, String>)Pair.of((Object)compositeMethod, (Object)expression));
    }

    public void addInput(int col, int row, IOpenMethodHeader header, String text, int from) {
        this.inputs.put(CellKey.CellKeyFactory.getCellKey(col, row), (Triple<IOpenMethodHeader, String, Integer>)Triple.of((Object)header, (Object)text, (Object)from));
    }

    public void addParameter(int col, int row, IParameterDeclaration parameterDeclaration, String text) {
        this.parameters.put(CellKey.CellKeyFactory.getCellKey(col, row), (Pair<IParameterDeclaration, String>)Pair.of((Object)parameterDeclaration, (Object)text));
    }
}

