/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.classloader.ClassLoaderUtils;
import org.openl.gen.InterfaceByteCodeBuilder;
import org.openl.gen.MethodDescriptionBuilder;
import org.openl.gen.TypeDescription;
import org.openl.rules.data.DataOpenField;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.util.ClassUtils;

public class InterfaceClassGenerator {
    private String[] includes;
    private String[] excludes;

    public InterfaceClassGenerator() {
    }

    public InterfaceClassGenerator(String[] includes, String[] excludes) {
        this.includes = Objects.requireNonNull(includes, "includes cannot be null");
        this.excludes = Objects.requireNonNull(excludes, "excludes cannot be null");
    }

    public Class<?> generateInterface(String className, IOpenClass openClass, ClassLoader classLoader) throws Exception {
        MethodDescriptionBuilder methodBuilder;
        if (!((String)className).contains(".")) {
            className = "org.openl.generated.interfaces." + (String)className;
        }
        InterfaceByteCodeBuilder classBuilder = InterfaceByteCodeBuilder.create((String)className);
        if (openClass == null) {
            return InterfaceClassGenerator.generateAndLoad((String)className, classLoader, classBuilder);
        }
        HashSet<MethodKey> methodsInClass = new HashSet<MethodKey>();
        HashMap<IOpenClass, Boolean> validationMap = new HashMap<IOpenClass, Boolean>();
        Collection methods = openClass.getMethods();
        for (IOpenMethod method : methods) {
            Class returnType;
            if (InterfaceClassGenerator.isIgnoredMember((IOpenMember)method, validationMap)) continue;
            IMethodSignature signature = method.getSignature();
            String name = method.getName();
            boolean isMember = this.isMember(name, returnType = method.getType().getInstanceClass(), signature.getParameterTypes());
            if (!isMember) continue;
            methodBuilder = MethodDescriptionBuilder.create((String)name, (Class)returnType);
            int pNum = signature.getNumberOfParameters();
            for (int i = 0; i < pNum; ++i) {
                String paramName = signature.getParameterName(i);
                String paramType = signature.getParameterType(i).getInstanceClass().getName();
                methodBuilder.addParameterName(paramName);
                methodBuilder.addParameter(new TypeDescription(paramType));
            }
            classBuilder.addAbstractMethod(methodBuilder.build());
            methodsInClass.add(new MethodKey(method));
        }
        for (IOpenField field : openClass.getFields()) {
            MethodKey key;
            Class returnType;
            String name;
            boolean isMember;
            if (InterfaceClassGenerator.isIgnoredMember((IOpenMember)field, validationMap) || !field.isReadable() || !(isMember = this.isMember(name = ClassUtils.getter((String)field.getName()), returnType = field.getType().getInstanceClass(), IOpenClass.EMPTY)) || methodsInClass.contains(key = new MethodKey(name, IOpenClass.EMPTY))) continue;
            methodBuilder = MethodDescriptionBuilder.create((String)name, (Class)returnType);
            classBuilder.addAbstractMethod(methodBuilder.build());
            methodsInClass.add(key);
        }
        return InterfaceClassGenerator.generateAndLoad((String)className, classLoader, classBuilder);
    }

    private static Class<?> generateAndLoad(String className, ClassLoader classLoader, InterfaceByteCodeBuilder builder) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        byte[] bytecode = builder.buildJava().byteCode();
        return ClassLoaderUtils.defineClass((String)className, (byte[])bytecode, (ClassLoader)classLoader);
    }

    private static boolean isIgnoredMember(IOpenMember member, Map<IOpenClass, Boolean> validationMap) {
        DataOpenField dataOpenField;
        if (member instanceof DataOpenField && (XlsNodeTypes.XLS_RUN_METHOD.equals((Object)(dataOpenField = (DataOpenField)member).getNodeType()) || XlsNodeTypes.XLS_TEST_METHOD.equals((Object)dataOpenField.getNodeType()))) {
            return true;
        }
        if (InterfaceClassGenerator.isInvalidType(member.getType(), validationMap)) {
            return true;
        }
        if (member instanceof IOpenMethod) {
            IOpenMethod openMethod = (IOpenMethod)member;
            for (IOpenClass parameterType : openMethod.getSignature().getParameterTypes()) {
                if (!InterfaceClassGenerator.isInvalidType(parameterType, validationMap)) continue;
                return true;
            }
        }
        return member instanceof JavaOpenConstructor || member instanceof ComponentOpenClass.ThisField || member instanceof ComponentOpenClass.GetOpenClass || member instanceof TestSuiteMethod;
    }

    private static boolean isInvalidType(IOpenClass openClass, Map<IOpenClass, Boolean> invalidTypeMap) {
        Boolean v = invalidTypeMap.get(openClass);
        if (v != null) {
            return v;
        }
        invalidTypeMap.put(openClass, Boolean.FALSE);
        if (openClass.isArray()) {
            boolean isInvalidComponentType = InterfaceClassGenerator.isInvalidType(openClass.getComponentClass(), invalidTypeMap);
            invalidTypeMap.put(openClass, isInvalidComponentType);
            return isInvalidComponentType;
        }
        if (openClass instanceof DatatypeOpenClass) {
            if (openClass.getInstanceClass() == null) {
                invalidTypeMap.put(openClass, Boolean.TRUE);
                return true;
            }
            for (IOpenField openField : openClass.getFields()) {
                if (!InterfaceClassGenerator.isInvalidType(openField.getType(), invalidTypeMap)) continue;
                invalidTypeMap.put(openClass, Boolean.TRUE);
                return true;
            }
        }
        if (NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{openClass})) {
            invalidTypeMap.put(openClass, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private boolean isMember(String name, Class<?> returnType, IOpenClass[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(returnType.getCanonicalName());
        sb.append(" ").append(name).append("(");
        boolean first = true;
        for (IOpenClass paramType : parameterTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(paramType.getInstanceClass().getCanonicalName());
        }
        sb.append(")");
        String methodSignature = sb.toString();
        boolean isMember = true;
        if (this.includes != null && this.includes.length > 0) {
            isMember = false;
            String[] stringArray = this.includes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String pattern = stringArray[i];
                if (!Pattern.matches(pattern, methodSignature)) continue;
                isMember = true;
            }
        }
        if (this.excludes != null && this.excludes.length > 0 && isMember) {
            for (String pattern : this.excludes) {
                if (!Pattern.matches(pattern, methodSignature)) continue;
                isMember = false;
            }
        }
        return isMember;
    }
}

