/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.expressions.sequence;

import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.expressions.sequence.FilledPropertiesPriorityRule;
import org.openl.rules.table.properties.expressions.sequence.IPriorityRule;
import org.openl.rules.types.impl.DefaultPropertiesIntersectionFinder;

public class IntersectedPropertiesPriorityRule
implements IPriorityRule {
    private static final String[] PROPERTY_NAMES = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
    private final DefaultPropertiesIntersectionFinder intersectionMatcher = new DefaultPropertiesIntersectionFinder();
    private final FilledPropertiesPriorityRule filledPropertiesRule = new FilledPropertiesPriorityRule();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compare(ITableProperties tableProperties1, ITableProperties tableProperties2) {
        boolean nested = false;
        boolean contains = false;
        block6: for (String propName : PROPERTY_NAMES) {
            switch (this.intersectionMatcher.match(propName, tableProperties1, tableProperties2)) {
                case NESTED: {
                    nested = true;
                    break;
                }
                case CONTAINS: {
                    contains = true;
                    break;
                }
                case EQUALS: {
                    break;
                }
                case NO_INTERSECTION: 
                case PARTLY_INTERSECTS: {
                    nested = false;
                    contains = false;
                    break block6;
                }
            }
        }
        if (nested && !contains) {
            return -1;
        }
        if (contains && !nested) {
            return 1;
        }
        return this.filledPropertiesRule.compare(tableProperties1, tableProperties2);
    }
}

