/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime;

import java.util.List;
import java.util.Map;
import org.openl.rules.tbasic.runtime.AlgorithmErrorHelper;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;

public class TBasicVMDataContext {
    private final List<RuntimeOperation> operations;
    private final Map<String, RuntimeOperation> labels;
    private final boolean isMainMethodContext;

    public TBasicVMDataContext(List<RuntimeOperation> operations, Map<String, RuntimeOperation> labels, boolean isMainMethod) {
        assert (operations != null);
        assert (labels != null);
        this.operations = operations;
        this.labels = labels;
        this.isMainMethodContext = isMainMethod;
    }

    public RuntimeOperation getFirstOperation() {
        return !this.operations.isEmpty() ? this.operations.get(0) : null;
    }

    public RuntimeOperation getLabeledOperation(String label) {
        return this.labels.get(label);
    }

    public Map<String, RuntimeOperation> getLabels() {
        return this.labels;
    }

    public RuntimeOperation getNextOperation(RuntimeOperation operation) {
        RuntimeOperation nextOperation = null;
        int indexOfCurrent = this.operations.indexOf(operation);
        if (indexOfCurrent > -1) {
            int indexOfNext = indexOfCurrent + 1;
            if (indexOfNext < this.operations.size()) {
                nextOperation = this.operations.get(indexOfNext);
            }
        } else {
            throw AlgorithmErrorHelper.createExecutionException("Cannot find the next operation after the specified one", operation);
        }
        return nextOperation;
    }

    public List<RuntimeOperation> getOperations() {
        return this.operations;
    }

    public boolean isLabelInContext(String label) {
        return this.labels.containsKey(label);
    }

    public boolean isMainMethodContext() {
        return this.isMainMethodContext;
    }
}

