/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.testmethod.ITestResultBuilder;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.TestDescription;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;

public class TestRunner {
    private final ITestResultBuilder resultBuilder;

    public TestRunner(ITestResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITestUnit runTest(TestDescription test, Object target, IRuntimeEnv env, int ntimes) {
        long end;
        if (ntimes <= 0) {
            return this.runTest(test, target, env, 1);
        }
        Object res = null;
        Throwable exception = null;
        IRuntimeContext oldContext = env.getContext();
        long start = System.nanoTime();
        try {
            IRulesRuntimeContext context = test.getRuntimeContext();
            env.setContext((IRuntimeContext)context);
            Object[] args = test.getArguments();
            IOpenMethod testedMethod = test.getTestedMethod();
            start = System.nanoTime();
            for (int j = 0; j < ntimes; ++j) {
                res = testedMethod.invoke(target, args, env);
            }
            end = System.nanoTime();
        }
        catch (Exception | LinkageError | StackOverflowError t) {
            end = System.nanoTime();
            exception = t;
        }
        finally {
            env.setContext(oldContext);
        }
        long time = end - start;
        return this.resultBuilder.build(test, res, exception, time);
    }
}

