/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.openl.binding.impl.CastToWiderType;
import org.openl.rules.lang.xls.TableSyntaxNodeUtils;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.BaseExport;
import org.openl.rules.testmethod.export.Cursor;
import org.openl.rules.testmethod.export.FieldDescriptor;
import org.openl.rules.testmethod.export.Styles;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.util.ClassUtils;

abstract class BaseParameterExport
extends BaseExport {
    BaseParameterExport(Styles styles) {
        this.styles = styles;
    }

    public void write(SXSSFSheet sheet, List<TestUnitsResults> tests, Boolean skipEmptyParameters) {
        if (tests.isEmpty()) {
            return;
        }
        int rowNum = 2;
        int colNum = 1;
        for (TestUnitsResults test : tests) {
            if (test.getTestSuite().getNumberOfTests() == 0) continue;
            SXSSFRow row = sheet.createRow(rowNum);
            String testName = this.getTestName(test);
            this.createCell((Row)row, colNum, "Parameters of " + testName, this.styles.parametersInfo);
            List<List<FieldDescriptor>> nonEmptyFields = this.getAllNonEmptyFields(test.getTestSuite().getTests(), skipEmptyParameters);
            Cursor start = new Cursor(rowNum += 2, colNum);
            rowNum = this.doWrite(sheet, start, test, nonEmptyFields, skipEmptyParameters);
            rowNum += 3;
        }
    }

    abstract int doWrite(SXSSFSheet var1, Cursor var2, TestUnitsResults var3, List<List<FieldDescriptor>> var4, Boolean var5);

    private String getTestName(TestUnitsResults test) {
        TestSuite testSuite = test.getTestSuite();
        TestSuiteMethod testSuiteMethod = testSuite.getTestSuiteMethod();
        if (testSuiteMethod != null) {
            return TableSyntaxNodeUtils.getTestName((IOpenMethod)testSuiteMethod);
        }
        if (testSuite.getNumberOfTests() > 0) {
            return testSuite.getTest(0).getTestedMethod().getName();
        }
        return "Unknown";
    }

    private List<List<FieldDescriptor>> getAllNonEmptyFields(TestDescription[] descriptions, Boolean skipEmptyParameters) {
        TestDescription description = descriptions[0];
        ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
        ArrayList<List<FieldDescriptor>> result = new ArrayList<List<FieldDescriptor>>(executionParams.length);
        for (int i = 0; i < executionParams.length; ++i) {
            ParameterWithValueDeclaration param = executionParams[i];
            List<Object> values = this.valuesForAllCases(descriptions, i);
            if (ClassUtils.isAssignable((Class)param.getType().getInstanceClass(), Collection.class)) {
                IOpenClass paramType = CastToWiderType.defineCollectionWiderType((Collection)((Collection)param.getValue()));
                result.add(FieldDescriptor.nonEmptyFields(paramType, values, skipEmptyParameters));
                continue;
            }
            result.add(FieldDescriptor.nonEmptyFields(param.getType(), values, skipEmptyParameters));
        }
        return result;
    }

    private List<Object> valuesForAllCases(TestDescription[] testDescriptions, int paramNum) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TestDescription description : testDescriptions) {
            ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
            if (executionParams.length > 0) {
                values.add(executionParams[paramNum].getValue());
                continue;
            }
            values.add(null);
        }
        return values;
    }

    protected Cursor performWrite(Sheet sheet, Cursor start, TreeSet<WriteTask> tasks, int lastCellNum) {
        int lowestRowNum = start.getRowNum();
        int rightColNum = start.getColNum();
        Row row = sheet.createRow(lowestRowNum);
        for (WriteTask task : tasks) {
            Cursor cursor = task.getCursor();
            int rowNum = cursor.getRowNum();
            int colNum = cursor.getColNum();
            if (rowNum > lowestRowNum) {
                this.styleEmptyCells(row, start.getColNum(), lastCellNum);
                row = sheet.createRow(rowNum);
                lowestRowNum = rowNum;
            }
            if (colNum > rightColNum) {
                rightColNum = colNum;
            }
            this.createCell(row, colNum, task.getValue(), task.getStyle());
            int height = task.getHeight();
            if (height <= 1) continue;
            int lastRow = rowNum + height - 1;
            CellRangeAddress region = new CellRangeAddress(rowNum, lastRow, colNum, colNum);
            row.getSheet().addMergedRegionUnsafe(region);
        }
        this.styleEmptyCells(row, start.getColNum(), lastCellNum);
        return new Cursor(lowestRowNum, rightColNum);
    }

    private void styleEmptyCells(Row row, int firstCellNum, int lastCellNum) {
        for (int i = firstCellNum; i <= lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null) continue;
            this.createCell(row, i, null, this.styles.parameterAbsent);
        }
    }

    static final class WriteTask
    implements Comparable<WriteTask> {
        private final Cursor cursor;
        private final Object value;
        private final CellStyle style;
        private final int height;

        WriteTask(Cursor cursor, Object value, CellStyle style) {
            this(cursor, value, style, 1);
        }

        WriteTask(Cursor cursor, Object value, CellStyle style, int height) {
            this.cursor = cursor;
            this.value = value;
            this.style = style;
            this.height = height;
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public Object getValue() {
            return this.value;
        }

        public CellStyle getStyle() {
            return this.style;
        }

        public int getHeight() {
            return this.height;
        }

        @Override
        public int compareTo(WriteTask o) {
            Cursor cursor1 = this.getCursor();
            Cursor cursor2 = o.getCursor();
            int rowComparison = cursor1.getRowNum() - cursor2.getRowNum();
            return rowComparison != 0 ? rowComparison : cursor1.getColNum() - cursor2.getColNum();
        }
    }
}

