/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.openl.rules.data.PrimaryKeyField;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.BaseParameterExport;
import org.openl.rules.testmethod.export.Cursor;
import org.openl.rules.testmethod.export.ExportUtils;
import org.openl.rules.testmethod.export.FieldDescriptor;
import org.openl.rules.testmethod.export.Styles;
import org.openl.types.IOpenField;
import org.openl.util.ClassUtils;

class ParameterExport
extends BaseParameterExport {
    ParameterExport(Styles styles) {
        super(styles);
    }

    @Override
    int doWrite(SXSSFSheet sheet, Cursor start, TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields, Boolean skipEmptyParameters) {
        int rowNum = start.getRowNum();
        Cursor lowestRight = this.writeHeaderForFields(sheet, start, test, nonEmptyFields);
        rowNum = lowestRight.getRowNum() + 1;
        return this.writeValuesForFields((Sheet)sheet, new Cursor(rowNum, start.getColNum()), test, nonEmptyFields);
    }

    private Cursor writeHeaderForFields(SXSSFSheet sheet, Cursor start, TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields) {
        TreeSet<BaseParameterExport.WriteTask> tasks = new TreeSet<BaseParameterExport.WriteTask>();
        int rowNum = start.getRowNum();
        int colNum = start.getColNum();
        tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), "ID", this.styles.header));
        TestSuite testSuite = test.getTestSuite();
        ParameterWithValueDeclaration[] params = testSuite.getTest(0).getExecutionParams();
        for (int i = 0; i < params.length; ++i) {
            ParameterWithValueDeclaration param = params[i];
            boolean hasPK = this.isHasPK(param);
            List<FieldDescriptor> fields = nonEmptyFields.get(i);
            if (ClassUtils.isAssignable((Class)param.getType().getInstanceClass(), Map.class)) {
                Map map = (Map)param.getValue();
                for (Object key : map.keySet()) {
                    tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), param.getName() + "[\"" + key + "\"]:" + map.get(key).getClass().getSimpleName(), this.styles.header));
                }
                continue;
            }
            if (fields == null || fields.isEmpty()) {
                tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), param.getName(), this.styles.header));
                continue;
            }
            String prefix = param.getName() + ".";
            if (hasPK) {
                tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), prefix + "_PK_", this.styles.header));
            }
            colNum = this.addHeaderTasks(tasks, new Cursor(rowNum, colNum), fields, prefix, param);
        }
        return this.performWrite((Sheet)sheet, start, tasks, this.getLastColumn(test, nonEmptyFields));
    }

    private boolean isHasPK(ParameterWithValueDeclaration param) {
        return param.getKeyField() instanceof PrimaryKeyField;
    }

    private int addHeaderTasks(TreeSet<BaseParameterExport.WriteTask> tasks, Cursor cursor, List<FieldDescriptor> fields, String prefix, ParameterWithValueDeclaration param) {
        int colNum = cursor.getColNum();
        int rowNum = cursor.getRowNum();
        for (FieldDescriptor fieldDescriptor : fields) {
            String fieldName = fieldDescriptor.getField().getName();
            int width = fieldDescriptor.getLeafNodeCount();
            if (fieldDescriptor.getChildren() == null) {
                if (ClassUtils.isAssignable((Class)fieldDescriptor.getField().getType().getInstanceClass(), Map.class)) {
                    Map map = (Map)ExportUtils.fieldValue(param.getValue(), fieldDescriptor.getField());
                    for (Object key : map.keySet()) {
                        tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), prefix + fieldName + "[\"" + key + "\"]:" + map.get(key).getClass().getSimpleName(), this.styles.header));
                    }
                    continue;
                }
                tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum), prefix + fieldName, this.styles.header));
            } else {
                this.addHeaderTasks(tasks, new Cursor(rowNum, colNum), fieldDescriptor.getChildren(), prefix + fieldName + ".", param);
            }
            colNum += width;
        }
        return colNum;
    }

    private int writeValuesForFields(Sheet sheet, Cursor start, TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields) {
        TestDescription[] descriptions;
        int rowNum = start.getRowNum();
        int colNum = 1;
        int lastColNum = this.getLastColumn(test, nonEmptyFields);
        for (TestDescription description : descriptions = test.getTestSuite().getTests()) {
            TreeSet<BaseParameterExport.WriteTask> tasks = new TreeSet<BaseParameterExport.WriteTask>();
            int maxHeight = this.getMaxHeight(description, nonEmptyFields);
            tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), description.getId(), this.styles.parameterValue, maxHeight));
            ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
            for (int p = 0; p < executionParams.length; ++p) {
                ParameterWithValueDeclaration parameter = executionParams[p];
                Object[] value = parameter.getValue();
                if (value instanceof Collection) {
                    value = ((Collection)value).toArray();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    for (Object val : map.values()) {
                        tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), val.toString(), this.styles.header));
                    }
                    continue;
                }
                List<FieldDescriptor> fields = nonEmptyFields.get(p);
                if (fields == null) {
                    tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), value, this.styles.parameterValue, maxHeight));
                    continue;
                }
                if (this.isHasPK(parameter)) {
                    IOpenField keyField = parameter.getKeyField();
                    Object id = ExportUtils.fieldValue(parameter.getValue(), keyField);
                    if (id != null && id.getClass().isArray()) {
                        int pkRow = rowNum;
                        int count = Array.getLength(id);
                        for (int i = 0; i < count; ++i) {
                            int height = this.getRowHeight(Array.get(value, i), fields);
                            tasks.add(new BaseParameterExport.WriteTask(new Cursor(pkRow, colNum), Array.get(id, i), this.styles.parameterValue, height));
                            pkRow += height;
                        }
                    } else {
                        tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum), id, this.styles.parameterValue, maxHeight));
                    }
                    ++colNum;
                }
                this.addValueTasks(tasks, new Cursor(rowNum, colNum), fields, value, maxHeight);
                colNum += this.getFieldWidth(fields);
            }
            Cursor cursor = this.performWrite(sheet, new Cursor(rowNum, 1), tasks, lastColNum);
            rowNum = cursor.getRowNum() + 1;
            colNum = 1;
        }
        return rowNum;
    }

    private void addValueTasks(TreeSet<BaseParameterExport.WriteTask> tasks, Cursor cursor, List<FieldDescriptor> fields, Object value, int rowHeight) {
        int colNum = cursor.getColNum();
        int rowNum = cursor.getRowNum();
        if (value != null && value.getClass().isArray()) {
            int count = Array.getLength(value);
            int heightLeft = rowHeight;
            for (int i = 0; i < count; ++i) {
                Object elem = Array.get(value, i);
                int height = this.getRowHeight(elem, fields);
                if (i < count - 1) {
                    this.addValueTasks(tasks, new Cursor(rowNum, colNum), fields, elem, height);
                    heightLeft -= height;
                } else {
                    this.addValueTasks(tasks, new Cursor(rowNum, colNum), fields, elem, heightLeft);
                }
                rowNum += height;
            }
        } else {
            for (FieldDescriptor fieldDescriptor : fields) {
                Object[] fieldValue = ExportUtils.fieldValue(value, fieldDescriptor.getField());
                List<FieldDescriptor> children = fieldDescriptor.getChildren();
                if (fieldValue instanceof Map) {
                    Map map = (Map)fieldValue;
                    for (Object val : map.values()) {
                        tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum++), val.toString(), this.styles.header));
                    }
                    continue;
                }
                if (fieldValue instanceof Collection) {
                    fieldValue = ((Collection)fieldValue).toArray();
                }
                if (children == null) {
                    tasks.add(new BaseParameterExport.WriteTask(new Cursor(rowNum, colNum), fieldValue, this.styles.parameterValue, rowHeight));
                } else {
                    this.addValueTasks(tasks, new Cursor(rowNum, colNum), children, fieldValue, rowHeight);
                }
                colNum += fieldDescriptor.getLeafNodeCount();
            }
        }
    }

    private int getRowHeight(Object value, List<FieldDescriptor> fields) {
        if (value == null || fields == null) {
            return 1;
        }
        if (value instanceof Collection) {
            value = ((Collection)value).toArray();
        }
        if (value.getClass().isArray()) {
            int count = Array.getLength(value);
            int height = 0;
            for (int i = 0; i < count; ++i) {
                height += this.getRowHeight(Array.get(value, i), fields);
            }
            return height == 0 ? 1 : height;
        }
        int maxSize = 1;
        for (FieldDescriptor fieldDescriptor : fields) {
            int size = fieldDescriptor.getMaxArraySize(value);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        return maxSize;
    }

    private int getFieldWidth(List<FieldDescriptor> fields) {
        int colNum = 0;
        for (FieldDescriptor fieldDescriptor : fields) {
            colNum += fieldDescriptor.getLeafNodeCount();
        }
        return colNum == 0 ? 1 : colNum;
    }

    private int getMaxHeight(TestDescription description, List<List<FieldDescriptor>> nonEmptyFields) {
        int maxHeight = 1;
        ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
        for (int i = 0; i < executionParams.length; ++i) {
            ParameterWithValueDeclaration param = executionParams[i];
            List<FieldDescriptor> fields = nonEmptyFields.get(i);
            int rowHeight = this.getRowHeight(param.getValue(), fields);
            if (rowHeight <= maxHeight) continue;
            maxHeight = rowHeight;
        }
        return maxHeight;
    }

    private int getLastColumn(TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields) {
        int lastColumn = 1;
        TestSuite testSuite = test.getTestSuite();
        ParameterWithValueDeclaration[] params = testSuite.getTest(0).getExecutionParams();
        for (int i = 0; i < params.length; ++i) {
            List<FieldDescriptor> fields;
            ParameterWithValueDeclaration param = params[i];
            if (this.isHasPK(param)) {
                ++lastColumn;
            }
            if ((fields = nonEmptyFields.get(i)) == null) {
                ++lastColumn;
                continue;
            }
            for (FieldDescriptor field : fields) {
                lastColumn += field.getLeafNodeCount();
            }
        }
        return lastColumn;
    }
}

