/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.addRole;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.addRole.RbacAddRoleRequest;
import org.openldap.accelerator.api.addRole.RbacAddRoleRequestImpl;
import org.openldap.accelerator.impl.addRole.RbacAddRoleRequestContainer;
import org.openldap.accelerator.impl.addRole.RbacAddRoleRequestDecorator;
import org.openldap.accelerator.impl.addRole.RbacAddRoleRequestStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacAddRoleRequestGrammar
extends AbstractGrammar<RbacAddRoleRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacAddRoleRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacAddRoleRequestContainer> instance = new RbacAddRoleRequestGrammar();

    private RbacAddRoleRequestGrammar() {
        this.setName(RbacAddRoleRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacAddRoleRequestStatesEnum.LAST_RBAC_ADD_ROLE_REQ_STATE.ordinal()][256];
        this.transitions[RbacAddRoleRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacAddRoleRequestStatesEnum.START_STATE, (Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacAddRoleRequestContainer>("Init RbacAddRoleRequest"){

            public void action(RbacAddRoleRequestContainer rbacAddRoleContainer) {
                RbacAddRoleRequestDecorator rbacAddRoleRequestDecorator = new RbacAddRoleRequestDecorator(LdapApiServiceFactory.getSingleton(), (RbacAddRoleRequest)new RbacAddRoleRequestImpl());
                rbacAddRoleContainer.setRbacAddRoleRequest(rbacAddRoleRequestDecorator);
            }
        });
        this.transitions[RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_SEQUENCE_STATE, (Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_USER_IDENTITY_STATE, 128, (Action)new GrammarAction<RbacAddRoleRequestContainer>("Stores userIdentity"){

            public void action(RbacAddRoleRequestContainer rbacAddRoleContainer) throws DecoderException {
                BerValue value = rbacAddRoleContainer.getCurrentTLV().getValue();
                String userIdentity = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("userIdentity = {}", (Object)userIdentity);
                }
                rbacAddRoleContainer.getRbacAddRoleRequest().setUserIdentity(userIdentity);
            }
        });
        this.transitions[RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_USER_IDENTITY_STATE.ordinal()][129] = new GrammarTransition((Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_USER_IDENTITY_STATE, (Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_SESSION_ID_STATE, 129, (Action)new GrammarAction<RbacAddRoleRequestContainer>("Stores sessionId"){

            public void action(RbacAddRoleRequestContainer rbacAddRoleContainer) throws DecoderException {
                BerValue value = rbacAddRoleContainer.getCurrentTLV().getValue();
                String sessionId = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("sessionID = " + sessionId);
                }
                rbacAddRoleContainer.getRbacAddRoleRequest().setSessionId(sessionId);
            }
        });
        this.transitions[RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_SESSION_ID_STATE.ordinal()][130] = new GrammarTransition((Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_SESSION_ID_STATE, (Enum)RbacAddRoleRequestStatesEnum.RBAC_ADD_ROLE_REQ_ROLE_STATE, 130, (Action)new GrammarAction<RbacAddRoleRequestContainer>("Stores role"){

            public void action(RbacAddRoleRequestContainer rbacAddRoleContainer) throws DecoderException {
                BerValue value = rbacAddRoleContainer.getCurrentTLV().getValue();
                String role = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("role = " + role);
                }
                rbacAddRoleContainer.getRbacAddRoleRequest().setRole(role);
                rbacAddRoleContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacAddRoleRequestContainer> getInstance() {
        return instance;
    }
}

