/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.checkAccess;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessRequest;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCheckAccessRequestDecorator
extends ExtendedRequestDecorator<RbacCheckAccessRequest>
implements RbacCheckAccessRequest {
    private static final Logger LOG = LoggerFactory.getLogger(RbacCheckAccessRequestDecorator.class);
    private RbacCheckAccessRequest rbacCheckAccessRequest;
    private int requestLength = 0;
    private byte[] sessionIdBytes;
    private byte[] operationBytes;
    private byte[] objectBytes;
    private byte[] objectIdBytes;

    public RbacCheckAccessRequestDecorator(LdapApiService codec, RbacCheckAccessRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.rbacCheckAccessRequest = decoratedMessage;
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        RbacCheckAccessRequestDecoder decoder = new RbacCheckAccessRequestDecoder();
        try {
            this.rbacCheckAccessRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setSessionId(String sessionID) {
        this.rbacCheckAccessRequest.setSessionId(sessionID);
    }

    public String getSessionId() {
        return this.rbacCheckAccessRequest.getSessionId();
    }

    public String getOperation() {
        return this.rbacCheckAccessRequest.getOperation();
    }

    public void setOperation(String operation) {
        this.rbacCheckAccessRequest.setOperation(operation);
    }

    public String getObject() {
        return this.rbacCheckAccessRequest.getObject();
    }

    public void setObject(String object) {
        this.rbacCheckAccessRequest.setObject(object);
    }

    public String getObjectId() {
        return this.rbacCheckAccessRequest.getObjectId();
    }

    public void setObjectId(String objectId) {
        this.rbacCheckAccessRequest.setObject(objectId);
    }

    int computeLengthInternal() {
        int len;
        this.requestLength = 0;
        if (this.rbacCheckAccessRequest.getSessionId() != null) {
            this.sessionIdBytes = Strings.getBytesUtf8((String)this.rbacCheckAccessRequest.getSessionId());
            len = this.sessionIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacCheckAccessRequest.getOperation() != null) {
            this.operationBytes = Strings.getBytesUtf8((String)this.rbacCheckAccessRequest.getOperation());
            len = this.operationBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacCheckAccessRequest.getObject() != null) {
            this.objectBytes = Strings.getBytesUtf8((String)this.rbacCheckAccessRequest.getObject());
            len = this.objectBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacCheckAccessRequest.getObjectId() != null) {
            this.objectIdBytes = Strings.getBytesUtf8((String)this.rbacCheckAccessRequest.getObjectId());
            len = this.objectIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        if (this.rbacCheckAccessRequest.getSessionId() != null) {
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)this.sessionIdBytes.length));
            bb.put(this.sessionIdBytes);
        }
        if (this.rbacCheckAccessRequest.getOperation() != null) {
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)this.operationBytes.length));
            bb.put(this.operationBytes);
        }
        if (this.rbacCheckAccessRequest.getObject() != null) {
            bb.put((byte)-126);
            bb.put(TLV.getBytes((int)this.objectBytes.length));
            bb.put(this.objectBytes);
        }
        if (this.rbacCheckAccessRequest.getObjectId() != null) {
            bb.put((byte)-125);
            bb.put(TLV.getBytes((int)this.objectIdBytes.length));
            bb.put(this.objectIdBytes);
        }
        return bb;
    }

    public String toString() {
        return this.rbacCheckAccessRequest.toString();
    }
}

