/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.checkAccess;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessResponse;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessResponseDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCheckAccessResponseDecorator
extends ExtendedResponseDecorator<RbacCheckAccessResponse>
implements RbacCheckAccessResponse {
    private static final Logger LOG = LoggerFactory.getLogger(RbacCheckAccessResponseDecorator.class);
    private RbacCheckAccessResponse rbacCheckAccessResponse;

    public RbacCheckAccessResponseDecorator(LdapApiService codec, RbacCheckAccessResponse decoratedMessage) {
        super(codec, (ExtendedResponse)decoratedMessage);
        this.rbacCheckAccessResponse = decoratedMessage;
    }

    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            try {
                this.responseValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.responseValue;
    }

    public void setResponseValue(byte[] responseValue) {
        RbacCheckAccessResponseDecoder decoder = new RbacCheckAccessResponseDecoder();
        try {
            this.rbacCheckAccessResponse = decoder.decode(responseValue);
            if (responseValue != null) {
                this.responseValue = new byte[responseValue.length];
                System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
            } else {
                this.responseValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isGranted() {
        return this.rbacCheckAccessResponse.isGranted();
    }

    public void setGranted(boolean granted) {
        this.rbacCheckAccessResponse.setGranted(granted);
    }

    int computeLengthInternal() {
        return 3;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        BerValue.encode((ByteBuffer)bb, (boolean)this.isGranted());
        return bb;
    }

    public String toString() {
        return this.rbacCheckAccessResponse.toString();
    }
}

