/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.createSession;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.createSession.RbacCreateSessionRequest;
import org.openldap.accelerator.impl.createSession.RbacCreateSessionRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCreateSessionRequestDecorator
extends ExtendedRequestDecorator<RbacCreateSessionRequest>
implements RbacCreateSessionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(RbacCreateSessionRequestDecorator.class);
    private RbacCreateSessionRequest rbacCreateSessionRequest;
    private int requestLength = 0;
    private byte[] sessionIdBytes;
    private byte[] tenantIdBytes;
    private byte[] userIdentityBytes;
    private byte[] passwordBytes;
    private int rolesLength;
    private byte[][] roleBytes;

    public RbacCreateSessionRequestDecorator(LdapApiService codec, RbacCreateSessionRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.rbacCreateSessionRequest = decoratedMessage;
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        RbacCreateSessionRequestDecoder decoder = new RbacCreateSessionRequestDecoder();
        try {
            this.rbacCreateSessionRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getTenantId() {
        return this.rbacCreateSessionRequest.getTenantId();
    }

    public void setTenantId(String tenantID) {
        this.rbacCreateSessionRequest.setTenantId(tenantID);
    }

    public void setSessionId(String sessionID) {
        this.rbacCreateSessionRequest.setSessionId(sessionID);
    }

    public String getSessionId() {
        return this.rbacCreateSessionRequest.getSessionId();
    }

    public String getUserIdentity() {
        return this.rbacCreateSessionRequest.getUserIdentity();
    }

    public void setUserIdentity(String userIdentity) {
        this.rbacCreateSessionRequest.setUserIdentity(userIdentity);
    }

    public String getPassword() {
        return this.rbacCreateSessionRequest.getPassword();
    }

    public void setPassword(String password) {
        this.rbacCreateSessionRequest.setPassword(password);
    }

    public List<String> getRoles() {
        return this.rbacCreateSessionRequest.getRoles();
    }

    public void setRoles(List<String> roles) {
        this.rbacCreateSessionRequest.setRoles(roles);
    }

    public void addRole(String role) {
        this.rbacCreateSessionRequest.addRole(role);
    }

    int computeLengthInternal() {
        int len;
        this.requestLength = 0;
        if (this.rbacCreateSessionRequest.getSessionId() != null) {
            this.sessionIdBytes = Strings.getBytesUtf8((String)this.rbacCreateSessionRequest.getSessionId());
            len = this.sessionIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        if (this.rbacCreateSessionRequest.getTenantId() != null) {
            this.tenantIdBytes = Strings.getBytesUtf8((String)this.rbacCreateSessionRequest.getTenantId());
            len = this.tenantIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        if (this.rbacCreateSessionRequest.getUserIdentity() != null) {
            this.userIdentityBytes = Strings.getBytesUtf8((String)this.rbacCreateSessionRequest.getUserIdentity());
            len = this.userIdentityBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        if (this.rbacCreateSessionRequest.getPassword() != null) {
            this.passwordBytes = Strings.getBytesUtf8((String)this.rbacCreateSessionRequest.getPassword());
            len = this.passwordBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        if (this.rbacCreateSessionRequest.getRoles() != null) {
            this.rolesLength = 0;
            int pos = 0;
            this.roleBytes = new byte[this.rbacCreateSessionRequest.getRoles().size()][];
            for (String role : this.rbacCreateSessionRequest.getRoles()) {
                this.roleBytes[pos] = Strings.getBytesUtf8((String)role);
                int len2 = this.roleBytes[pos].length;
                this.rolesLength += 1 + TLV.getNbBytes((int)len2) + len2;
                ++pos;
            }
            this.requestLength += 1 + TLV.getNbBytes((int)this.rolesLength) + this.rolesLength;
        }
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        if (this.rbacCreateSessionRequest.getSessionId() != null) {
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)this.sessionIdBytes.length));
            bb.put(this.sessionIdBytes);
        }
        if (this.rbacCreateSessionRequest.getTenantId() != null) {
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)this.tenantIdBytes.length));
            bb.put(this.tenantIdBytes);
        }
        if (this.rbacCreateSessionRequest.getUserIdentity() != null) {
            bb.put((byte)-126);
            bb.put(TLV.getBytes((int)this.userIdentityBytes.length));
            bb.put(this.userIdentityBytes);
        }
        if (this.rbacCreateSessionRequest.getPassword() != null) {
            bb.put((byte)-125);
            bb.put(TLV.getBytes((int)this.passwordBytes.length));
            bb.put(this.passwordBytes);
        }
        if (this.rbacCreateSessionRequest.getRoles() != null) {
            bb.put((byte)-92);
            bb.put(TLV.getBytes((int)this.rolesLength));
            if (this.roleBytes.length != 0) {
                for (byte[] roleByte : this.roleBytes) {
                    BerValue.encode((ByteBuffer)bb, (byte[])roleByte);
                }
            }
        }
        return bb;
    }

    public String toString() {
        return this.rbacCreateSessionRequest.toString();
    }
}

