/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.dropRole;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.dropRole.RbacDropRoleRequest;
import org.openldap.accelerator.api.dropRole.RbacDropRoleRequestImpl;
import org.openldap.accelerator.impl.dropRole.RbacDropRoleRequestContainer;
import org.openldap.accelerator.impl.dropRole.RbacDropRoleRequestDecorator;
import org.openldap.accelerator.impl.dropRole.RbacDropRoleRequestStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacDropRoleRequestGrammar
extends AbstractGrammar<RbacDropRoleRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacDropRoleRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacDropRoleRequestContainer> instance = new RbacDropRoleRequestGrammar();

    private RbacDropRoleRequestGrammar() {
        this.setName(RbacDropRoleRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacDropRoleRequestStatesEnum.LAST_RBAC_DROP_ROLE_REQ_STATE.ordinal()][256];
        this.transitions[RbacDropRoleRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacDropRoleRequestStatesEnum.START_STATE, (Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacDropRoleRequestContainer>("Init RbacDropRoleRequest"){

            public void action(RbacDropRoleRequestContainer rbacDropRoleContainer) {
                RbacDropRoleRequestDecorator rbacDropRoleRequestDecorator = new RbacDropRoleRequestDecorator(LdapApiServiceFactory.getSingleton(), (RbacDropRoleRequest)new RbacDropRoleRequestImpl());
                rbacDropRoleContainer.setRbacDropRoleRequest(rbacDropRoleRequestDecorator);
            }
        });
        this.transitions[RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_SEQUENCE_STATE, (Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_USER_IDENTITY_STATE, 128, (Action)new GrammarAction<RbacDropRoleRequestContainer>("Stores userIdentity"){

            public void action(RbacDropRoleRequestContainer rbacDropRoleContainer) throws DecoderException {
                BerValue value = rbacDropRoleContainer.getCurrentTLV().getValue();
                String userIdentity = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("userIdentity = {}", (Object)userIdentity);
                }
                rbacDropRoleContainer.getRbacDropRoleRequest().setUserIdentity(userIdentity);
            }
        });
        this.transitions[RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_USER_IDENTITY_STATE.ordinal()][129] = new GrammarTransition((Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_USER_IDENTITY_STATE, (Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_SESSION_ID_STATE, 129, (Action)new GrammarAction<RbacDropRoleRequestContainer>("Stores sessionId"){

            public void action(RbacDropRoleRequestContainer rbacDropRoleContainer) throws DecoderException {
                BerValue value = rbacDropRoleContainer.getCurrentTLV().getValue();
                String sessionId = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("sessionID = " + sessionId);
                }
                rbacDropRoleContainer.getRbacDropRoleRequest().setSessionId(sessionId);
            }
        });
        this.transitions[RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_SESSION_ID_STATE.ordinal()][130] = new GrammarTransition((Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_SESSION_ID_STATE, (Enum)RbacDropRoleRequestStatesEnum.RBAC_DROP_ROLE_REQ_ROLE_STATE, 130, (Action)new GrammarAction<RbacDropRoleRequestContainer>("Stores role"){

            public void action(RbacDropRoleRequestContainer rbacDropRoleContainer) throws DecoderException {
                BerValue value = rbacDropRoleContainer.getCurrentTLV().getValue();
                String role = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("role = " + role);
                }
                rbacDropRoleContainer.getRbacDropRoleRequest().setRole(role);
                rbacDropRoleContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacDropRoleRequestContainer> getInstance() {
        return instance;
    }
}

