/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.sessionRoles;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesRequest;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacSessionRolesRequestDecorator
extends ExtendedRequestDecorator<RbacSessionRolesRequest>
implements RbacSessionRolesRequest {
    private static final Logger LOG = LoggerFactory.getLogger(RbacSessionRolesRequestDecorator.class);
    private RbacSessionRolesRequest rbacSessionRolesRequest;
    private int requestLength = 0;
    private byte[] sessionIdBytes;
    private byte[] userIdentityBytes;

    public RbacSessionRolesRequestDecorator(LdapApiService codec, RbacSessionRolesRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.rbacSessionRolesRequest = decoratedMessage;
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        RbacSessionRolesRequestDecoder decoder = new RbacSessionRolesRequestDecoder();
        try {
            this.rbacSessionRolesRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setSessionId(String sessionID) {
        this.rbacSessionRolesRequest.setSessionId(sessionID);
    }

    public String getSessionId() {
        return this.rbacSessionRolesRequest.getSessionId();
    }

    public String getUserIdentity() {
        return this.rbacSessionRolesRequest.getUserIdentity();
    }

    public void setUserIdentity(String userIdentity) {
        this.rbacSessionRolesRequest.setUserIdentity(userIdentity);
    }

    int computeLengthInternal() {
        int len;
        this.requestLength = 0;
        if (this.rbacSessionRolesRequest.getUserIdentity() != null) {
            this.userIdentityBytes = Strings.getBytesUtf8((String)this.rbacSessionRolesRequest.getUserIdentity());
            len = this.userIdentityBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacSessionRolesRequest.getSessionId() != null) {
            this.sessionIdBytes = Strings.getBytesUtf8((String)this.rbacSessionRolesRequest.getSessionId());
            len = this.sessionIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        if (this.rbacSessionRolesRequest.getUserIdentity() != null) {
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)this.userIdentityBytes.length));
            bb.put(this.userIdentityBytes);
        }
        if (this.rbacSessionRolesRequest.getSessionId() != null) {
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)this.sessionIdBytes.length));
            bb.put(this.sessionIdBytes);
        }
        return bb;
    }

    public String toString() {
        return this.rbacSessionRolesRequest.toString();
    }
}

