/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.sessionRoles;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesResponse;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesResponseDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacSessionRolesResponseDecorator
extends ExtendedResponseDecorator<RbacSessionRolesResponse>
implements RbacSessionRolesResponse {
    private static final Logger LOG = LoggerFactory.getLogger(RbacSessionRolesResponseDecorator.class);
    private RbacSessionRolesResponse rbacSessionRolesResponse;
    private int responseLength = 0;
    private int rolesLength;
    private byte[][] roleBytes;

    public RbacSessionRolesResponseDecorator(LdapApiService codec, RbacSessionRolesResponse decoratedMessage) {
        super(codec, (ExtendedResponse)decoratedMessage);
        this.rbacSessionRolesResponse = decoratedMessage;
    }

    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            try {
                ByteBuffer bb = this.encodeInternal();
                if (bb != null) {
                    this.responseValue = this.encodeInternal().array();
                }
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.responseValue;
    }

    public void setResponseValue(byte[] requestValue) {
        RbacSessionRolesResponseDecoder decoder = new RbacSessionRolesResponseDecoder();
        try {
            this.rbacSessionRolesResponse = decoder.decode(requestValue);
            if (requestValue != null) {
                this.responseValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.responseValue, 0, requestValue.length);
            } else {
                this.responseValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getRoles() {
        return this.rbacSessionRolesResponse.getRoles();
    }

    public void setRoles(List<String> roles) {
        this.rbacSessionRolesResponse.setRoles(roles);
    }

    public void addRole(String role) {
        this.rbacSessionRolesResponse.addRole(role);
    }

    int computeLengthInternal() {
        this.responseLength = 0;
        if (this.rbacSessionRolesResponse.getRoles() != null) {
            this.rolesLength = 0;
            int pos = 0;
            this.roleBytes = new byte[this.rbacSessionRolesResponse.getRoles().size()][];
            for (String role : this.rbacSessionRolesResponse.getRoles()) {
                this.roleBytes[pos] = Strings.getBytesUtf8((String)role);
                int len = this.roleBytes[pos].length;
                this.rolesLength += 1 + TLV.getNbBytes((int)len) + len;
                ++pos;
            }
            this.responseLength += 1 + TLV.getNbBytes((int)this.rolesLength) + this.rolesLength;
        }
        return 1 + TLV.getNbBytes((int)this.responseLength) + this.responseLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        if (this.rbacSessionRolesResponse.getRoles() != null) {
            ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
            bb.put(UniversalTag.SEQUENCE.getValue());
            bb.put(TLV.getBytes((int)this.responseLength));
            if (this.rbacSessionRolesResponse.getRoles() != null) {
                bb.put((byte)4);
                bb.put(TLV.getBytes((int)this.rolesLength));
                if (this.roleBytes.length != 0) {
                    for (byte[] roleByte : this.roleBytes) {
                        BerValue.encode((ByteBuffer)bb, (byte[])roleByte);
                    }
                }
            }
            return bb;
        }
        return null;
    }

    public String toString() {
        return this.rbacSessionRolesResponse.toString();
    }
}

