/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.sessionRoles;

import java.util.ArrayList;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesResponse;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesResponseImpl;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesResponseContainer;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesResponseDecorator;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesResponseStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacSessionRolesResponseGrammar
extends AbstractGrammar<RbacSessionRolesResponseContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacSessionRolesResponseGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacSessionRolesResponseContainer> instance = new RbacSessionRolesResponseGrammar();

    private RbacSessionRolesResponseGrammar() {
        this.setName(RbacSessionRolesResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacSessionRolesResponseStatesEnum.LAST_RBAC_SESSION_ROLES_RESP_STATE.ordinal()][256];
        this.transitions[RbacSessionRolesResponseStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacSessionRolesResponseStatesEnum.START_STATE, (Enum)RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacSessionRolesResponseContainer>("Init RbacSessionRolesResponse"){

            public void action(RbacSessionRolesResponseContainer rbacSessionRolesContainer) {
                RbacSessionRolesResponseDecorator rbacSessionRolesResponseDecorator = new RbacSessionRolesResponseDecorator(LdapApiServiceFactory.getSingleton(), (RbacSessionRolesResponse)new RbacSessionRolesResponseImpl());
                rbacSessionRolesContainer.setRbacSessionRolesResponse(rbacSessionRolesResponseDecorator);
            }
        });
        this.transitions[RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_SEQUENCE_STATE, (Enum)RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_ROLES_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<RbacSessionRolesResponseContainer>("Add a role to the list"){

            public void action(RbacSessionRolesResponseContainer rbacSessionRolesContainer) throws DecoderException {
                BerValue value = rbacSessionRolesContainer.getCurrentTLV().getValue();
                String role = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("A role  = {}", (Object)role);
                }
                rbacSessionRolesContainer.getRbacSessionRolesResponse().setRoles(new ArrayList<String>());
                rbacSessionRolesContainer.getRbacSessionRolesResponse().getRoles().add(role);
                rbacSessionRolesContainer.setGrammarEndAllowed(true);
            }
        });
        this.transitions[RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_ROLES_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_ROLES_STATE, (Enum)RbacSessionRolesResponseStatesEnum.RBAC_SESSION_ROLES_RESP_ROLES_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<RbacSessionRolesResponseContainer>("Add a role to the list"){

            public void action(RbacSessionRolesResponseContainer rbacSessionRolesContainer) throws DecoderException {
                BerValue value = rbacSessionRolesContainer.getCurrentTLV().getValue();
                String role = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("B role = {}", (Object)role);
                }
                rbacSessionRolesContainer.getRbacSessionRolesResponse().getRoles().add(role);
                rbacSessionRolesContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacSessionRolesResponseContainer> getInstance() {
        return instance;
    }
}

