/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.common.enumeration.CodedEnum;

public enum JPEG2000SegmentMarker implements CodedEnum
{
    RESERVED_DELIMITER_MARKER_MIN(65328, "Reserved delimiter marker minimum"),
    RESERVED_DELIMITER_MARKER_MAX(65343, "Reserved delimiter marker maximum"),
    SOC(65359, "Start of codestream"),
    SOC_WRONG_ENDIANNESS(20479, "Start of codestream (Wrong endianness)"),
    SOT(65424, "Start of tile"),
    SOD(65427, "Start of data"),
    EOC(65497, "End of codestream"),
    SIZ(65361, "Size"),
    COD(65362, "Coding style default"),
    COC(65363, "Coding style component"),
    RGN(65374, "Region of interest"),
    QCD(65372, "Quantization default"),
    QCC(65373, "Quantization component"),
    POC(65375, "Progression order change"),
    TLM(65365, "Tile lengths"),
    PLM(65367, "Packet length main"),
    PLT(65368, "Packet length tile"),
    PPM(65376, "Packed packet main"),
    PPT(65377, "Packed packet tile"),
    SOP(65425, "Start of packet"),
    EPH(65426, "End of packet header"),
    CRG(65379, "Component registration"),
    COM(65380, "Comment");

    private int code;
    private String name;
    private static final Map<Integer, JPEG2000SegmentMarker> lookup;

    public static JPEG2000SegmentMarker get(int code) {
        return lookup.get(code);
    }

    private JPEG2000SegmentMarker(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        lookup = new HashMap<Integer, JPEG2000SegmentMarker>();
        for (JPEG2000SegmentMarker v : EnumSet.allOf(JPEG2000SegmentMarker.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

