/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.Reference;
import ome.xml.model.Settings;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Medium;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectiveSettings
extends Settings {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveSettings.class);
    private String id;
    private Double correctionCollar;
    private Medium medium;
    private Double refractiveIndex;
    private Objective objective;

    public ObjectiveSettings() {
    }

    public ObjectiveSettings(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ObjectiveSettings(ObjectiveSettings orig) {
        super(orig);
        this.id = orig.id;
        this.correctionCollar = orig.correctionCollar;
        this.medium = orig.medium;
        this.refractiveIndex = orig.refractiveIndex;
        this.objective = orig.objective;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("ObjectiveSettings missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("CorrectionCollar")) {
            this.setCorrectionCollar(Double.valueOf(element.getAttribute("CorrectionCollar")));
        }
        if (element.hasAttribute("Medium")) {
            this.setMedium(Medium.fromString(element.getAttribute("Medium")));
        }
        if (element.hasAttribute("RefractiveIndex")) {
            this.setRefractiveIndex(Double.valueOf(element.getAttribute("RefractiveIndex")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public Double getCorrectionCollar() {
        return this.correctionCollar;
    }

    public void setCorrectionCollar(Double correctionCollar) {
        this.correctionCollar = correctionCollar;
    }

    public Medium getMedium() {
        return this.medium;
    }

    public void setMedium(Medium medium) {
        this.medium = medium;
    }

    public Double getRefractiveIndex() {
        return this.refractiveIndex;
    }

    public void setRefractiveIndex(Double refractiveIndex) {
        this.refractiveIndex = refractiveIndex;
    }

    public Objective getObjective() {
        return this.objective;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element ObjectiveSettings_element) {
        if (ObjectiveSettings_element == null) {
            ObjectiveSettings_element = document.createElementNS(NAMESPACE, "ObjectiveSettings");
        }
        super.asXMLElement(document, ObjectiveSettings_element);
        if (this.id != null) {
            ObjectiveSettings_element.setAttribute("ID", this.id.toString());
        }
        if (this.correctionCollar != null) {
            ObjectiveSettings_element.setAttribute("CorrectionCollar", this.correctionCollar.toString());
        }
        if (this.medium != null) {
            ObjectiveSettings_element.setAttribute("Medium", this.medium.toString());
        }
        if (this.refractiveIndex != null) {
            ObjectiveSettings_element.setAttribute("RefractiveIndex", this.refractiveIndex.toString());
        }
        if (this.objective != null) {
            // empty if block
        }
        return ObjectiveSettings_element;
    }
}

