/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plate;
import ome.xml.model.Reagent;
import ome.xml.model.ReagentRef;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.WellSample;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Well
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Well.class);
    private String id;
    private NonNegativeInteger column;
    private NonNegativeInteger row;
    private String externalDescription;
    private String externalIdentifier;
    private String type;
    private Color color;
    private List<WellSample> wellSamples = new ArrayList<WellSample>();
    private Reagent reagent;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Plate plate;

    public Well() {
    }

    public Well(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Well(Well orig) {
        this.id = orig.id;
        this.column = orig.column;
        this.row = orig.row;
        this.externalDescription = orig.externalDescription;
        this.externalIdentifier = orig.externalIdentifier;
        this.type = orig.type;
        this.color = orig.color;
        this.wellSamples = orig.wellSamples;
        this.reagent = orig.reagent;
        this.annotationLinks = orig.annotationLinks;
        this.plate = orig.plate;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Well missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Column")) {
            this.setColumn(NonNegativeInteger.valueOf(element.getAttribute("Column")));
        }
        if (element.hasAttribute("Row")) {
            this.setRow(NonNegativeInteger.valueOf(element.getAttribute("Row")));
        }
        if (element.hasAttribute("ExternalDescription")) {
            this.setExternalDescription(String.valueOf(element.getAttribute("ExternalDescription")));
        }
        if (element.hasAttribute("ExternalIdentifier")) {
            this.setExternalIdentifier(String.valueOf(element.getAttribute("ExternalIdentifier")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(String.valueOf(element.getAttribute("Type")));
        }
        if (element.hasAttribute("Color")) {
            this.setColor(Color.valueOf(element.getAttribute("Color")));
        }
        List<Element> WellSample_nodeList = Well.getChildrenByTagName(element, "WellSample");
        for (Element element2 : WellSample_nodeList) {
            this.addWellSample(new WellSample(element2, model));
        }
        List<Element> ReagentRef_nodeList = Well.getChildrenByTagName(element, "ReagentRef");
        for (Element ReagentRef_element : ReagentRef_nodeList) {
            ReagentRef reagent_reference = new ReagentRef();
            reagent_reference.setID(ReagentRef_element.getAttribute("ID"));
            model.addReference(this, reagent_reference);
        }
        List<Element> list = Well.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ReagentRef) {
            Reagent o_casted = (Reagent)o;
            o_casted.linkWell(this);
            this.reagent = o_casted;
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkWell(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public NonNegativeInteger getColumn() {
        return this.column;
    }

    public void setColumn(NonNegativeInteger column) {
        this.column = column;
    }

    public NonNegativeInteger getRow() {
        return this.row;
    }

    public void setRow(NonNegativeInteger row) {
        this.row = row;
    }

    public String getExternalDescription() {
        return this.externalDescription;
    }

    public void setExternalDescription(String externalDescription) {
        this.externalDescription = externalDescription;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int sizeOfWellSampleList() {
        return this.wellSamples.size();
    }

    public List<WellSample> copyWellSampleList() {
        return new ArrayList<WellSample>(this.wellSamples);
    }

    public WellSample getWellSample(int index) {
        return this.wellSamples.get(index);
    }

    public WellSample setWellSample(int index, WellSample wellSample) {
        wellSample.setWell(this);
        return this.wellSamples.set(index, wellSample);
    }

    public void addWellSample(WellSample wellSample) {
        wellSample.setWell(this);
        this.wellSamples.add(wellSample);
    }

    public void removeWellSample(WellSample wellSample) {
        this.wellSamples.remove(wellSample);
    }

    public Reagent getLinkedReagent() {
        return this.reagent;
    }

    public void linkReagent(Reagent o) {
        this.reagent = o;
    }

    public void unlinkReagent(Reagent o) {
        if (this.reagent == o) {
            this.reagent = null;
        }
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkWell(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkWell(this);
        return this.annotationLinks.remove(o);
    }

    public Plate getPlate() {
        return this.plate;
    }

    public void setPlate(Plate plate_BackReference) {
        this.plate = plate_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Well_element) {
        if (Well_element == null) {
            Well_element = document.createElementNS(NAMESPACE, "Well");
        }
        super.asXMLElement(document, Well_element);
        if (this.id != null) {
            Well_element.setAttribute("ID", this.id.toString());
        }
        if (this.column != null) {
            Well_element.setAttribute("Column", this.column.toString());
        }
        if (this.row != null) {
            Well_element.setAttribute("Row", this.row.toString());
        }
        if (this.externalDescription != null) {
            Well_element.setAttribute("ExternalDescription", this.externalDescription.toString());
        }
        if (this.externalIdentifier != null) {
            Well_element.setAttribute("ExternalIdentifier", this.externalIdentifier.toString());
        }
        if (this.type != null) {
            Well_element.setAttribute("Type", this.type.toString());
        }
        if (this.color != null) {
            Well_element.setAttribute("Color", this.color.toString());
        }
        if (this.wellSamples != null) {
            for (WellSample wellSamples_value : this.wellSamples) {
                Element child = document.createElementNS(NAMESPACE, "WellSample");
                wellSamples_value.asXMLElement(document, child);
                Well_element.appendChild(child);
            }
        }
        if (this.reagent != null) {
            ReagentRef o = new ReagentRef();
            o.setID(this.reagent.getID());
            Element child = document.createElementNS(NAMESPACE, "ReagentRef");
            o.asXMLElement(document, child);
            Well_element.appendChild(child);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Well_element.appendChild(child);
            }
        }
        if (this.plate != null) {
            // empty if block
        }
        return Well_element;
    }
}

