/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.LightSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FilamentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Filament
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Filament.class);
    private FilamentType type;

    public Filament() {
    }

    public Filament(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Filament(Filament orig) {
        super(orig);
        this.type = orig.type;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Type")) {
            this.setType(FilamentType.fromString(element.getAttribute("Type")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public FilamentType getType() {
        return this.type;
    }

    public void setType(FilamentType type) {
        this.type = type;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Filament_element) {
        if (Filament_element == null) {
            Filament_element = document.createElementNS(NAMESPACE, "Filament");
        }
        super.asXMLElement(document, Filament_element);
        if (this.type != null) {
            Filament_element.setAttribute("Type", this.type.toString());
        }
        return Filament_element;
    }
}

