/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ome.xml.model.enums.*;
import ome.xml.model.enums.handlers.*;
import ome.xml.model.primitives.*;
import ome.units.quantity.*;
import ome.units.unit.Unit;

public class Plate extends AbstractOMEModelObject
{
  // Base:  -- Name: Plate -- Type: Plate -- modelBaseType: AbstractOMEModelObject -- langBaseType: Object

  // -- Constants --

  public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(Plate.class);

  // -- Instance variables --

  // ID property
  private String id;

  // Name property
  private String name;

  // Status property
  private String status;

  // ExternalIdentifier property
  private String externalIdentifier;

  // ColumnNamingConvention property
  private NamingConvention columnNamingConvention;

  // RowNamingConvention property
  private NamingConvention rowNamingConvention;

  // WellOriginX property
  private Length wellOriginX;

  // WellOriginY property
  private Length wellOriginY;

  // Rows property
  private PositiveInteger rows;

  // Columns property
  private PositiveInteger columns;

  // FieldIndex property
  private NonNegativeInteger fieldIndex;

  // Description property
  private String description;

  // Well property (occurs more than once)
  private List<Well> wells = new ArrayList<>();

  // AnnotationRef reference (occurs more than once)
  private List<Annotation> annotationLinks = new ReferenceList<>();

  // PlateAcquisition property (occurs more than once)
  private List<PlateAcquisition> plateAcquisitions = new ArrayList<>();

  // Screen_BackReference back reference (occurs more than once)
  private List<Screen> screenLinks = new ReferenceList<>();

  // -- Constructors --

  /** Default constructor. */
  public Plate()
  {
  }



  /**
   * Constructs Plate recursively from an XML DOM tree.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public Plate(Element element, OMEModel model)
    throws EnumerationException
  {
    update(element, model);
  }

  /** Copy constructor. */
  public Plate(Plate orig)
  {
    id = orig.id;
    name = orig.name;
    status = orig.status;
    externalIdentifier = orig.externalIdentifier;
    columnNamingConvention = orig.columnNamingConvention;
    rowNamingConvention = orig.rowNamingConvention;
    wellOriginX = orig.wellOriginX;
    wellOriginY = orig.wellOriginY;
    rows = orig.rows;
    columns = orig.columns;
    fieldIndex = orig.fieldIndex;
    description = orig.description;
    wells = orig.wells;
    annotationLinks = orig.annotationLinks;
    plateAcquisitions = orig.plateAcquisitions;
    screenLinks = orig.screenLinks;
  }

  // -- Custom content from Plate specific template --


  // -- OMEModelObject API methods --

  /**
   * Updates Plate recursively from an XML DOM tree. <b>NOTE:</b> No
   * properties are removed, only added or updated.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public void update(Element element, OMEModel model)
    throws EnumerationException
  {
    super.update(element, model);
    if (!element.hasAttribute("ID") && getID() == null)
    {
      // TODO: Should be its own exception
      throw new RuntimeException(
        "Plate missing required ID property.");
    }
    if (element.hasAttribute("ID"))
    {
      // ID property
      setID(String.valueOf(
        element.getAttribute("ID")));
      // Adding this model object to the model handler
      model.addModelObject(getID(), this);
    }
    if (element.hasAttribute("Name"))
    {
      // Attribute property Name
      setName(String.valueOf(
        element.getAttribute("Name")));
    }
    if (element.hasAttribute("Status"))
    {
      // Attribute property Status
      setStatus(String.valueOf(
        element.getAttribute("Status")));
    }
    if (element.hasAttribute("ExternalIdentifier"))
    {
      // Attribute property ExternalIdentifier
      setExternalIdentifier(String.valueOf(
        element.getAttribute("ExternalIdentifier")));
    }
    if (element.hasAttribute("ColumnNamingConvention"))
    {
      // Attribute property which is an enumeration ColumnNamingConvention
      setColumnNamingConvention(NamingConvention.fromString(
        element.getAttribute("ColumnNamingConvention")));
    }
    if (element.hasAttribute("RowNamingConvention"))
    {
      // Attribute property which is an enumeration RowNamingConvention
      setRowNamingConvention(NamingConvention.fromString(
        element.getAttribute("RowNamingConvention")));
    }
    if (element.hasAttribute("WellOriginX"))
    {
      // Attribute property WellOriginX with unit companion WellOriginXUnit
      String unitSymbol = element.getAttribute("WellOriginXUnit");
      if ((unitSymbol == null) || (unitSymbol.isEmpty()))
      {
        // Use default value specified in the xsd model
        unitSymbol = getWellOriginXUnitXsdDefault();
      }
      UnitsLength modelUnit =
        UnitsLength.fromString(unitSymbol);
      Double baseValue = Double.valueOf(
        element.getAttribute("WellOriginX"));
      setWellOriginX(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
    }
    if (element.hasAttribute("WellOriginY"))
    {
      // Attribute property WellOriginY with unit companion WellOriginYUnit
      String unitSymbol = element.getAttribute("WellOriginYUnit");
      if ((unitSymbol == null) || (unitSymbol.isEmpty()))
      {
        // Use default value specified in the xsd model
        unitSymbol = getWellOriginYUnitXsdDefault();
      }
      UnitsLength modelUnit =
        UnitsLength.fromString(unitSymbol);
      Double baseValue = Double.valueOf(
        element.getAttribute("WellOriginY"));
      setWellOriginY(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
    }
    if (element.hasAttribute("Rows"))
    {
      // Attribute property Rows
      setRows(PositiveInteger.valueOf(
        element.getAttribute("Rows")));
    }
    if (element.hasAttribute("Columns"))
    {
      // Attribute property Columns
      setColumns(PositiveInteger.valueOf(
        element.getAttribute("Columns")));
    }
    if (element.hasAttribute("FieldIndex"))
    {
      // Attribute property FieldIndex
      setFieldIndex(NonNegativeInteger.valueOf(
        element.getAttribute("FieldIndex")));
    }
    List<Element> Description_nodeList =
      getChildrenByTagName(element, "Description");
    if (Description_nodeList.size() > 1)
    {
      // TODO: Should be its own Exception
      throw new RuntimeException(String.format(
        "Description node list size %d != 1",
        Description_nodeList.size()));
    }
    else if (Description_nodeList.size() != 0)
    {
      // Element property Description which is not complex (has no
      // sub-elements)
      setDescription(
        String.valueOf(Description_nodeList.get(0).getTextContent()));
    }
    // Element property Well which is complex (has
    // sub-elements) and occurs more than once
    List<Element> Well_nodeList =
      getChildrenByTagName(element, "Well");
    for (Element Well_element : Well_nodeList)
    {
      addWell(
        new Well(Well_element, model));
    }
    // Element reference AnnotationRef
    List<Element> AnnotationRef_nodeList =
      getChildrenByTagName(element, "AnnotationRef");
    for (Element AnnotationRef_element : AnnotationRef_nodeList)
    {
      AnnotationRef annotationLinks_reference = new AnnotationRef();
      annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
      model.addReference(this, annotationLinks_reference);
    }
    // Element property PlateAcquisition which is complex (has
    // sub-elements) and occurs more than once
    List<Element> PlateAcquisition_nodeList =
      getChildrenByTagName(element, "PlateAcquisition");
    for (Element PlateAcquisition_element : PlateAcquisition_nodeList)
    {
      addPlateAcquisition(
        new PlateAcquisition(PlateAcquisition_element, model));
    }
  }

  // -- Plate API methods --

  public boolean link(Reference reference, OMEModelObject o)
  {
    if (reference instanceof AnnotationRef)
    {
      Annotation o_casted = (Annotation) o;
      o_casted.linkPlate(this);
      annotationLinks.add(o_casted);
      return true;
    }
    return super.link(reference, o);
  }

  // Property ID
  public String getID()
  {
    return id;
  }

  public void setID(String id)
  {
    this.id = id;
  }

  // Property Name
  public String getName()
  {
    return name;
  }

  public void setName(String name)
  {
    this.name = name;
  }

  // Property Status
  public String getStatus()
  {
    return status;
  }

  public void setStatus(String status)
  {
    this.status = status;
  }

  // Property ExternalIdentifier
  public String getExternalIdentifier()
  {
    return externalIdentifier;
  }

  public void setExternalIdentifier(String externalIdentifier)
  {
    this.externalIdentifier = externalIdentifier;
  }

  // Property ColumnNamingConvention
  public NamingConvention getColumnNamingConvention()
  {
    return columnNamingConvention;
  }

  public void setColumnNamingConvention(NamingConvention columnNamingConvention)
  {
    this.columnNamingConvention = columnNamingConvention;
  }

  // Property RowNamingConvention
  public NamingConvention getRowNamingConvention()
  {
    return rowNamingConvention;
  }

  public void setRowNamingConvention(NamingConvention rowNamingConvention)
  {
    this.rowNamingConvention = rowNamingConvention;
  }

  // Property WellOriginX with unit companion WellOriginXUnit
  public Length getWellOriginX()
  {
    return wellOriginX;
  }

  public void setWellOriginX(Length wellOriginX)
  {
    this.wellOriginX = wellOriginX;
  }

  // Property WellOriginXUnit is a unit companion
  @SuppressWarnings("SameReturnValue")
  public static String getWellOriginXUnitXsdDefault()
  {
    return "reference frame";
  }

  // Property WellOriginY with unit companion WellOriginYUnit
  public Length getWellOriginY()
  {
    return wellOriginY;
  }

  public void setWellOriginY(Length wellOriginY)
  {
    this.wellOriginY = wellOriginY;
  }

  // Property WellOriginYUnit is a unit companion
  @SuppressWarnings("SameReturnValue")
  public static String getWellOriginYUnitXsdDefault()
  {
    return "reference frame";
  }

  // Property Rows
  public PositiveInteger getRows()
  {
    return rows;
  }

  public void setRows(PositiveInteger rows)
  {
    this.rows = rows;
  }

  // Property Columns
  public PositiveInteger getColumns()
  {
    return columns;
  }

  public void setColumns(PositiveInteger columns)
  {
    this.columns = columns;
  }

  // Property FieldIndex
  public NonNegativeInteger getFieldIndex()
  {
    return fieldIndex;
  }

  public void setFieldIndex(NonNegativeInteger fieldIndex)
  {
    this.fieldIndex = fieldIndex;
  }

  // Property Description
  public String getDescription()
  {
    return description;
  }

  public void setDescription(String description)
  {
    this.description = description;
  }

  // Property which occurs more than once
  public int sizeOfWellList()
  {
    return wells.size();
  }

  public List<Well> copyWellList()
  {
    return new ArrayList<>(wells);
  }

  public Well getWell(int index)
  {
    return wells.get(index);
  }

  public Well setWell(int index, Well well)
  {
    well.setPlate(this);
    return wells.set(index, well);
  }

  public void addWell(Well well)
  {
    well.setPlate(this);
    wells.add(well);
  }

  public void removeWell(Well well)
  {
    wells.remove(well);
  }

  // Reference which occurs more than once
  public int sizeOfLinkedAnnotationList()
  {
    return annotationLinks.size();
  }

  public List<Annotation> copyLinkedAnnotationList()
  {
    return new ArrayList<>(annotationLinks);
  }

  public Annotation getLinkedAnnotation(int index)
  {
    return annotationLinks.get(index);
  }

  public Annotation setLinkedAnnotation(int index, Annotation o)
  {
    return annotationLinks.set(index, o);
  }

  @SuppressWarnings("UnusedReturnValue")
  public boolean linkAnnotation(Annotation o)
  {

    o.linkPlate(this);
    return annotationLinks.add(o);
  }

  @SuppressWarnings("UnusedReturnValue")
  public boolean unlinkAnnotation(Annotation o)
  {

    o.unlinkPlate(this);
    return annotationLinks.remove(o);
  }

  // Property which occurs more than once
  public int sizeOfPlateAcquisitionList()
  {
    return plateAcquisitions.size();
  }

  public List<PlateAcquisition> copyPlateAcquisitionList()
  {
    return new ArrayList<>(plateAcquisitions);
  }

  public PlateAcquisition getPlateAcquisition(int index)
  {
    return plateAcquisitions.get(index);
  }

  public PlateAcquisition setPlateAcquisition(int index, PlateAcquisition plateAcquisition)
  {
    plateAcquisition.setPlate(this);
    return plateAcquisitions.set(index, plateAcquisition);
  }

  public void addPlateAcquisition(PlateAcquisition plateAcquisition)
  {
    plateAcquisition.setPlate(this);
    plateAcquisitions.add(plateAcquisition);
  }

  public void removePlateAcquisition(PlateAcquisition plateAcquisition)
  {
    plateAcquisitions.remove(plateAcquisition);
  }

  // Reference which occurs more than once
  public int sizeOfLinkedScreenList()
  {
    return screenLinks.size();
  }

  public List<Screen> copyLinkedScreenList()
  {
    return new ArrayList<>(screenLinks);
  }

  public Screen getLinkedScreen(int index)
  {
    return screenLinks.get(index);
  }

  public Screen setLinkedScreen(int index, Screen o)
  {
    return screenLinks.set(index, o);
  }

  @SuppressWarnings("UnusedReturnValue")
  public boolean linkScreen(Screen o)
  {
    return screenLinks.add(o);
  }

  @SuppressWarnings("UnusedReturnValue")
  public boolean unlinkScreen(Screen o)
  {
    return screenLinks.remove(o);
  }

  public Element asXMLElement(Document document)
  {
    return asXMLElement(document, null);
  }

  public Element asXMLElement(Document document, Element Plate_element)
  {
    // Creating XML block for Plate
    if (Plate_element == null)
    {
      Plate_element =
        document.createElementNS(NAMESPACE, "Plate");
    }

    // Ensure any base annotations add their Elements first
    super.asXMLElement(document, Plate_element);

    if (id != null)
    {
      // Attribute property ID
      Plate_element.setAttribute("ID", id);
    }
    if (name != null)
    {
      // Attribute property Name
      Plate_element.setAttribute("Name", name);
    }
    if (status != null)
    {
      // Attribute property Status
      Plate_element.setAttribute("Status", status);
    }
    if (externalIdentifier != null)
    {
      // Attribute property ExternalIdentifier
      Plate_element.setAttribute("ExternalIdentifier", externalIdentifier);
    }
    if (columnNamingConvention != null)
    {
      // Attribute property ColumnNamingConvention
      Plate_element.setAttribute("ColumnNamingConvention", columnNamingConvention.toString());
    }
    if (rowNamingConvention != null)
    {
      // Attribute property RowNamingConvention
      Plate_element.setAttribute("RowNamingConvention", rowNamingConvention.toString());
    }
    if (wellOriginX != null)
    {
      // Attribute property WellOriginX with units companion prop.unitsCompanion.name
      if (wellOriginX.value() != null)
      {


        Plate_element.setAttribute("WellOriginX", wellOriginX.value().toString());

      }
      if (wellOriginX.unit() != null)
      {
        try
        {
          UnitsLength enumUnits = UnitsLength.fromString(wellOriginX.unit().getSymbol());
          Plate_element.setAttribute("WellOriginXUnit", enumUnits.toString());
        } catch (EnumerationException e)
        {
          LOGGER.debug("Unable to create xml for Plate:WellOriginXUnit: {}", e.toString());
        }
      }
    }
    if (wellOriginY != null)
    {
      // Attribute property WellOriginY with units companion prop.unitsCompanion.name
      if (wellOriginY.value() != null)
      {


        Plate_element.setAttribute("WellOriginY", wellOriginY.value().toString());

      }
      if (wellOriginY.unit() != null)
      {
        try
        {
          UnitsLength enumUnits = UnitsLength.fromString(wellOriginY.unit().getSymbol());
          Plate_element.setAttribute("WellOriginYUnit", enumUnits.toString());
        } catch (EnumerationException e)
        {
          LOGGER.debug("Unable to create xml for Plate:WellOriginYUnit: {}", e.toString());
        }
      }
    }
    if (rows != null)
    {
      // Attribute property Rows
      Plate_element.setAttribute("Rows", rows.toString());
    }
    if (columns != null)
    {
      // Attribute property Columns
      Plate_element.setAttribute("Columns", columns.toString());
    }
    if (fieldIndex != null)
    {
      // Attribute property FieldIndex
      Plate_element.setAttribute("FieldIndex", fieldIndex.toString());
    }
    if (description != null)
    {
    // Element property Description which is not complex (has no
    // sub-elements)
    Element description_element =
      document.createElementNS(NAMESPACE, "Description");
      description_element.setTextContent(description);
      Plate_element.appendChild(description_element);
    }
    if (wells != null)
    {
      // Element property Well which is complex (has
      // sub-elements) and occurs more than once
      for (Well wells_value : wells)
      {
        Element child =
          document.createElementNS(NAMESPACE, "Well");
        wells_value.asXMLElement(document, child);
        Plate_element.appendChild(child);
      }
    }
    if (annotationLinks != null)
    {
      // Reference property AnnotationRef which occurs more than once
      for (Annotation annotationLinks_value : annotationLinks)
      {
        AnnotationRef o = new AnnotationRef();
        o.setID(annotationLinks_value.getID());
        Element child =
          document.createElementNS(NAMESPACE, "AnnotationRef");
        o.asXMLElement(document, child);
        Plate_element.appendChild(child);
      }
    }
    if (plateAcquisitions != null)
    {
      // Element property PlateAcquisition which is complex (has
      // sub-elements) and occurs more than once
      for (PlateAcquisition plateAcquisitions_value : plateAcquisitions)
      {
        Element child =
          document.createElementNS(NAMESPACE, "PlateAcquisition");
        plateAcquisitions_value.asXMLElement(document, child);
        Plate_element.appendChild(child);
      }
    }
    // *** IGNORING *** Skipped back reference Screen_BackReference

    return Plate_element;
  }
}
