/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.DetectorSettings;
import ome.xml.model.FilterSet;
import ome.xml.model.FilterSetRef;
import ome.xml.model.LightPath;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Channel
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Channel.class);
    private String id;
    private String name;
    private PositiveInteger samplesPerPixel;
    private IlluminationType illuminationType;
    private Length pinholeSize;
    private AcquisitionMode acquisitionMode;
    private ContrastMethod contrastMethod;
    private Length excitationWavelength;
    private Length emissionWavelength;
    private String fluor;
    private Double ndFilter;
    private Integer pockelCellSetting;
    private Color color;
    private LightSourceSettings lightSourceSettings;
    private DetectorSettings detectorSettings;
    private FilterSet filterSet;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private LightPath lightPath;
    private Pixels pixels;

    public Channel() {
    }

    public Channel(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Channel(Channel orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.samplesPerPixel = orig.samplesPerPixel;
        this.illuminationType = orig.illuminationType;
        this.pinholeSize = orig.pinholeSize;
        this.acquisitionMode = orig.acquisitionMode;
        this.contrastMethod = orig.contrastMethod;
        this.excitationWavelength = orig.excitationWavelength;
        this.emissionWavelength = orig.emissionWavelength;
        this.fluor = orig.fluor;
        this.ndFilter = orig.ndFilter;
        this.pockelCellSetting = orig.pockelCellSetting;
        this.color = orig.color;
        this.lightSourceSettings = orig.lightSourceSettings;
        this.detectorSettings = orig.detectorSettings;
        this.filterSet = orig.filterSet;
        this.annotationLinks = orig.annotationLinks;
        this.lightPath = orig.lightPath;
        this.pixels = orig.pixels;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> DetectorSettings_nodeList;
        List<Element> LightSourceSettings_nodeList;
        Object baseValue;
        UnitsLength modelUnit;
        String unitSymbol;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("Channel missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (element.hasAttribute("SamplesPerPixel")) {
            this.setSamplesPerPixel(PositiveInteger.valueOf(element.getAttribute("SamplesPerPixel")));
        }
        if (element.hasAttribute("IlluminationType")) {
            this.setIlluminationType(IlluminationType.fromString(element.getAttribute("IlluminationType")));
        }
        if (element.hasAttribute("PinholeSize")) {
            unitSymbol = element.getAttribute("PinholeSizeUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Channel.getPinholeSizeUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("PinholeSize"));
            this.setPinholeSize(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("AcquisitionMode")) {
            this.setAcquisitionMode(AcquisitionMode.fromString(element.getAttribute("AcquisitionMode")));
        }
        if (element.hasAttribute("ContrastMethod")) {
            this.setContrastMethod(ContrastMethod.fromString(element.getAttribute("ContrastMethod")));
        }
        if (element.hasAttribute("ExcitationWavelength")) {
            unitSymbol = element.getAttribute("ExcitationWavelengthUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Channel.getExcitationWavelengthUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = PositiveFloat.valueOf(element.getAttribute("ExcitationWavelength"));
            this.setExcitationWavelength(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("EmissionWavelength")) {
            unitSymbol = element.getAttribute("EmissionWavelengthUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Channel.getEmissionWavelengthUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = PositiveFloat.valueOf(element.getAttribute("EmissionWavelength"));
            this.setEmissionWavelength(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("Fluor")) {
            this.setFluor(String.valueOf(element.getAttribute("Fluor")));
        }
        if (element.hasAttribute("NDFilter")) {
            this.setNDFilter(Double.valueOf(element.getAttribute("NDFilter")));
        }
        if (element.hasAttribute("PockelCellSetting")) {
            this.setPockelCellSetting(Integer.valueOf(element.getAttribute("PockelCellSetting")));
        }
        if (element.hasAttribute("Color")) {
            this.setColor(Color.valueOf(element.getAttribute("Color")));
        }
        if ((LightSourceSettings_nodeList = Channel.getChildrenByTagName(element, "LightSourceSettings")).size() > 1) {
            throw new RuntimeException(String.format("LightSourceSettings node list size %d != 1", LightSourceSettings_nodeList.size()));
        }
        if (LightSourceSettings_nodeList.size() != 0) {
            this.setLightSourceSettings(new LightSourceSettings(LightSourceSettings_nodeList.get(0), model));
        }
        if ((DetectorSettings_nodeList = Channel.getChildrenByTagName(element, "DetectorSettings")).size() > 1) {
            throw new RuntimeException(String.format("DetectorSettings node list size %d != 1", DetectorSettings_nodeList.size()));
        }
        if (DetectorSettings_nodeList.size() != 0) {
            this.setDetectorSettings(new DetectorSettings(DetectorSettings_nodeList.get(0), model));
        }
        List<Element> FilterSetRef_nodeList = Channel.getChildrenByTagName(element, "FilterSetRef");
        for (Element element2 : FilterSetRef_nodeList) {
            FilterSetRef filterSet_reference = new FilterSetRef();
            filterSet_reference.setID(element2.getAttribute("ID"));
            model.addReference(this, filterSet_reference);
        }
        List<Element> AnnotationRef_nodeList = Channel.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
        List<Element> list = Channel.getChildrenByTagName(element, "LightPath");
        if (list.size() > 1) {
            throw new RuntimeException(String.format("LightPath node list size %d != 1", list.size()));
        }
        if (list.size() != 0) {
            this.setLightPath(new LightPath(list.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof FilterSetRef) {
            FilterSet o_casted = (FilterSet)o;
            o_casted.linkChannel(this);
            this.filterSet = o_casted;
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkChannel(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PositiveInteger getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public void setSamplesPerPixel(PositiveInteger samplesPerPixel) {
        this.samplesPerPixel = samplesPerPixel;
    }

    public IlluminationType getIlluminationType() {
        return this.illuminationType;
    }

    public void setIlluminationType(IlluminationType illuminationType) {
        this.illuminationType = illuminationType;
    }

    public Length getPinholeSize() {
        return this.pinholeSize;
    }

    public void setPinholeSize(Length pinholeSize) {
        this.pinholeSize = pinholeSize;
    }

    public static String getPinholeSizeUnitXsdDefault() {
        return "\u00b5m";
    }

    public AcquisitionMode getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public void setAcquisitionMode(AcquisitionMode acquisitionMode) {
        this.acquisitionMode = acquisitionMode;
    }

    public ContrastMethod getContrastMethod() {
        return this.contrastMethod;
    }

    public void setContrastMethod(ContrastMethod contrastMethod) {
        this.contrastMethod = contrastMethod;
    }

    public Length getExcitationWavelength() {
        return this.excitationWavelength;
    }

    public void setExcitationWavelength(Length excitationWavelength) {
        this.excitationWavelength = excitationWavelength;
    }

    public static String getExcitationWavelengthUnitXsdDefault() {
        return "nm";
    }

    public Length getEmissionWavelength() {
        return this.emissionWavelength;
    }

    public void setEmissionWavelength(Length emissionWavelength) {
        this.emissionWavelength = emissionWavelength;
    }

    public static String getEmissionWavelengthUnitXsdDefault() {
        return "nm";
    }

    public String getFluor() {
        return this.fluor;
    }

    public void setFluor(String fluor) {
        this.fluor = fluor;
    }

    public Double getNDFilter() {
        return this.ndFilter;
    }

    public void setNDFilter(Double ndFilter) {
        this.ndFilter = ndFilter;
    }

    public Integer getPockelCellSetting() {
        return this.pockelCellSetting;
    }

    public void setPockelCellSetting(Integer pockelCellSetting) {
        this.pockelCellSetting = pockelCellSetting;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public LightSourceSettings getLightSourceSettings() {
        return this.lightSourceSettings;
    }

    public void setLightSourceSettings(LightSourceSettings lightSourceSettings) {
        this.lightSourceSettings = lightSourceSettings;
    }

    public DetectorSettings getDetectorSettings() {
        return this.detectorSettings;
    }

    public void setDetectorSettings(DetectorSettings detectorSettings) {
        this.detectorSettings = detectorSettings;
    }

    public FilterSet getLinkedFilterSet() {
        return this.filterSet;
    }

    public void linkFilterSet(FilterSet o) {
        this.filterSet = o;
    }

    public void unlinkFilterSet(FilterSet o) {
        if (this.filterSet == o) {
            this.filterSet = null;
        }
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkChannel(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkChannel(this);
        return this.annotationLinks.remove(o);
    }

    public LightPath getLightPath() {
        return this.lightPath;
    }

    public void setLightPath(LightPath lightPath) {
        this.lightPath = lightPath;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels_BackReference) {
        this.pixels = pixels_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Channel_element) {
        Element child;
        UnitsLength enumUnits;
        if (Channel_element == null) {
            Channel_element = document.createElementNS(NAMESPACE, "Channel");
        }
        super.asXMLElement(document, Channel_element);
        if (this.id != null) {
            Channel_element.setAttribute("ID", this.id);
        }
        if (this.name != null) {
            Channel_element.setAttribute("Name", this.name);
        }
        if (this.samplesPerPixel != null) {
            Channel_element.setAttribute("SamplesPerPixel", this.samplesPerPixel.toString());
        }
        if (this.illuminationType != null) {
            Channel_element.setAttribute("IlluminationType", this.illuminationType.toString());
        }
        if (this.pinholeSize != null) {
            if (this.pinholeSize.value() != null) {
                Channel_element.setAttribute("PinholeSize", this.pinholeSize.value().toString());
            }
            if (this.pinholeSize.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.pinholeSize.unit().getSymbol());
                    Channel_element.setAttribute("PinholeSizeUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Channel:PinholeSizeUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.acquisitionMode != null) {
            Channel_element.setAttribute("AcquisitionMode", this.acquisitionMode.toString());
        }
        if (this.contrastMethod != null) {
            Channel_element.setAttribute("ContrastMethod", this.contrastMethod.toString());
        }
        if (this.excitationWavelength != null) {
            if (this.excitationWavelength.value() != null) {
                Channel_element.setAttribute("ExcitationWavelength", this.excitationWavelength.value().toString());
            }
            if (this.excitationWavelength.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.excitationWavelength.unit().getSymbol());
                    Channel_element.setAttribute("ExcitationWavelengthUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Channel:ExcitationWavelengthUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.emissionWavelength != null) {
            if (this.emissionWavelength.value() != null) {
                Channel_element.setAttribute("EmissionWavelength", this.emissionWavelength.value().toString());
            }
            if (this.emissionWavelength.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.emissionWavelength.unit().getSymbol());
                    Channel_element.setAttribute("EmissionWavelengthUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Channel:EmissionWavelengthUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.fluor != null) {
            Channel_element.setAttribute("Fluor", this.fluor);
        }
        if (this.ndFilter != null) {
            Channel_element.setAttribute("NDFilter", this.ndFilter.toString());
        }
        if (this.pockelCellSetting != null) {
            Channel_element.setAttribute("PockelCellSetting", this.pockelCellSetting.toString());
        }
        if (this.color != null) {
            Channel_element.setAttribute("Color", this.color.toString());
        }
        if (this.lightSourceSettings != null) {
            child = document.createElementNS(NAMESPACE, "LightSourceSettings");
            this.lightSourceSettings.asXMLElement(document, child);
            Channel_element.appendChild(child);
        }
        if (this.detectorSettings != null) {
            child = document.createElementNS(NAMESPACE, "DetectorSettings");
            this.detectorSettings.asXMLElement(document, child);
            Channel_element.appendChild(child);
        }
        if (this.filterSet != null) {
            FilterSetRef o = new FilterSetRef();
            o.setID(this.filterSet.getID());
            Element child2 = document.createElementNS(NAMESPACE, "FilterSetRef");
            o.asXMLElement(document, child2);
            Channel_element.appendChild(child2);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child3 = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child3);
                Channel_element.appendChild(child3);
            }
        }
        if (this.lightPath != null) {
            child = document.createElementNS(NAMESPACE, "LightPath");
            this.lightPath.asXMLElement(document, child);
            Channel_element.appendChild(child);
        }
        return Channel_element;
    }
}

