/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.text.MessageFormat;
import org.openmuc.j60870.ASdu;
import org.openmuc.j60870.ConnectionSettings;
import org.openmuc.j60870.internal.ExtendedDataInputStream;

class APdu {
    private static final int CONTROL_FIELDS_LENGTH = 4;
    private static final int MIN_APDU_LENGTH = 4;
    private static final int MAX_APDU_LENGTH = 253;
    private static final byte START_FLAG = 104;
    private final int sendSeqNum;
    private final int receiveSeqNum;
    private final ApciType apciType;
    private final ASdu aSdu;

    public APdu(int sendSeqNum, int receiveSeqNum, ApciType apciType, ASdu aSdu) {
        this.sendSeqNum = sendSeqNum;
        this.receiveSeqNum = receiveSeqNum;
        this.apciType = apciType;
        this.aSdu = aSdu;
    }

    public static APdu decode(Socket socket, ConnectionSettings settings) throws IOException {
        socket.setSoTimeout(0);
        ExtendedDataInputStream is = new ExtendedDataInputStream(socket.getInputStream());
        if (is.readByte() != 104) {
            throw new IOException("Message does not start with START flag (0x68). Broken connection.");
        }
        socket.setSoTimeout(settings.getMessageFragmentTimeout());
        int length = APdu.readApduLength(is);
        byte[] aPduControlFields = APdu.readControlFields(is);
        ApciType apciType = ApciType.apciTypeFor(aPduControlFields[0]);
        switch (apciType) {
            case I_FORMAT: {
                int sendSeqNum = APdu.seqNumFrom(aPduControlFields[0], aPduControlFields[1]);
                int receiveSeqNum = APdu.seqNumFrom(aPduControlFields[2], aPduControlFields[3]);
                int aSduLength = length - 4;
                return new APdu(sendSeqNum, receiveSeqNum, apciType, ASdu.decode(is, settings, aSduLength));
            }
            case S_FORMAT: {
                return new APdu(0, APdu.seqNumFrom(aPduControlFields[2], aPduControlFields[3]), apciType, null);
            }
        }
        return new APdu(0, 0, apciType, null);
    }

    private static int seqNumFrom(byte b1, byte b2) {
        return ((b1 & 0xFE) >> 1) + ((b2 & 0xFF) << 7);
    }

    private static int readApduLength(DataInputStream is) throws IOException {
        int length = is.readUnsignedByte();
        if (length < 4 || length > 253) {
            String msg = MessageFormat.format("APDU has an invalid length must be between 4 and 253.\nReceived length was: {0}.", length);
            throw new IOException(msg);
        }
        return length;
    }

    private static byte[] readControlFields(DataInputStream is) throws IOException {
        byte[] aPduControlFields = new byte[4];
        is.readFully(aPduControlFields);
        return aPduControlFields;
    }

    public int encode(byte[] buffer, ConnectionSettings settings) {
        buffer[0] = 104;
        int length = 4;
        if (this.apciType == ApciType.I_FORMAT) {
            buffer[2] = (byte)(this.sendSeqNum << 1);
            buffer[3] = (byte)(this.sendSeqNum >> 7);
            this.writeReceiveSeqNumTo(buffer);
            length += this.aSdu.encode(buffer, 6, settings);
        } else if (this.apciType == ApciType.STARTDT_ACT) {
            buffer[2] = 7;
            APdu.setV3To5zero(buffer);
        } else if (this.apciType == ApciType.STARTDT_CON) {
            buffer[2] = 11;
            APdu.setV3To5zero(buffer);
        } else if (this.apciType == ApciType.STOPDT_ACT) {
            buffer[2] = 19;
            APdu.setV3To5zero(buffer);
        } else if (this.apciType == ApciType.STOPDT_CON) {
            buffer[2] = 35;
            APdu.setV3To5zero(buffer);
        } else if (this.apciType == ApciType.S_FORMAT) {
            buffer[2] = 1;
            buffer[3] = 0;
            this.writeReceiveSeqNumTo(buffer);
        }
        buffer[1] = (byte)length;
        return length + 2;
    }

    private static void setV3To5zero(byte[] buffer) {
        buffer[3] = 0;
        buffer[4] = 0;
        buffer[5] = 0;
    }

    private void writeReceiveSeqNumTo(byte[] buffer) {
        buffer[4] = (byte)(this.receiveSeqNum << 1);
        buffer[5] = (byte)(this.receiveSeqNum >> 7);
    }

    public ApciType getApciType() {
        return this.apciType;
    }

    public int getSendSeqNumber() {
        return this.sendSeqNum;
    }

    public int getReceiveSeqNumber() {
        return this.receiveSeqNum;
    }

    public ASdu getASdu() {
        return this.aSdu;
    }

    public static enum ApciType {
        I_FORMAT,
        S_FORMAT,
        TESTFR_CON,
        TESTFR_ACT,
        STOPDT_CON,
        STOPDT_ACT,
        STARTDT_CON,
        STARTDT_ACT;


        private static ApciType apciTypeFor(byte controlField1) {
            if ((controlField1 & 1) == 0) {
                return I_FORMAT;
            }
            switch (controlField1 & 3) {
                case 1: {
                    return S_FORMAT;
                }
            }
            return ApciType.unnumberedFormatFor(controlField1);
        }

        private static ApciType unnumberedFormatFor(byte controlField1) {
            if ((controlField1 & 0x80) == 128) {
                return TESTFR_CON;
            }
            if (controlField1 == 67) {
                return TESTFR_ACT;
            }
            if (controlField1 == 35) {
                return STOPDT_CON;
            }
            if (controlField1 == 19) {
                return STOPDT_ACT;
            }
            if (controlField1 == 11) {
                return STARTDT_CON;
            }
            return STARTDT_ACT;
        }
    }
}

