/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.bind.DatatypeConverter;
import org.openmuc.j60870.ASduType;
import org.openmuc.j60870.CauseOfTransmission;
import org.openmuc.j60870.ConnectionSettings;
import org.openmuc.j60870.ie.InformationObject;
import org.openmuc.j60870.internal.ExtendedDataInputStream;

public class ASdu {
    private final ASduType aSduType;
    private final boolean isSequenceOfElements;
    private final CauseOfTransmission causeOfTransmission;
    private final boolean test;
    private final boolean negativeConfirm;
    private final int originatorAddress;
    private final int commonAddress;
    private final InformationObject[] informationObjects;
    private final byte[] privateInformation;
    private final int sequenceLength;

    public ASdu(ASduType typeId, boolean isSequenceOfElements, CauseOfTransmission causeOfTransmission, boolean test, boolean negativeConfirm, int originatorAddress, int commonAddress, InformationObject ... informationObjects) {
        this.aSduType = typeId;
        this.isSequenceOfElements = isSequenceOfElements;
        this.causeOfTransmission = causeOfTransmission;
        this.test = test;
        this.negativeConfirm = negativeConfirm;
        this.originatorAddress = originatorAddress;
        this.commonAddress = commonAddress;
        this.informationObjects = informationObjects;
        this.privateInformation = null;
        this.sequenceLength = isSequenceOfElements ? informationObjects[0].getInformationElements().length : informationObjects.length;
    }

    public ASdu(ASduType typeId, boolean isSequenceOfElements, int sequenceLength, CauseOfTransmission causeOfTransmission, boolean test, boolean negativeConfirm, int originatorAddress, int commonAddress, byte[] privateInformation) {
        this.aSduType = typeId;
        this.isSequenceOfElements = isSequenceOfElements;
        this.causeOfTransmission = causeOfTransmission;
        this.test = test;
        this.negativeConfirm = negativeConfirm;
        this.originatorAddress = originatorAddress;
        this.commonAddress = commonAddress;
        this.informationObjects = null;
        this.privateInformation = privateInformation;
        this.sequenceLength = sequenceLength;
    }

    static ASdu decode(ExtendedDataInputStream is, ConnectionSettings settings, int aSduLength) throws IOException {
        int commonAddress;
        int originatorAddress;
        int numberOfInformationObjects;
        int numberOfSequenceElements;
        int typeIdCode = is.readUnsignedByte();
        ASduType typeId = ASduType.typeFor(typeIdCode);
        if (typeId == null) {
            throw new IOException(MessageFormat.format("Unknown Type Identification: {0}", typeIdCode));
        }
        int currentByte = is.readUnsignedByte();
        boolean isSequenceOfElements = ASdu.byteHasMask(currentByte, 128);
        int sequenceLength = currentByte & 0x7F;
        if (isSequenceOfElements) {
            numberOfSequenceElements = sequenceLength;
            numberOfInformationObjects = 1;
        } else {
            numberOfInformationObjects = sequenceLength;
            numberOfSequenceElements = 1;
        }
        currentByte = is.readUnsignedByte();
        CauseOfTransmission causeOfTransmission = CauseOfTransmission.causeFor(currentByte & 0x3F);
        boolean test = ASdu.byteHasMask(currentByte, 128);
        boolean negativeConfirm = ASdu.byteHasMask(currentByte, 64);
        if (settings.getCotFieldLength() == 2) {
            originatorAddress = is.readUnsignedByte();
            --aSduLength;
        } else {
            originatorAddress = -1;
        }
        if (settings.getCommonAddressFieldLength() == 1) {
            commonAddress = is.readUnsignedByte();
        } else {
            commonAddress = is.readUnsignedByte() | is.readUnsignedByte() << 8;
            --aSduLength;
        }
        if (typeIdCode < 128) {
            InformationObject[] informationObjects = new InformationObject[numberOfInformationObjects];
            int ioaFieldLength = settings.getIoaFieldLength();
            for (int i = 0; i < numberOfInformationObjects; ++i) {
                informationObjects[i] = InformationObject.decode(is, typeId, numberOfSequenceElements, ioaFieldLength);
            }
            return new ASdu(typeId, isSequenceOfElements, causeOfTransmission, test, negativeConfirm, originatorAddress, commonAddress, informationObjects);
        }
        byte[] privateInformation = new byte[aSduLength - 4];
        is.readFully(privateInformation);
        return new ASdu(typeId, isSequenceOfElements, sequenceLength, causeOfTransmission, test, negativeConfirm, originatorAddress, commonAddress, privateInformation);
    }

    private static boolean byteHasMask(int b, int mask) {
        return (b & mask) == mask;
    }

    public ASduType getTypeIdentification() {
        return this.aSduType;
    }

    public boolean isSequenceOfElements() {
        return this.isSequenceOfElements;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public CauseOfTransmission getCauseOfTransmission() {
        return this.causeOfTransmission;
    }

    public boolean isTestFrame() {
        return this.test;
    }

    public boolean isNegativeConfirm() {
        return this.negativeConfirm;
    }

    public Integer getOriginatorAddress() {
        return this.originatorAddress;
    }

    public int getCommonAddress() {
        return this.commonAddress;
    }

    public InformationObject[] getInformationObjects() {
        return this.informationObjects;
    }

    public byte[] getPrivateInformation() {
        return this.privateInformation;
    }

    int encode(byte[] buffer, int i, ConnectionSettings settings) {
        int origi = i;
        buffer[i++] = (byte)this.aSduType.getId();
        buffer[i++] = this.isSequenceOfElements ? (byte)(this.sequenceLength | 0x80) : (byte)this.sequenceLength;
        buffer[i++] = this.test ? (this.negativeConfirm ? (byte)(this.causeOfTransmission.getId() | 0xC0) : (byte)(this.causeOfTransmission.getId() | 0x80)) : (this.negativeConfirm ? (byte)(this.causeOfTransmission.getId() | 0x40) : (byte)this.causeOfTransmission.getId());
        if (settings.getCotFieldLength() == 2) {
            buffer[i++] = (byte)this.originatorAddress;
        }
        buffer[i++] = (byte)this.commonAddress;
        if (settings.getCommonAddressFieldLength() == 2) {
            buffer[i++] = (byte)(this.commonAddress >> 8);
        }
        if (this.informationObjects != null) {
            for (InformationObject informationObject : this.informationObjects) {
                i += informationObject.encode(buffer, i, settings.getIoaFieldLength());
            }
        } else {
            System.arraycopy(this.privateInformation, 0, buffer, i, this.privateInformation.length);
            i += this.privateInformation.length;
        }
        return i - origi;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("ASDU Type: ").append(this.aSduType.getId()).append(", ").append((Object)this.aSduType).append(", ").append(this.aSduType.getDescription()).append("\nCause of transmission: ").append((Object)this.causeOfTransmission).append(", test: ").append(this.isTestFrame()).append(", negative con: ").append(this.isNegativeConfirm()).append("\nOriginator address: ").append(this.originatorAddress).append(", Common address: ").append(this.commonAddress);
        if (this.informationObjects != null) {
            for (InformationObject informationObject : this.informationObjects) {
                builder.append("\n").append(informationObject);
            }
        } else {
            builder.append("\nPrivate Information:\n");
            builder.append(DatatypeConverter.printHexBinary((byte[])this.privateInformation));
        }
        return builder.toString();
    }
}

