/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.openmuc.j60870.CommonBuilder;
import org.openmuc.j60870.Connection;
import org.openmuc.j60870.ConnectionSettings;

public class ClientConnectionBuilder
extends CommonBuilder<ClientConnectionBuilder, Connection> {
    private static final int DEFAULT_PORT = 2404;
    private SocketFactory socketFactory;
    private InetAddress address;
    private int port;
    private InetAddress localAddr;
    private int localPort;

    public ClientConnectionBuilder(InetAddress address) {
        this.address = address;
        this.port = 2404;
        this.localAddr = null;
        this.socketFactory = SocketFactory.getDefault();
    }

    public ClientConnectionBuilder(String inetAddress) throws UnknownHostException {
        this(InetAddress.getByName(inetAddress));
    }

    public ClientConnectionBuilder setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    public ClientConnectionBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public ClientConnectionBuilder setAddress(InetAddress address) {
        this.address = address;
        return this;
    }

    public ClientConnectionBuilder setLocalAddress(InetAddress address, int port) {
        this.localAddr = address;
        this.localPort = port;
        return this;
    }

    public ClientConnectionBuilder setConnectionTimeout(int time) {
        if (time < 100) {
            throw new IllegalArgumentException("invalid timeout: " + time + ", time must be bigger then 100ms");
        }
        this.settings.setConnectionTimeout(time);
        return this;
    }

    @Override
    public Connection build() throws IOException {
        Socket socket = this.socketFactory.createSocket();
        socket.setSoTimeout(this.settings.getMessageFragmentTimeout());
        if (this.localAddr != null) {
            socket.bind(new InetSocketAddress(this.localAddr, this.localPort));
        }
        socket.connect(new InetSocketAddress(this.address, this.port), this.settings.getConnectionTimeout());
        return new Connection(socket, null, new ConnectionSettings(this.settings));
    }
}

