/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.IOException;
import org.openmuc.j60870.ConnectionSettings;

abstract class CommonBuilder<T extends CommonBuilder<T, C>, C> {
    final ConnectionSettings settings = new ConnectionSettings();

    CommonBuilder() {
    }

    private T self() {
        return (T)this;
    }

    public T setCotFieldLength(int length) {
        if (length != 1 && length != 2) {
            throw new IllegalArgumentException("invalid length");
        }
        this.settings.setCotFieldLength(length);
        return this.self();
    }

    public T setCommonAddressFieldLength(int length) {
        if (length != 1 && length != 2) {
            throw new IllegalArgumentException("invalid length");
        }
        this.settings.setCommonAddressFieldLength(length);
        return this.self();
    }

    public T setIoaFieldLength(int length) {
        if (length < 1 || length > 3) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        this.settings.setIoaFieldLength(length);
        return this.self();
    }

    public T setMaxTimeNoAckReceived(int time) {
        this.checkTimeRange(time);
        this.settings.setMaxTimeNoAckReceived(time);
        return this.self();
    }

    public T setMaxTimeNoAckSent(int time) {
        this.checkTimeRange(time);
        this.settings.setMaxTimeNoAckSent(time);
        return this.self();
    }

    private void checkTimeRange(int time) {
        if (time < 1000 || time > 255000) {
            throw new IllegalArgumentException("invalid timeout: " + time + ", time must be between 1000ms and 255000ms");
        }
    }

    public T setMaxIdleTime(int time) {
        if (time < 1000 || time > 172800000) {
            throw new IllegalArgumentException("invalid timeout: " + time + ", time must be between 1000ms and 172800000ms");
        }
        this.settings.setMaxIdleTime(time);
        return this.self();
    }

    public T setMaxNumOfOutstandingIPdus(int maxNum) {
        if (maxNum < 1 || maxNum > Short.MAX_VALUE) {
            throw new IllegalArgumentException("invalid maxNum: " + maxNum + ", must be a value between 1 and 32767");
        }
        this.settings.setMaxNumOfOutstandingIPdus(maxNum);
        return this.self();
    }

    public T setMaxUnconfirmedIPdusReceived(int maxNum) {
        if (maxNum < 1 || maxNum > Short.MAX_VALUE) {
            throw new IllegalArgumentException("invalid maxNum: " + maxNum + ", must be a value between 1 and 32767");
        }
        this.settings.setMaxUnconfirmedIPdusReceived(maxNum);
        return this.self();
    }

    public T setMessageFragmentTimeout(int time) {
        if (time < 100) {
            throw new IllegalArgumentException("invalid timeout: " + time + ", time must be bigger then 100ms");
        }
        this.settings.setMessageFragmentTimeout(time);
        return this.self();
    }

    public T useSharedThreadPool() {
        this.settings.setUseSharedThreadPool(true);
        return this.self();
    }

    public abstract C build() throws IOException;
}

