/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openmuc.j60870.APdu;
import org.openmuc.j60870.ASdu;
import org.openmuc.j60870.ASduType;
import org.openmuc.j60870.CauseOfTransmission;
import org.openmuc.j60870.ConnectionEventListener;
import org.openmuc.j60870.ConnectionSettings;
import org.openmuc.j60870.ServerThread;
import org.openmuc.j60870.TimeoutManager;
import org.openmuc.j60870.TimeoutTask;
import org.openmuc.j60870.ie.IeAckFileOrSectionQualifier;
import org.openmuc.j60870.ie.IeBinaryStateInformation;
import org.openmuc.j60870.ie.IeChecksum;
import org.openmuc.j60870.ie.IeDoubleCommand;
import org.openmuc.j60870.ie.IeFileReadyQualifier;
import org.openmuc.j60870.ie.IeFileSegment;
import org.openmuc.j60870.ie.IeFixedTestBitPattern;
import org.openmuc.j60870.ie.IeLastSectionOrSegmentQualifier;
import org.openmuc.j60870.ie.IeLengthOfFileOrSection;
import org.openmuc.j60870.ie.IeNameOfFile;
import org.openmuc.j60870.ie.IeNameOfSection;
import org.openmuc.j60870.ie.IeNormalizedValue;
import org.openmuc.j60870.ie.IeQualifierOfCounterInterrogation;
import org.openmuc.j60870.ie.IeQualifierOfInterrogation;
import org.openmuc.j60870.ie.IeQualifierOfParameterActivation;
import org.openmuc.j60870.ie.IeQualifierOfParameterOfMeasuredValues;
import org.openmuc.j60870.ie.IeQualifierOfResetProcessCommand;
import org.openmuc.j60870.ie.IeQualifierOfSetPointCommand;
import org.openmuc.j60870.ie.IeRegulatingStepCommand;
import org.openmuc.j60870.ie.IeScaledValue;
import org.openmuc.j60870.ie.IeSectionReadyQualifier;
import org.openmuc.j60870.ie.IeSelectAndCallQualifier;
import org.openmuc.j60870.ie.IeShortFloat;
import org.openmuc.j60870.ie.IeSingleCommand;
import org.openmuc.j60870.ie.IeTestSequenceCounter;
import org.openmuc.j60870.ie.IeTime16;
import org.openmuc.j60870.ie.IeTime56;
import org.openmuc.j60870.ie.InformationElement;
import org.openmuc.j60870.ie.InformationObject;

public class Connection
implements AutoCloseable {
    private static final byte[] TESTFR_CON_BUFFER = new byte[]{104, 4, -125, 0, 0, 0};
    private static final byte[] TESTFR_ACT_BUFFER = new byte[]{104, 4, 67, 0, 0, 0};
    private static final byte[] STARTDT_ACT_BUFFER = new byte[]{104, 4, 7, 0, 0, 0};
    private static final byte[] STARTDT_CON_BUFFER = new byte[]{104, 4, 11, 0, 0, 0};
    private static final byte[] STOPDT_ACT_BUFFER = new byte[]{104, 4, 19, 0, 0, 0};
    private static final byte[] STOPDT_CON_BUFFER = new byte[]{104, 4, 35, 0, 0, 0};
    private final Socket socket;
    private final ServerThread serverThread;
    private final DataOutputStream os;
    private volatile boolean closed;
    private volatile boolean stopped = true;
    private final ConnectionSettings settings;
    private ConnectionEventListener aSduListener;
    private ConnectionEventListener aSduListenerBack;
    private int sendSequenceNumber;
    private int receiveSequenceNumber;
    private int acknowledgedReceiveSequenceNumber;
    private int acknowledgedSendSequenceNumber;
    private int originatorAddress;
    private final byte[] buffer = new byte[255];
    private final TimeoutManager timeoutManager;
    private final TimeoutTask maxTimeNoTestConReceived;
    private final TimeoutTask maxTimeNoAckReceived;
    private final TimeoutTask maxIdleTimeTimer;
    private final TimeoutTask maxTimeNoAckSentTimer;
    private IOException closedIOException;
    private CountDownLatch startdtActSignal;
    private CountDownLatch startdtConSignal;
    private CountDownLatch stopdtConSignal;
    private final ExecutorService executor;

    Connection(Socket socket, ServerThread serverThread, ConnectionSettings settings) throws IOException {
        try {
            this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
        this.socket = socket;
        this.settings = settings;
        this.serverThread = serverThread;
        if (serverThread != null) {
            this.startdtActSignal = new CountDownLatch(1);
        }
        ConnectionReader connectionReader = new ConnectionReader();
        connectionReader.start();
        this.maxTimeNoTestConReceived = new MaxTimeNoAckReceivedTimer();
        this.maxTimeNoAckReceived = new MaxTimeNoAckReceivedTimer();
        this.maxIdleTimeTimer = new MaxIdleTimeTimer();
        this.maxTimeNoAckSentTimer = new MaxTimeNoAckSentTimer();
        this.executor = settings.useSharedThreadPool() ? ConnectionSettings.getThreadPool() : Executors.newFixedThreadPool(2);
        ConnectionSettings.incremntConnectionsCounter();
        this.timeoutManager = new TimeoutManager();
        this.executor.execute(this.timeoutManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDataTransfer() throws IOException {
        boolean success;
        Connection connection = this;
        synchronized (connection) {
            this.stopdtConSignal = new CountDownLatch(1);
            this.os.write(STOPDT_ACT_BUFFER);
        }
        this.os.flush();
        try {
            success = this.stopdtConSignal.await(this.settings.getMaxTimeNoAckReceived(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            success = true;
            Thread.currentThread().interrupt();
        }
        if (!success) {
            throw new InterruptedIOException("Request timed out.");
        }
        Connection connection2 = this;
        synchronized (connection2) {
            this.aSduListenerBack = this.aSduListener;
            this.aSduListener = null;
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void startDataTransfer(ConnectionEventListener listener, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout may not be negative.");
        }
        Connection connection = this;
        synchronized (connection) {
            this.startdtConSignal = new CountDownLatch(1);
            this.os.write(STARTDT_ACT_BUFFER);
        }
        this.os.flush();
        if (timeout == 0) {
            try {
                this.startdtConSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            boolean success;
            try {
                success = this.startdtConSignal.await(this.settings.getMaxTimeNoAckReceived(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                success = true;
                Thread.currentThread().interrupt();
            }
            if (!success) {
                throw new InterruptedIOException("Request timed out.");
            }
        }
        Connection connection2 = this;
        synchronized (connection2) {
            this.aSduListener = listener;
            this.stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDataTransfer(ConnectionEventListener listener) throws IOException {
        boolean success;
        Connection connection = this;
        synchronized (connection) {
            this.startdtConSignal = new CountDownLatch(1);
            this.os.write(STARTDT_ACT_BUFFER);
        }
        this.os.flush();
        try {
            success = this.startdtConSignal.await(this.settings.getMaxTimeNoAckReceived(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            success = true;
            Thread.currentThread().interrupt();
        }
        if (!success) {
            throw new InterruptedIOException("Request timed out.");
        }
        Connection connection2 = this;
        synchronized (connection2) {
            this.aSduListener = listener;
            this.stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionListener(ConnectionEventListener listener) {
        Connection connection = this;
        synchronized (connection) {
            this.aSduListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void waitForStartDT(ConnectionEventListener listener, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout may not be negative");
        }
        if (timeout == 0) {
            try {
                this.startdtActSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            boolean success = true;
            try {
                success = this.startdtActSignal.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!success) {
                throw new InterruptedIOException();
            }
        }
        Connection connection = this;
        synchronized (connection) {
            this.aSduListener = listener;
            this.stopped = false;
        }
        this.resetMaxIdleTimeTimer();
    }

    private void sendSFormatPdu() throws IOException {
        int length = new APdu(0, this.receiveSequenceNumber, APdu.ApciType.S_FORMAT, null).encode(this.buffer, this.settings);
        this.os.write(this.buffer, 0, length);
        this.os.flush();
        this.acknowledgedReceiveSequenceNumber = this.receiveSequenceNumber;
        this.resetMaxIdleTimeTimer();
    }

    public void setOriginatorAddress(int originatorAddress) {
        if (originatorAddress < 0 || originatorAddress > 255) {
            throw new IllegalArgumentException("Originator Address must be between 0 and 255.");
        }
        this.originatorAddress = originatorAddress;
    }

    public int getOriginatorAddress() {
        return this.originatorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumUnconfirmedAPdusSent() {
        Connection connection = this;
        synchronized (connection) {
            return Connection.sequenceNumberDiff(this.sendSequenceNumber, this.acknowledgedSendSequenceNumber);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.closed = true;
        }
        if (this.serverThread != null) {
            this.serverThread.connectionClosedSignal();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void send(ASdu aSdu) throws IOException {
        while (this.getNumUnconfirmedAPdusSent() >= this.settings.getMaxNumOfOutstandingIPdus()) {
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        this.acknowledgedReceiveSequenceNumber = this.receiveSequenceNumber;
        APdu requestAPdu = new APdu(this.sendSequenceNumber, this.receiveSequenceNumber, APdu.ApciType.I_FORMAT, aSdu);
        int oldSendSequenceNumber = this.sendSequenceNumber;
        this.sendSequenceNumber = (this.sendSequenceNumber + 1) % 32768;
        if (oldSendSequenceNumber > this.sendSequenceNumber) {
            this.sendSFormatPdu();
        }
        if (this.maxTimeNoAckSentTimer.isPlanned()) {
            this.maxTimeNoAckSentTimer.cancel();
        }
        if (!this.maxTimeNoAckReceived.isPlanned()) {
            this.timeoutManager.addTimerTask(this.maxTimeNoAckReceived);
        }
        int length = requestAPdu.encode(this.buffer, this.settings);
        this.os.write(this.buffer, 0, length);
        this.os.flush();
        this.resetMaxIdleTimeTimer();
    }

    private static int sequenceNumberDiff(int number, int ackNumber) {
        return ackNumber > number ? 32768 - ackNumber + number : number - ackNumber;
    }

    private void resetMaxIdleTimeTimer() {
        this.maxIdleTimeTimer.cancel();
        this.timeoutManager.addTimerTask(this.maxIdleTimeTimer);
    }

    public void sendConfirmation(ASdu aSdu) throws IOException {
        this.sendConfirmation(aSdu, aSdu.getCommonAddress());
    }

    public void sendConfirmation(ASdu aSdu, int stationAddress) throws IOException {
        int broadcastAddress;
        CauseOfTransmission cot = this.cotFrom(aSdu);
        int commonAddress = aSdu.getCommonAddress();
        if (commonAddress == (broadcastAddress = this.settings.getCommonAddressFieldLength() == 2 ? 65535 : 255)) {
            commonAddress = stationAddress;
        }
        this.send(new ASdu(aSdu.getTypeIdentification(), aSdu.isSequenceOfElements(), cot, aSdu.isTestFrame(), aSdu.isNegativeConfirm(), aSdu.getOriginatorAddress(), commonAddress, aSdu.getInformationObjects()));
    }

    private CauseOfTransmission cotFrom(ASdu aSdu) {
        CauseOfTransmission cot = aSdu.getCauseOfTransmission();
        switch (cot) {
            case ACTIVATION: {
                return CauseOfTransmission.ACTIVATION_CON;
            }
            case DEACTIVATION: {
                return CauseOfTransmission.DEACTIVATION_CON;
            }
        }
        return cot;
    }

    public void singleCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeSingleCommand singleCommand) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SC_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, singleCommand));
        this.send(aSdu);
    }

    public void singleCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeSingleCommand singleCommand, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SC_TA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, singleCommand, timeTag));
        this.send(aSdu);
    }

    public void doubleCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeDoubleCommand doubleCommand) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_DC_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, doubleCommand));
        this.send(aSdu);
    }

    public void doubleCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeDoubleCommand doubleCommand, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_DC_TA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, doubleCommand, timeTag));
        this.send(aSdu);
    }

    public void regulatingStepCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeRegulatingStepCommand regulatingStepCommand) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_RC_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, regulatingStepCommand));
        this.send(aSdu);
    }

    public void regulatingStepCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeRegulatingStepCommand regulatingStepCommand, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_RC_TA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, regulatingStepCommand, timeTag));
        this.send(aSdu);
    }

    public void setNormalizedValueCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeNormalizedValue normalizedValue, IeQualifierOfSetPointCommand qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SE_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, normalizedValue, qualifier));
        this.send(aSdu);
    }

    public void setNormalizedValueCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeNormalizedValue normalizedValue, IeQualifierOfSetPointCommand qualifier, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SE_TA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, normalizedValue, qualifier, timeTag));
        this.send(aSdu);
    }

    public void setScaledValueCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeScaledValue scaledValue, IeQualifierOfSetPointCommand qualifier) throws IOException {
        ASduType typeId = ASduType.C_SE_NB_1;
        ASdu aSdu = new ASdu(typeId, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, scaledValue, qualifier));
        this.send(aSdu);
    }

    public void setScaledValueCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeScaledValue scaledValue, IeQualifierOfSetPointCommand qualifier, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SE_TB_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, scaledValue, qualifier, timeTag));
        this.send(aSdu);
    }

    public void setShortFloatCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeShortFloat floatVal, IeQualifierOfSetPointCommand qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SE_NC_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, floatVal, qualifier));
        this.send(aSdu);
    }

    public void setShortFloatCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeShortFloat shortFloat, IeQualifierOfSetPointCommand qualifier, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_SE_TC_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, shortFloat, qualifier, timeTag));
        this.send(aSdu);
    }

    public void bitStringCommand(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeBinaryStateInformation binaryStateInformation) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_BO_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, binaryStateInformation));
        this.send(aSdu);
    }

    public void bitStringCommandWithTimeTag(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeBinaryStateInformation binaryStateInformation, IeTime56 timeTag) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_BO_TA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, binaryStateInformation, timeTag));
        this.send(aSdu);
    }

    public void interrogation(int commonAddress, CauseOfTransmission cot, IeQualifierOfInterrogation qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_IC_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(0, qualifier));
        this.send(aSdu);
    }

    public void counterInterrogation(int commonAddress, CauseOfTransmission cot, IeQualifierOfCounterInterrogation qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_CI_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(0, qualifier));
        this.send(aSdu);
    }

    public void readCommand(int commonAddress, int informationObjectAddress) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_RD_NA_1, false, CauseOfTransmission.REQUEST, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, new InformationElement[0]));
        this.send(aSdu);
    }

    public void synchronizeClocks(int commonAddress, IeTime56 time) throws IOException {
        InformationObject io = new InformationObject(0, time);
        ASdu aSdu = new ASdu(ASduType.C_CS_NA_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, io);
        this.send(aSdu);
    }

    public void testCommand(int commonAddress) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_TS_NA_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, new InformationObject(0, new IeFixedTestBitPattern()));
        this.send(aSdu);
    }

    public void resetProcessCommand(int commonAddress, IeQualifierOfResetProcessCommand qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_RP_NA_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, new InformationObject(0, qualifier));
        this.send(aSdu);
    }

    public void delayAcquisitionCommand(int commonAddress, CauseOfTransmission cot, IeTime16 time) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_CD_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(0, time));
        this.send(aSdu);
    }

    public void testCommandWithTimeTag(int commonAddress, IeTestSequenceCounter testSequenceCounter, IeTime56 time) throws IOException {
        ASdu aSdu = new ASdu(ASduType.C_TS_TA_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, new InformationObject(0, testSequenceCounter, time));
        this.send(aSdu);
    }

    public void parameterNormalizedValueCommand(int commonAddress, int informationObjectAddress, IeNormalizedValue normalizedValue, IeQualifierOfParameterOfMeasuredValues qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.P_ME_NA_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, normalizedValue, qualifier));
        this.send(aSdu);
    }

    public void parameterScaledValueCommand(int commonAddress, int informationObjectAddress, IeScaledValue scaledValue, IeQualifierOfParameterOfMeasuredValues qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.P_ME_NB_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, scaledValue, qualifier));
        this.send(aSdu);
    }

    public void parameterShortFloatCommand(int commonAddress, int informationObjectAddress, IeShortFloat shortFloat, IeQualifierOfParameterOfMeasuredValues qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.P_ME_NC_1, false, CauseOfTransmission.ACTIVATION, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, shortFloat, qualifier));
        this.send(aSdu);
    }

    public void parameterActivation(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeQualifierOfParameterActivation qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.P_AC_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, qualifier));
        this.send(aSdu);
    }

    public void fileReady(int commonAddress, int informationObjectAddress, IeNameOfFile nameOfFile, IeLengthOfFileOrSection lengthOfFile, IeFileReadyQualifier qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_FR_NA_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, lengthOfFile, qualifier));
        this.send(aSdu);
    }

    public void sectionReady(int commonAddress, int informationObjectAddress, IeNameOfFile nameOfFile, IeNameOfSection nameOfSection, IeLengthOfFileOrSection lengthOfSection, IeSectionReadyQualifier qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_SR_NA_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, nameOfSection, lengthOfSection, qualifier));
        this.send(aSdu);
    }

    public void callOrSelectFiles(int commonAddress, CauseOfTransmission cot, int informationObjectAddress, IeNameOfFile nameOfFile, IeNameOfSection nameOfSection, IeSelectAndCallQualifier qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_SC_NA_1, false, cot, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, nameOfSection, qualifier));
        this.send(aSdu);
    }

    public void lastSectionOrSegment(int commonAddress, int informationObjectAddress, IeNameOfFile nameOfFile, IeNameOfSection nameOfSection, IeLastSectionOrSegmentQualifier qualifier, IeChecksum checksum) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_LS_NA_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, nameOfSection, qualifier, checksum));
        this.send(aSdu);
    }

    public void ackFileOrSection(int commonAddress, int informationObjectAddress, IeNameOfFile nameOfFile, IeNameOfSection nameOfSection, IeAckFileOrSectionQualifier qualifier) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_AF_NA_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, nameOfSection, qualifier));
        this.send(aSdu);
    }

    public void sendSegment(int commonAddress, int informationObjectAddress, IeNameOfFile nameOfFile, IeNameOfSection nameOfSection, IeFileSegment segment) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_SG_NA_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, nameOfSection, segment));
        this.send(aSdu);
    }

    public void sendDirectory(int commonAddress, int informationObjectAddress, InformationElement[][] directory) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_DR_TA_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, directory));
        this.send(aSdu);
    }

    public void queryLog(int commonAddress, int informationObjectAddress, IeNameOfFile nameOfFile, IeTime56 rangeStartTime, IeTime56 rangeEndTime) throws IOException {
        ASdu aSdu = new ASdu(ASduType.F_SC_NB_1, false, CauseOfTransmission.FILE_TRANSFER, false, false, this.originatorAddress, commonAddress, new InformationObject(informationObjectAddress, nameOfFile, rangeStartTime, rangeEndTime));
        this.send(aSdu);
    }

    static /* synthetic */ Socket access$700(Connection x0) {
        return x0.socket;
    }

    static /* synthetic */ CountDownLatch access$800(Connection x0) {
        return x0.startdtConSignal;
    }

    static /* synthetic */ CountDownLatch access$900(Connection x0) {
        return x0.startdtActSignal;
    }

    static /* synthetic */ CountDownLatch access$1000(Connection x0) {
        return x0.stopdtConSignal;
    }

    static /* synthetic */ IOException access$1202(Connection x0, IOException x1) {
        x0.closedIOException = x1;
        return x0.closedIOException;
    }

    static /* synthetic */ boolean access$1300(Connection x0) {
        return x0.closed;
    }

    static /* synthetic */ IOException access$1200(Connection x0) {
        return x0.closedIOException;
    }

    private class ConnectionReader
    extends Thread {
        private ConnectionReader() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 34[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void sendTestFrameCon() throws IOException {
            Connection.this.os.write(TESTFR_CON_BUFFER);
            Connection.this.os.flush();
        }

        private void closeIfStopped() {
            if (Connection.this.serverThread != null && Connection.this.stopped) {
                Connection.this.close();
                if (Connection.this.aSduListenerBack != null) {
                    Connection.this.aSduListenerBack.connectionClosed(new IOException("Got S/I-Format message while STOPDT state."));
                }
            }
        }

        private void closeThreadPool() {
            if (Connection.this.settings.useSharedThreadPool()) {
                ConnectionSettings.decrementConnectionsCounter();
            } else {
                Connection.this.executor.shutdownNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleStopDtAct() throws IOException {
            ConnectionReader connectionReader = this;
            synchronized (connectionReader) {
                Connection.this.os.write(STOPDT_CON_BUFFER);
                if (Connection.this.aSduListener != null) {
                    Connection.this.aSduListenerBack = Connection.this.aSduListener;
                    Connection.this.aSduListener = null;
                }
                Connection.this.stopped = true;
            }
            Connection.this.os.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleStartDtAct() throws IOException {
            ConnectionReader connectionReader = this;
            synchronized (connectionReader) {
                Connection.this.os.write(STARTDT_CON_BUFFER, 0, STARTDT_CON_BUFFER.length);
                if (Connection.this.aSduListener == null) {
                    Connection.this.aSduListener = Connection.this.aSduListenerBack;
                }
                Connection.this.stopped = false;
            }
            Connection.this.os.flush();
            Connection.this.resetMaxIdleTimeTimer();
        }

        private void handleIFrame(final APdu aPdu) throws IOException {
            int numUnconfirmedIPdusReceived;
            this.updateReceiveSeqNum(aPdu.getSendSeqNumber());
            this.handleReceiveSequenceNumber(aPdu.getReceiveSeqNumber());
            if (Connection.this.aSduListener != null) {
                Connection.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("aSduListener");
                        Connection.this.aSduListener.newASdu(aPdu.getASdu());
                    }
                });
            }
            if ((numUnconfirmedIPdusReceived = Connection.sequenceNumberDiff(Connection.this.receiveSequenceNumber, Connection.this.acknowledgedReceiveSequenceNumber)) >= Connection.this.settings.getMaxUnconfirmedIPdusReceived()) {
                Connection.this.sendSFormatPdu();
                if (Connection.this.maxTimeNoAckSentTimer.isPlanned()) {
                    Connection.this.maxTimeNoAckSentTimer.cancel();
                }
            } else if (!Connection.this.maxTimeNoAckSentTimer.isPlanned() || Connection.this.maxTimeNoAckSentTimer.isPlanned() && numUnconfirmedIPdusReceived == 1) {
                Connection.this.timeoutManager.addTimerTask(Connection.this.maxTimeNoAckSentTimer);
            }
        }

        private void updateReceiveSeqNum(int sendSeqNumber) throws IOException {
            this.verifySeqNumber(sendSeqNumber);
            Connection.this.receiveSequenceNumber = (sendSeqNumber + 1) % 32768;
            if (sendSeqNumber > Connection.this.receiveSequenceNumber) {
                Connection.this.sendSFormatPdu();
            }
        }

        private void verifySeqNumber(int sendSeqNumber) throws IOException {
            if (Connection.this.receiveSequenceNumber != sendSeqNumber) {
                String msg = MessageFormat.format("Got unexpected send sequence number: {0}, expected: {1}.", sendSeqNumber, Connection.this.receiveSequenceNumber);
                throw new IOException(msg);
            }
        }

        private void handleReceiveSequenceNumber(int receiveSeqNumber) throws IOException {
            if (Connection.this.acknowledgedSendSequenceNumber == receiveSeqNumber) {
                return;
            }
            int diff = Connection.sequenceNumberDiff(receiveSeqNumber, Connection.this.acknowledgedSendSequenceNumber);
            if (diff > Connection.this.getNumUnconfirmedAPdusSent()) {
                String msg = MessageFormat.format("Got unexpected receive sequence number: {0}, expected a number between: {1} and {2}.", receiveSeqNumber, Connection.this.acknowledgedSendSequenceNumber, Connection.this.sendSequenceNumber);
                throw new IOException(msg);
            }
            if (Connection.this.maxTimeNoAckReceived.isPlanned()) {
                Connection.this.maxTimeNoAckReceived.cancel();
            }
            Connection.this.acknowledgedSendSequenceNumber = receiveSeqNumber;
            if (Connection.this.sendSequenceNumber != Connection.this.acknowledgedSendSequenceNumber) {
                if (Connection.this.getNumUnconfirmedAPdusSent() > Connection.this.settings.getMaxNumOfOutstandingIPdus()) {
                    throw new IOException("Max number of outstanding IPdus is exceeded.");
                }
                Connection.this.timeoutManager.addTimerTask(Connection.this.maxTimeNoAckReceived);
            }
        }
    }

    private class MaxTimeNoAckReceivedTimer
    extends TimeoutTask {
        public MaxTimeNoAckReceivedTimer() {
            super(Connection.this.settings.getMaxTimeNoAckReceived());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            Connection connection = Connection.this;
            synchronized (connection) {
                if (Thread.interrupted()) {
                    return;
                }
                Connection.this.close();
                if (Connection.this.aSduListener != null) {
                    Connection.this.aSduListener.connectionClosed(new IOException("The maximum time that no confirmation was received (t1) has been exceeded. t1 = " + Connection.this.settings.getMaxTimeNoAckReceived() + "ms"));
                }
            }
        }
    }

    private class MaxIdleTimeTimer
    extends TimeoutTask {
        public MaxIdleTimeTimer() {
            super(Connection.this.settings.getMaxIdleTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            Connection connection = Connection.this;
            synchronized (connection) {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    Connection.this.os.write(TESTFR_ACT_BUFFER, 0, TESTFR_ACT_BUFFER.length);
                    Connection.this.os.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Connection.this.timeoutManager.addTimerTask(Connection.this.maxTimeNoTestConReceived);
            }
        }
    }

    private class MaxTimeNoAckSentTimer
    extends TimeoutTask {
        public MaxTimeNoAckSentTimer() {
            super(Connection.this.settings.getMaxTimeNoAckSent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            Connection connection = Connection.this;
            synchronized (connection) {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    Connection.this.sendSFormatPdu();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

