/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

class ConnectionSettings {
    private static final ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    private static volatile int numOpenConnections = 0;
    private int messageFragmentTimeout;
    private int cotFieldLength;
    private int commonAddressFieldLength;
    private int ioaFieldLength;
    private int maxTimeNoAckReceived;
    private int maxTimeNoAckSent;
    private int maxIdleTime;
    private int connectionTimeout;
    private int maxUnconfirmedIPdusReceived;
    private int maxNumOfOutstandingIPdus;
    private boolean useSharedThreadPool;

    public ConnectionSettings() {
        this.messageFragmentTimeout = 5000;
        this.cotFieldLength = 2;
        this.commonAddressFieldLength = 2;
        this.ioaFieldLength = 3;
        this.connectionTimeout = 30000;
        this.maxTimeNoAckReceived = 15000;
        this.maxTimeNoAckSent = 10000;
        this.maxIdleTime = 20000;
        this.maxUnconfirmedIPdusReceived = 8;
        this.maxNumOfOutstandingIPdus = 12;
        this.useSharedThreadPool = false;
    }

    public ConnectionSettings(ConnectionSettings connectionSettings) {
        this.messageFragmentTimeout = connectionSettings.messageFragmentTimeout;
        this.cotFieldLength = connectionSettings.cotFieldLength;
        this.commonAddressFieldLength = connectionSettings.commonAddressFieldLength;
        this.ioaFieldLength = connectionSettings.ioaFieldLength;
        this.maxTimeNoAckReceived = connectionSettings.maxTimeNoAckReceived;
        this.maxTimeNoAckSent = connectionSettings.maxTimeNoAckSent;
        this.maxIdleTime = connectionSettings.maxIdleTime;
        this.connectionTimeout = connectionSettings.connectionTimeout;
        this.maxUnconfirmedIPdusReceived = connectionSettings.maxUnconfirmedIPdusReceived;
        this.maxNumOfOutstandingIPdus = connectionSettings.maxNumOfOutstandingIPdus;
        this.useSharedThreadPool = connectionSettings.useSharedThreadPool;
    }

    public boolean useSharedThreadPool() {
        return this.useSharedThreadPool;
    }

    public int getMessageFragmentTimeout() {
        return this.messageFragmentTimeout;
    }

    public int getCotFieldLength() {
        return this.cotFieldLength;
    }

    public int getCommonAddressFieldLength() {
        return this.commonAddressFieldLength;
    }

    public int getIoaFieldLength() {
        return this.ioaFieldLength;
    }

    public int getMaxTimeNoAckReceived() {
        return this.maxTimeNoAckReceived;
    }

    public int getMaxTimeNoAckSent() {
        return this.maxTimeNoAckSent;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxUnconfirmedIPdusReceived() {
        return this.maxUnconfirmedIPdusReceived;
    }

    public int getMaxNumOfOutstandingIPdus() {
        return this.maxNumOfOutstandingIPdus;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setUseSharedThreadPool(boolean useSharedThreadPool) {
        this.useSharedThreadPool = useSharedThreadPool;
    }

    public void setMessageFragmentTimeout(int messageFragmentTimeout) {
        this.messageFragmentTimeout = messageFragmentTimeout;
    }

    public void setCotFieldLength(int cotFieldLength) {
        this.cotFieldLength = cotFieldLength;
    }

    public void setCommonAddressFieldLength(int commonAddressFieldLength) {
        this.commonAddressFieldLength = commonAddressFieldLength;
    }

    public void setIoaFieldLength(int ioaFieldLength) {
        this.ioaFieldLength = ioaFieldLength;
    }

    public void setMaxTimeNoAckReceived(int maxTimeNoAckReceived) {
        this.maxTimeNoAckReceived = maxTimeNoAckReceived;
    }

    public void setMaxTimeNoAckSent(int maxTimeNoAckSent) {
        this.maxTimeNoAckSent = maxTimeNoAckSent;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaxUnconfirmedIPdusReceived(int maxUnconfirmedIPdusReceived) {
        this.maxUnconfirmedIPdusReceived = maxUnconfirmedIPdusReceived;
    }

    public void setMaxNumOfOutstandingIPdus(int maxNumOfOutstandingIPdus) {
        this.maxNumOfOutstandingIPdus = maxNumOfOutstandingIPdus;
    }

    public void setConnectionTimeout(int time) {
        this.connectionTimeout = time;
    }

    public static ThreadPoolExecutor getThreadPool() {
        return threadPool;
    }

    public static synchronized void incremntConnectionsCounter() {
        ++numOpenConnections;
    }

    public static synchronized void decrementConnectionsCounter() {
        if (--numOpenConnections == 0) {
            threadPool.shutdown();
        }
    }
}

