/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import org.openmuc.j60870.CommonBuilder;
import org.openmuc.j60870.ConnectionSettings;
import org.openmuc.j60870.ServerEventListener;
import org.openmuc.j60870.ServerThread;

public class Server {
    private ServerThread serverThread;
    private final int port;
    private final InetAddress bindAddr;
    private final int backlog;
    private final ServerSocketFactory serverSocketFactory;
    private final int maxConnections;
    private final ConnectionSettings settings;
    private ExecutorService exec;

    private Server(Builder builder) {
        this.port = builder.port;
        this.bindAddr = builder.bindAddr;
        this.backlog = builder.backlog;
        this.serverSocketFactory = builder.serverSocketFactory;
        this.maxConnections = builder.maxConnections;
        this.settings = new ConnectionSettings(builder.settings);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start(ServerEventListener listener) throws IOException {
        ConnectionSettings.incremntConnectionsCounter();
        this.exec = this.settings.useSharedThreadPool() ? ConnectionSettings.getThreadPool() : Executors.newCachedThreadPool();
        this.serverThread = new ServerThread(this.serverSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddr), this.settings, this.maxConnections, listener, this.exec);
        this.exec.execute(this.serverThread);
    }

    public void stop() {
        if (this.serverThread == null) {
            return;
        }
        this.serverThread.stopServer();
        if (this.settings.useSharedThreadPool()) {
            ConnectionSettings.decrementConnectionsCounter();
        } else {
            this.exec.shutdown();
        }
        this.serverThread = null;
    }

    public static class Builder
    extends CommonBuilder<Builder, Server> {
        private int port = 2404;
        private InetAddress bindAddr = null;
        private int backlog = 0;
        private ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
        private int maxConnections = 100;

        private Builder() {
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setBacklog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        public Builder setBindAddr(InetAddress bindAddr) {
            this.bindAddr = bindAddr;
            return this;
        }

        public Builder setSocketFactory(ServerSocketFactory socketFactory) {
            this.serverSocketFactory = socketFactory;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections <= 0) {
                throw new IllegalArgumentException("maxConnections is out of bound");
            }
            this.maxConnections = maxConnections;
            return this;
        }

        @Override
        public Server build() {
            return new Server(this);
        }
    }
}

