/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.openmuc.j60870.Connection;
import org.openmuc.j60870.ConnectionSettings;
import org.openmuc.j60870.ServerEventListener;

class ServerThread
implements Runnable {
    private final ServerSocket serverSocket;
    private final ConnectionSettings settings;
    private final int maxConnections;
    private final ServerEventListener serverSapListener;
    private volatile boolean stopServer = false;
    private int numConnections = 0;
    private final ExecutorService executor;

    ServerThread(ServerSocket serverSocket, ConnectionSettings settings, int maxConnections, ServerEventListener serverSapListener, ExecutorService exec) {
        this.serverSocket = serverSocket;
        this.settings = settings;
        this.maxConnections = maxConnections;
        this.serverSapListener = serverSapListener;
        this.executor = exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("ServerThread");
        Socket clientSocket = null;
        while (!this.stopServer) {
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (!this.stopServer) {
                    this.serverSapListener.serverStoppedListeningIndication(e);
                }
                return;
            }
            boolean startConnection = false;
            ServerThread serverThread = this;
            synchronized (serverThread) {
                if (this.numConnections < this.maxConnections) {
                    ++this.numConnections;
                    startConnection = true;
                }
            }
            if (startConnection) {
                ConnectionHandler connectionHandler = new ConnectionHandler(clientSocket, this);
                this.executor.execute(connectionHandler);
                continue;
            }
            this.serverSapListener.connectionAttemptFailed(new IOException("Maximum number of connections reached. Ignoring connection request. Maximum number of connections: " + this.maxConnections));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosedSignal() {
        ServerThread serverThread = this;
        synchronized (serverThread) {
            --this.numConnections;
        }
    }

    void stopServer() {
        this.stopServer = true;
        if (this.serverSocket.isBound()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ConnectionHandler
    implements Runnable {
        private final Socket socket;
        private final ServerThread serverThread;

        public ConnectionHandler(Socket socket, ServerThread serverThread2) {
            this.socket = socket;
            this.serverThread = serverThread2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection serverConnection;
            Thread.currentThread().setName("ConnectionHandler");
            try {
                serverConnection = new Connection(this.socket, this.serverThread, ServerThread.this.settings);
            }
            catch (IOException e) {
                ServerThread serverThread = ServerThread.this;
                synchronized (serverThread) {
                    ServerThread.this.numConnections--;
                }
                ServerThread.this.serverSapListener.connectionAttemptFailed(e);
                return;
            }
            ServerThread.this.serverSapListener.connectionIndication(serverConnection);
        }
    }
}

