/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

import java.util.concurrent.PriorityBlockingQueue;
import org.openmuc.j60870.TimeoutTask;

class TimeoutManager
implements Runnable {
    private final PriorityBlockingQueue<TimeoutTask> queue = new PriorityBlockingQueue(4);
    private final Object guadedLock = new Object();
    boolean canceled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimerTask(TimeoutTask task) {
        task.updateDueTime();
        this.removeDuplicates(task);
        this.queue.add(task);
        Object object = this.guadedLock;
        synchronized (object) {
            this.guadedLock.notifyAll();
        }
    }

    private void removeDuplicates(TimeoutTask task) {
        while (this.queue.remove(task)) {
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("TimeoutManager");
        while (!this.canceled) {
            try {
                long sleepMillis;
                TimeoutTask currTask = this.queue.take();
                while ((sleepMillis = currTask.sleepTimeFromDueTime()) > 0L) {
                    this.queue.put(currTask);
                    Object object = this.guadedLock;
                    synchronized (object) {
                        this.guadedLock.wait(sleepMillis);
                    }
                    currTask = this.queue.take();
                }
                currTask.manExec();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

