/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870;

abstract class TimeoutTask
implements Comparable<TimeoutTask> {
    private final int timeout;
    private long dueTime;
    private boolean canceled;
    private boolean done;

    public TimeoutTask(int timeout) {
        this.timeout = timeout;
        this.done = false;
        this.canceled = false;
        this.dueTime = 0L;
    }

    void manExec() {
        if (this.canceled) {
            return;
        }
        try {
            this.execute();
        }
        finally {
            this.done = true;
        }
    }

    void updateDueTime() {
        this.dueTime = System.currentTimeMillis() + (long)this.timeout;
        this.canceled = false;
        this.done = false;
    }

    protected abstract void execute();

    public boolean isPlanned() {
        return !this.canceled && !this.done && this.dueTime != 0L;
    }

    public boolean isDone() {
        return this.done;
    }

    public void cancel() {
        this.canceled = true;
    }

    public long sleepTimeFromDueTime() {
        return this.dueTime - System.currentTimeMillis();
    }

    @Override
    public int compareTo(TimeoutTask o) {
        return Long.compare(this.dueTime, o.dueTime);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeoutTask)) {
            return false;
        }
        TimeoutTask o = (TimeoutTask)obj;
        return this.dueTime == o.dueTime && this.canceled == o.canceled && this.done == o.done && this.timeout == o.timeout;
    }

    public int hashCode() {
        return this.timeout ^ Boolean.valueOf(this.canceled).hashCode() << 2 ^ Boolean.valueOf(this.done).hashCode();
    }
}

