/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

abstract class IeAbstractQualifierOfCommand
extends InformationElement {
    protected int value;

    IeAbstractQualifierOfCommand(int qualifier, boolean select) {
        if (qualifier < 0 || qualifier > 31) {
            throw new IllegalArgumentException("Qualifier is out of bound: " + qualifier);
        }
        this.value = qualifier << 2;
        if (select) {
            this.value |= 0x80;
        }
    }

    IeAbstractQualifierOfCommand(DataInputStream is) throws IOException {
        this.value = is.readByte() & 0xFF;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        return 1;
    }

    public boolean isSelect() {
        return (this.value & 0x80) == 128;
    }

    public int getQualifier() {
        return this.value >> 2 & 0x1F;
    }

    @Override
    public String toString() {
        return "selected: " + this.isSelect() + ", qualifier: " + this.getQualifier();
    }
}

