/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.openmuc.j60870.ie.InformationElement;

abstract class IeAbstractQuality
extends InformationElement {
    protected int value;

    public IeAbstractQuality(boolean blocked, boolean substituted, boolean notTopical, boolean invalid) {
        this.value = 0;
        if (blocked) {
            this.value |= 0x10;
        }
        if (substituted) {
            this.value |= 0x20;
        }
        if (notTopical) {
            this.value |= 0x40;
        }
        if (invalid) {
            this.value |= 0x80;
        }
    }

    IeAbstractQuality(DataInputStream is) throws IOException {
        this.value = is.readUnsignedByte();
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        return 1;
    }

    public boolean isBlocked() {
        return this.hasBitSet(16);
    }

    public boolean isSubstituted() {
        return this.hasBitSet(32);
    }

    public boolean isNotTopical() {
        return this.hasBitSet(64);
    }

    public boolean isInvalid() {
        return this.hasBitSet(128);
    }

    private boolean hasBitSet(int mask) {
        return (this.value & mask) == mask;
    }

    @Override
    public String toString() {
        return MessageFormat.format("blocked: {0}, substituted: {1}, not topical: {2}, invalid: {3}", this.isBlocked(), this.isSubstituted(), this.isNotTopical(), this.isInvalid());
    }
}

