/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.openmuc.j60870.ie.InformationElement;
import org.openmuc.j60870.internal.ExtendedDataInputStream;

public class IeBinaryCounterReading
extends InformationElement {
    private final int counterReading;
    private final int sequenceNumber;
    private final Set<Flag> flags;

    public IeBinaryCounterReading(int counterReading, int sequenceNumber, Set<Flag> flags) {
        this.counterReading = counterReading;
        this.sequenceNumber = sequenceNumber;
        this.flags = flags;
    }

    public IeBinaryCounterReading(int counterReading, int sequenceNumber) {
        this(counterReading, sequenceNumber, EnumSet.noneOf(Flag.class));
    }

    public IeBinaryCounterReading(int counterReading, int sequenceNumber, Flag firstFlag, Flag ... flag) {
        this(counterReading, sequenceNumber, EnumSet.of(firstFlag, flag));
    }

    static IeBinaryCounterReading decode(ExtendedDataInputStream is) throws IOException {
        int counterReading = is.readLittleEndianInt();
        byte b0 = is.readByte();
        int sequenceNumber = b0 & 0x1F;
        Set flags = Flag.flagsFor(b0);
        return new IeBinaryCounterReading(counterReading, sequenceNumber, flags);
    }

    @Override
    int encode(byte[] buffer, int i) {
        ByteBuffer buf = ByteBuffer.wrap(buffer, i, buffer.length - i);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(this.counterReading).put(this.seq());
        return buf.position() - i;
    }

    private byte seq() {
        byte v = (byte)this.sequenceNumber;
        for (Flag flag : this.flags) {
            v = (byte)(v | flag.mask);
        }
        return v;
    }

    public int getCounterReading() {
        return this.counterReading;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public String toString() {
        return "Binary counter reading: " + this.counterReading + ", seq num: " + this.sequenceNumber + ", flags: " + this.flags;
    }

    public static enum Flag {
        CARRY(32),
        COUNTER_ADJUSTED(64),
        INVALID(128);

        private int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        private static Set<Flag> flagsFor(byte b) {
            EnumSet<Flag> s = EnumSet.allOf(Flag.class);
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                int mask2 = ((Flag)((Object)iter.next())).mask;
                if ((mask2 & b) == mask2) continue;
                iter.remove();
            }
            return s;
        }
    }
}

